/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.http.resourcebundle;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoHttpMethodSetting]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoHttpMethodSettingResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoHttpMethodSettingResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoHttpMethodSetting]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoHttpMethodSettingResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoHttpMethodSetting");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoHttpMethodSettingResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoHttpMethodSetting]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoHttpMethodSettingResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoHttpMethodSetting", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoHttpMethodSettingResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoHttpMethodSetting]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoHttpMethodSettingResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoHttpMethodSetting", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoHttpMethodSetting], key[PROXY_HOST]
     *
     * [] (ja)<br>
     *
     * @return key[PROXY_HOST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getProxyHost() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("PROXY_HOST");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoHttpMethodSetting], key[PROXY_PORT]
     *
     * [80] (ja)<br>
     *
     * @return key[PROXY_PORT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getProxyPort() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "80";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("PROXY_PORT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoHttpMethodSetting], key[PROXY_USER_NAME]
     *
     * [] (ja)<br>
     *
     * @return key[PROXY_USER_NAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getProxyUserName() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("PROXY_USER_NAME");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoHttpMethodSetting], key[PROXY_PASSWORD]
     *
     * [] (ja)<br>
     *
     * @return key[PROXY_PASSWORD]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getProxyPassword() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("PROXY_PASSWORD");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoHttpMethodSetting], key[CONNECTION_TIMEOUT]
     *
     * [10000] (ja)<br>
     *
     * @return key[CONNECTION_TIMEOUT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getConnectionTimeout() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "10000";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CONNECTION_TIMEOUT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoHttpMethodSetting], key[CONNECTION_SO_TIMEOUT]
     *
     * [-1] (ja)<br>
     *
     * @return key[CONNECTION_SO_TIMEOUT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getConnectionSoTimeout() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "-1";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("CONNECTION_SO_TIMEOUT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoHttpMethodSetting], key[METHOD_RETRY_COUNT]
     *
     * [3] (ja)<br>
     *
     * @return key[METHOD_RETRY_COUNT]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMethodRetryCount() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "3";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METHOD_RETRY_COUNT");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
