/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.http;

import java.io.IOException;
import java.net.ConnectException;

import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpMethodParams;

import blanco.commons.util.BlancoStringUtil;
import blanco.http.resourcebundle.BlancoHttpMethodMessageResourceBundle;
import blanco.http.valueobject.BlancoHttpMethodSetting;

/**
 * Jakarta Http Components  HttpClient 𗘗p http擾B
 * 
 * publicȃNXƂȂĂ܂B
 * 
 * Jakarta Commons Http Client
 * http://jakarta.apache.org/httpcomponents/httpclient-3.x/index.html
 * 
 * http://jakarta.apache.org/httpcomponents/httpclient-3.x/tutorial.html
 * 
 * http://jakarta.apache.org/httpcomponents/httpclient-3.x/apidocs/
 * 
 * @author IGA Tosiki
 */
class BlancoHttpMethodImplJakartaHttp implements BlancoHttpMethod {
    /**
     * blancoHttpMethodbZ[WNXB
     */
    protected final BlancoHttpMethodMessageResourceBundle fMsg = new BlancoHttpMethodMessageResourceBundle();

    /**
     * ^ꂽURIHTTPoR html擾܂B
     * 
     * @param argSetting
     *            blancoHttpMethod̊eݒ킷o[IuWFNgB()̃NX̃CX^X
     *            BlancoHttpMethodSettingFactory NX擾ĂB
     * @param argUri
     *            擾ΏۂƂȂURIB
     * @return 擾ꂽ htmlt@CB
     * @throws ConnectException
     *             WebT[oւ̐ڑsɊւOB
     * @throws IOException
     *             Webf[^MsɊւOB
     */
    public byte[] get(final BlancoHttpMethodSetting argSetting,
            final String argUri) throws ConnectException, IOException {
        // TODO \bh̃p[^`FbNǉ邱ƁB߂ȂOsB

        final HttpClient client = new HttpClient();

        // vLV֘ÃZbgAbv{܂B
        setupProxy(argSetting, client);

        // RlNṼZbgAbv{܂B
        setupConnection(argSetting, client);

        final GetMethod method = new GetMethod(argUri);

        try {
            // \bh̃ZbgAbv{܂B
            setupMethod(argSetting, method);

            try {
                // \bhs܂B
                int statusCode = client.executeMethod(method);

                if (statusCode != HttpStatus.SC_OK) {
                    // TODO O𐮗邱ƁB
                    System.err.println("QbgɎs: " + method.getStatusLine());
                }
            } catch (ConnectTimeoutException e) {
                // ڑ^CAEgł́AɓĂ܂B
                // org.apache.commons.httpclient.ConnectTimeoutException 
                // ConnectException ɓǂݑւ܂B
                throw new ConnectException(fMsg.getMbhmj001(e.toString()));
            } catch (HttpException e) {
                // TODO ꂽ catch ubN
                e.printStackTrace();
            } catch (IOException e) {
                // TODO ꂽ catch ubN
                e.printStackTrace();
            }

            {
                final Header[] header = method.getRequestHeaders();
                // TODO wb_[LqB
                for (int index = 0; index < header.length; index++) {
                    System.out.println("req:" + header[index]);
                }
            }

            {
                // wb_[o܂B
                final Header[] header = method.getResponseHeaders();
                // TODO wb_[LqB
                for (int index = 0; index < header.length; index++) {
                    System.out.println("res:" + header[index]);
                }
            }

            try {
                // X|X{̂ǂݍ݂܂B
                byte[] responseBody = method.getResponseBody();
                return responseBody;
            } catch (IOException e) {
                // TODO ꂽ catch ubN
                e.printStackTrace();
            }
        } finally {
            // RlNVJ܂B
            method.releaseConnection();
        }

        // 擾ł܂łBnull߂܂B
        // TODO {I null߂oHȂƁB
        return null;
    }

    /**
     * vLV֘ÃZbgAbv{܂B
     * 
     * @param argSetting
     *            blancoHttpMethod̊eݒ킷o[IuWFNgB()̃NX̃CX^X
     *            BlancoHttpMethodSettingFactory NX擾ĂB
     * @param argClient
     */
    protected void setupProxy(final BlancoHttpMethodSetting argSetting,
            final HttpClient argClient) {
        if (BlancoStringUtil.null2Blank(argSetting.getProxyHost()).length() > 0) {
            // PROXY_HOST̐ݒ肪L̏ꍇɂ́AHttpClientɃZbg܂B
            argClient.getHostConfiguration().setProxy(
                    argSetting.getProxyHost(), argSetting.getProxyPort());
        }

        if (BlancoStringUtil.null2Blank(argSetting.getProxyUserName()).length() > 0) {
            // PROXY_USER_NAME̐ݒ肪L̏ꍇɂ́AHttpClientɃZbg܂B
            final Credentials creds = new UsernamePasswordCredentials(
                    argSetting.getProxyUserName(), argSetting
                            .getProxyPassword());
            // ǂȏꍇɂPROXYݒœ삷悤ɂȂĂ܂B
            argClient.getState().setProxyCredentials(AuthScope.ANY, creds);

            // TODO Proxy̔Fؕ (x[VbNF)ƂIȂĂ͂ȂȂm܂B
            // TODO Ƃ̂AOɉ񂪏o͂Ă邩łB
        }
    }

    /**
     * RlNṼZbgAbv{܂B
     * 
     * @param argSetting
     *            blancoHttpMethod̊eݒ킷o[IuWFNgB()̃NX̃CX^X
     *            BlancoHttpMethodSettingFactory NX擾ĂB
     * @param argClient
     */
    protected void setupConnection(final BlancoHttpMethodSetting argSetting,
            final HttpClient argClient) {
        if (argSetting.getConnectionTimeout() >= 0) {
            // ڑ^CAEgݒ肵܂B
            argClient.getHttpConnectionManager().getParams()
                    .setConnectionTimeout(argSetting.getConnectionTimeout());
        }

        if (argSetting.getConnectionSoTimeout() >= 0) {
            // \Pbg^CAEgݒ肵܂B
            argClient.getParams().setSoTimeout(
                    argSetting.getConnectionSoTimeout());
        }
    }

    /**
     * \bh̃ZbgAbv{܂B
     * 
     * @param argSetting
     *            blancoHttpMethod̊eݒ킷o[IuWFNgB()̃NX̃CX^X
     *            BlancoHttpMethodSettingFactory NX擾ĂB
     * @param argMethod
     */
    protected void setupMethod(final BlancoHttpMethodSetting argSetting,
            final HttpMethodBase argMethod) {
        argMethod.getParams().setParameter(
                HttpMethodParams.RETRY_HANDLER,
                new DefaultHttpMethodRetryHandler(argSetting
                        .getMethodRetryCount(), false));

        // G[WFgݒ肵܂B
        // TODO G[WFg͊OύX\ɂ邱ƁB
        // TODO blancoWebCrawler̃z[y[W쐬邱ƁBāAURLXV邱ƁB
        argMethod
                .getParams()
                .setParameter(
                        HttpMethodParams.USER_AGENT,
                        "blancoWebCrawler/0.1 (+http://hp.vector.co.jp/authors/VA027994/blanco/blanco.ja.html)");
    }
}
