/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core;

import java.io.IOException;
import java.net.ConnectException;

import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailSetting;
import blanco.mail.core.valueobject.BlancoMailStatistics;

/**
 * [MC^tF[XB
 * 
 * blancoMailCorẽ[M̃C^tF[Xdl܂B
 * NX擾邽߂ɂ́ABlancoMailReceiverFactory#getInstance 𗘗p܂B
 * 
 * @author IGA Tosiki
 */
public interface BlancoMailReceiver {
    /**
     * [T[oAŏ̃[bZ[WM܂B
     * 
     * M[ [T[o폜܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @return M[{̂킷o[IuWFNgB̃IuWFNgɃ[̖{∶Ȃǂ̏񂪓܂BP[MȂꍇɂ
     *         null ߂܂B
     * @throws ConnectException
     *             [T[oւ̐ڑsɊւOB
     * @throws IOException
     *             [f[^̎MsɊւOB
     */
    BlancoMailMessage receive(final BlancoMailSetting argSetting)
            throws ConnectException, IOException;

    /**
     * v擾̂߂̃o[IuWFNgZbg܂B
     * 
     * @param argStatistics
     *            vB
     */
    void setStatistics(final BlancoMailStatistics argStatistics);

    /**
     * v擾̂߂̃o[IuWFNgQbg܂B
     * 
     * @return vB
     */
    BlancoMailStatistics getStatistics();
}