/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import blanco.commons.util.BlancoStringUtil;
import blanco.log.BlancoLogBinaryLogger;
import blanco.mail.core.resourcebundle.BlancoMailCoreMessageResourceBundle;
import blanco.mail.core.valueobject.BlancoMailAddress;
import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailMessageAttachment;
import blanco.mail.core.valueobject.BlancoMailMessageHeader;
import blanco.mail.core.valueobject.BlancoMailSetting;

/**
 * blancoMailCorê߂̃eXgX^uNXB
 * 
 * IȋʃNX̂߁ApublicNXƂ܂B
 * 
 * @author IGA Tosiki
 */
class BlancoMailTestStub {
    /**
     * blancoMailCorebZ[WNXB
     */
    protected final BlancoMailCoreMessageResourceBundle fMsg = new BlancoMailCoreMessageResourceBundle();

    /**
     * eXg[hł̃[MȂ܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argMessage
     *            M[{̂킷o[IuWFNgB
     * @throws IOException
     *             o͗OꍇB
     */
    public void send(final BlancoMailSetting argSetting,
            final BlancoMailMessage argMessage) throws IOException {
        System.out.println(fMsg.getMbmcs901());

        // Mf[^MOB
        // TODO eXg[h̎ύXꍇɂ́AɕύX悤ɂ܂B
        if (BlancoStringUtil.null2Blank(
                argSetting.getTestModeLogDirectorySend()).length() > 0) {
            final ByteArrayOutputStream outWorkByteArrayOutputStream = new ByteArrayOutputStream();
            final BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(outWorkByteArrayOutputStream));
            writer.write("From: " + addrToString(argMessage.getFrom()));
            writer.newLine();
            for (int index = 0; index < argMessage.getTo().size(); index++) {
                final BlancoMailAddress addr = (BlancoMailAddress) argMessage
                        .getTo().get(index);
                writer.write("To: " + addrToString(addr));
                writer.newLine();
            }
            for (int index = 0; index < argMessage.getCc().size(); index++) {
                final BlancoMailAddress addr = (BlancoMailAddress) argMessage
                        .getCc().get(index);
                writer.write("Cc: " + addrToString(addr));
                writer.newLine();
            }
            for (int index = 0; index < argMessage.getBcc().size(); index++) {
                final BlancoMailAddress addr = (BlancoMailAddress) argMessage
                        .getBcc().get(index);
                writer.write("Bcc: " + addrToString(addr));
                writer.newLine();
            }
            if (argMessage.getReplyTo() != null) {
                writer.write("ReplyTo: "
                        + addrToString(argMessage.getReplyTo()));
                writer.newLine();
            }

            writer.write("Date: " + argMessage.getSentDate().toString());
            writer.newLine();

            for (int index = 0; index < argMessage.getHeaderList().size(); index++) {
                final BlancoMailMessageHeader header = (BlancoMailMessageHeader) argMessage
                        .getHeaderList().get(index);
                writer.write(header.getName() + ":" + header.getValue());
                writer.newLine();
            }

            for (int index = 0; index < argMessage.getAttachmentList().size(); index++) {
                final BlancoMailMessageAttachment attachment = (BlancoMailMessageAttachment) argMessage
                        .getAttachmentList().get(index);
                writer.write("X-Attach: " + attachment.getFileName() + " ("
                        + attachment.getData().length + " byte) ["
                        + attachment.getMimeType() + "]");
                writer.newLine();
            }

            writer.write("Subject: " + argMessage.getSubject());
            writer.newLine();
            writer.write("Text: " + argMessage.getText());
            writer.newLine();

            writer.close();

            final BlancoLogBinaryLogger logger = new BlancoLogBinaryLogger(
                    argSetting.getTestModeLogDirectorySend(), "mail", "s",
                    "log");
            try {
                logger.log(outWorkByteArrayOutputStream.toByteArray());
            } catch (IOException e) {
                new IOException(fMsg.getMbmcs902(e.toString()));
            }
        }
    }

    /**
     * eXg[hł̃[MȂ܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @return blancoMailMessage
     *         M[{̂킷o[IuWFNgB̃IuWFNgɃ[̖{∶Ȃǂ̏񂪓܂B
     */
    public BlancoMailMessage receive(final BlancoMailSetting argSetting) {
        System.out.println(fMsg.getMbmcr901());

        // Mf[^͖̂ƂďB
        // Mf[^̃fBNgɂẮAΉ@\͌ݎĂ܂B
        // TODO eXg[h̎ύXꍇɂ́AɕύX悤ɂ܂B
        return null;
    }

    /**
     * ^ꂽAhX̕`擾܂B
     * 
     * @param argAddr
     *            [AhXB
     * @return [AhX̕`B
     */
    private String addrToString(final BlancoMailAddress argAddr) {
        if (argAddr.getPersonal() == null) {
            return argAddr.getAddress();
        } else {
            return argAddr.getPersonal() + " <" + argAddr.getAddress() + ">";
        }
    }
}
