/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core;

import junit.framework.TestCase;
import blanco.mail.core.valueobject.BlancoMailAddress;
import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailMessageAttachment;
import blanco.mail.core.valueobject.BlancoMailSetting;

public class BlancoMailSenderTest extends TestCase {
    /**
     * T^IȐݒl擾܂B
     * 
     * @return
     */
    private BlancoMailSetting getSetting() {
        final BlancoMailSetting setting = BlancoMailSettingFactory
                .getInstance();
        if (true) {
            // ݒl BlancoMailSetting.properties 擾܂B
        } else {
            setting.setSendHost("localhost");
            setting.setSendUserName("userName");
            setting.setSendPassword("password");
        }

        return setting;
    }

    /**
     * T^IȃbZ[W擾܂B
     * 
     * @return
     */
    private BlancoMailMessage getMessage() {
        final BlancoMailMessage message = new BlancoMailMessage();

        final BlancoMailAddress addrFrom = new BlancoMailAddress();
        addrFrom.setAddress(BlancoMailTestConstants.MAIL_SEND_FROM_ADDR);
        message.setFrom(addrFrom);

        final BlancoMailAddress addrTo1 = new BlancoMailAddress();
        addrTo1.setAddress(BlancoMailTestConstants.MAIL_SEND_TO_ADDRS[0]);
        message.getTo().add(addrTo1);

        final BlancoMailAddress addrTo2 = new BlancoMailAddress();
        addrTo2.setAddress(BlancoMailTestConstants.MAIL_SEND_TO_ADDRS[1]);
        message.getTo().add(addrTo2);

        final BlancoMailAddress addrCc1 = new BlancoMailAddress();
        addrCc1.setAddress(BlancoMailTestConstants.MAIL_SEND_CC_ADDRS[0]);
        message.getCc().add(addrCc1);

        final BlancoMailAddress addrCc2 = new BlancoMailAddress();
        addrCc2.setAddress(BlancoMailTestConstants.MAIL_SEND_CC_ADDRS[1]);
        message.getCc().add(addrCc2);

        final BlancoMailAddress addrBcc1 = new BlancoMailAddress();
        addrBcc1.setAddress(BlancoMailTestConstants.MAIL_SEND_BCC_ADDRS[0]);
        message.getBcc().add(addrBcc1);

        message.setSubject("[blanco] eXg[");
        message.setText("{");

        return message;
    }

    /**
     * ̓`FbNnBBlancoMailMessage̒lB
     * 
     * MBMCS001  MBMCS024
     * 
     * @throws Exception
     */
    public void testSendInput() throws Exception {
        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.setFrom(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS001") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.setTo(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS002") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.getTo().clear();
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS003") >= 0);
        }

        if (false) {
            // {Ƀ[𑗕t邱Ƃh܂B
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            // El(n)B
            setting.setSendMaxRecipientAddrTo(2);
            BlancoMailSenderFactory.getInstance().send(setting, message);
        }
        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            setting.setSendMaxRecipientAddrTo(1);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS004") >= 0);
        }

        if (false) {
            // {Ƀ[𑗕t邱Ƃh܂B
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            // El(n)B
            setting.setSendMaxRecipientAddrCc(2);
            BlancoMailSenderFactory.getInstance().send(setting, message);
        }
        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            setting.setSendMaxRecipientAddrCc(1);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS005") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.setText(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS006") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.setHeaderList(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS007") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.getHeaderList().add(setting);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS008") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.setSubject(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS009") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.setSubject("");
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS010") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.getTo().add(setting);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS011") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailAddress addrDup = new BlancoMailAddress();
            addrDup.setAddress(BlancoMailTestConstants.MAIL_SEND_TO_ADDRS[0]);
            message.getTo().add(addrDup);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS012") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.getCc().add(setting);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS013") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailAddress addrDup = new BlancoMailAddress();
            addrDup.setAddress(BlancoMailTestConstants.MAIL_SEND_CC_ADDRS[0]);
            message.getCc().add(addrDup);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS014") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.getBcc().add(setting);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS015") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailAddress addrDup = new BlancoMailAddress();
            addrDup.setAddress(BlancoMailTestConstants.MAIL_SEND_BCC_ADDRS[0]);
            message.getBcc().add(addrDup);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS016") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.setAttachmentList(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS017") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            message.getAttachmentList().add(setting);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS018") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();
            attachment.setFileName("aaa.txt");
            message.getAttachmentList().add(attachment);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS019") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();
            attachment.setData("".getBytes());
            attachment.setMimeType(null);
            attachment.setFileName("aaa.txt");
            message.getAttachmentList().add(attachment);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS020") >= 0);
        }
        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();
            attachment.setData("".getBytes());
            attachment.setMimeType("");
            attachment.setFileName("aaa.txt");
            message.getAttachmentList().add(attachment);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS020") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();
            attachment.setData("".getBytes());
            message.getAttachmentList().add(attachment);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS021") >= 0);
        }
        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();
            attachment.setData("".getBytes());
            attachment.setFileName("");
            message.getAttachmentList().add(attachment);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS021") >= 0);
        }

        if (false) {
            // {Ƀ[𑗕t邱Ƃh܂B
            // El(n)B
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();
            setting.setSendMaxTotalAttachmentSize(6);
            attachment.setData("".getBytes("Shift_JIS"));
            attachment.setFileName("aaa.txt");
            message.getAttachmentList().add(attachment);
            BlancoMailSenderFactory.getInstance().send(setting, message);
        }
        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();
            setting.setSendMaxTotalAttachmentSize(5);
            attachment.setData("".getBytes("Shift_JIS"));
            attachment.setFileName("aaa.txt");
            message.getAttachmentList().add(attachment);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS022") >= 0);
        }

        try {
            final BlancoMailMessage message = getMessage();
            BlancoMailSenderFactory.getInstance().send(null, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS023") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            BlancoMailSenderFactory.getInstance().send(setting, null);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS024") >= 0);
        }
    }

    /**
     * ̓`FbNnBBlancoMailSettingݒlB
     * 
     * MBMCS101  MBMCS106
     * 
     * @throws Exception
     */
    public void testSendSetting() throws Exception {
        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            // ُlݒ
            setting.setSendHost(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS101") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            // ُlݒ
            setting.setSendUserName(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS102") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            // ُlݒ
            setting.setSendPassword(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS103") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            // ُlݒ
            setting.setSendMailerName(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS104") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            // ُlݒ
            setting.setSendEncoding(null);
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS105") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            // ُlݒ
            setting.setSendEncoding("USO-2022-JP");
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (IllegalArgumentException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS106") >= 0);
        }
    }
}
