/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core.connect;

import java.io.IOException;
import java.net.ConnectException;

import junit.framework.TestCase;
import blanco.mail.core.BlancoMailSenderFactory;
import blanco.mail.core.BlancoMailSettingFactory;
import blanco.mail.core.BlancoMailTestConstants;
import blanco.mail.core.valueobject.BlancoMailAddress;
import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailSetting;

/**
 * ӁI
 * 
 * JUnitR[hsƁA[T[oւ̐ڑۂɍs܂B
 * 
 * JUnitR[hs邱Ƃ ܂BeǂŁAp̃[T[oȂǂĂs悤ɂĂB
 * 
 * @author IGA Tosiki
 */
public class BlancoMailSenderConnectTest extends TestCase {
    /**
     * T^IȐݒl擾܂B
     * 
     * @return
     */
    private BlancoMailSetting getSetting() {
        final BlancoMailSetting setting = BlancoMailSettingFactory
                .getInstance();
        if (true) {
            // ݒl BlancoMailSetting.properties 擾܂B
        } else {
            setting.setSendHost("localhost");
            setting.setSendUserName("userName");
            setting.setSendPassword("password");
        }

        return setting;
    }

    /**
     * T^IȃbZ[W擾܂B
     * 
     * @return
     */
    private BlancoMailMessage getMessage() {
        final BlancoMailMessage message = new BlancoMailMessage();

        final BlancoMailAddress addrFrom = new BlancoMailAddress();
        addrFrom.setAddress(BlancoMailTestConstants.MAIL_SEND_FROM_ADDR);
        message.setFrom(addrFrom);

        final BlancoMailAddress addrTo1 = new BlancoMailAddress();
        addrTo1.setAddress(BlancoMailTestConstants.MAIL_SEND_TO_ADDRS[0]);
        message.getTo().add(addrTo1);

        final BlancoMailAddress addrTo2 = new BlancoMailAddress();
        addrTo2.setAddress(BlancoMailTestConstants.MAIL_SEND_TO_ADDRS[1]);
        message.getTo().add(addrTo2);

        final BlancoMailAddress addrCc1 = new BlancoMailAddress();
        addrCc1.setAddress(BlancoMailTestConstants.MAIL_SEND_CC_ADDRS[0]);
        message.getCc().add(addrCc1);

        final BlancoMailAddress addrCc2 = new BlancoMailAddress();
        addrCc2.setAddress(BlancoMailTestConstants.MAIL_SEND_CC_ADDRS[1]);
        message.getCc().add(addrCc2);

        final BlancoMailAddress addrBcc1 = new BlancoMailAddress();
        addrBcc1.setAddress(BlancoMailTestConstants.MAIL_SEND_BCC_ADDRS[0]);
        message.getBcc().add(addrBcc1);

        message.setSubject("[blanco] eXg[");
        message.setText("{");

        return message;
    }

    /**
     * ڑnB
     * 
     * MBMCS201  MBMCS204
     * 
     * TODO MBMCS301 MBMCS304MBMCS901 _łJUnit{B
     * 
     * @throws Exception
     */
    public void testSendConnect() throws Exception {
        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            setting.setSendProtocol("usotp");
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (ConnectException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS201") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            setting.setSendUserName("notexist");
            setting.setSendUserName("failpassword");
            BlancoMailSenderFactory.getInstance().send(setting, message);

            // SMTPF؂T|[gT[oɂẮȀꏊSMTPF؂ɂڑG[B
            // fail("ׂOĂ܂B");
        } catch (ConnectException e) {
            // SMTPF؂T|[gT[oœmF{BK؂ɒʉ߂邱ƂmF
            // [T[oւTCPڑ̂̂sƁA̎eXg͎s܂B
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS202") >= 0);
        }

        try {
            final BlancoMailSetting setting = getSetting();
            final BlancoMailMessage message = getMessage();
            // ݂ȂzXgB
            setting.setSendHost("localhost.notexist");
            BlancoMailSenderFactory.getInstance().send(setting, message);
            fail("ׂOĂ܂B");
        } catch (ConnectException e) {
            assertTrue("bZ[WID`FbN", e.getMessage().indexOf("MBMCS203") >= 0);
        }
    }

    /**
     * ^CAEgn̎B
     * 
     * JUnit̓T[oɂ̓ȕׂ\܂B
     * 
     * @throws Exception
     */
    public void testSendTimeout() throws Exception {
        if (false)
            try {
                final BlancoMailSetting setting = getSetting();
                final BlancoMailMessage message = getMessage();
                // ڑ^CAEg͊Ŕ肵Ȃ肵܂B
                // setting.setMailConnectionTimeout(1);
                setting.setMailTimeout(1);
                BlancoMailSenderFactory.getInstance().send(setting, message);
                fail("ׂOĂ܂B");
            } catch (IOException e) {
                assertTrue("bZ[WID`FbN",
                        e.getMessage().indexOf("MBMCS301") >= 0);
                // ̌oHʉ߂ꍇɂ́AMBMCS302 Iɔꍇ܂B ˑ̂̂ƂȂ܂B
            }
    }
}
