/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core.mobilephone;

import java.io.IOException;
import java.net.ConnectException;

import blanco.mail.core.BlancoMailSenderFactory;
import blanco.mail.core.BlancoMailSettingFactory;
import blanco.mail.core.valueobject.BlancoMailAddress;
import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailSetting;

/**
 * p^[1B
 */
public class BlancoMailMobilePhoneTestSender011 {
    public static void main(final String[] args) throws ConnectException,
            IOException {
        final BlancoMailSetting setting = BlancoMailSettingFactory
                .getInstance();
        if (true) {
            // ݒl BlancoMailSetting.properties 擾܂B
        } else {
            // setting.setSendHost("smtp.gmail.com");
            // setting.setSendPort(465);
        }

        final BlancoMailMessage message = new BlancoMailMessage();
        final BlancoMailAddress from = new BlancoMailAddress();
        from.setAddress(BlancoMailMobilePhoneTestConstants.MAIL_SEND_FROM_ADDR);
        from
                .setPersonal(BlancoMailMobilePhoneTestConstants.MAIL_SEND_FROM_ADDR_PERSONAL);
        message.setFrom(from);

        final BlancoMailAddress to1 = new BlancoMailAddress();
        to1.setAddress(BlancoMailMobilePhoneTestConstants.MAIL_SEND_TO_ADDR);
        to1
                .setPersonal(BlancoMailMobilePhoneTestConstants.MAIL_SEND_TO_ADDR_PERSONAL);
        message.getTo().add(to1);

        message
                .setSubject("[blanco](No.011) Content-Transfer-Encoding 7bitON");
        message
                .setText(BlancoMailMobilePhoneTestConstants.MAIL_SEND_TO_ADDR_PERSONAL
                        + "B"
                        + BlancoMailMobilePhoneTestConstants.MAIL_SEND_FROM_ADDR_PERSONAL
                        + "łB\n"
                        + "́uJavaMail{{[vŗL̖ɑ΂鎎łB\n"
                        + "Content-Transfer-Encoding 7bit (SEND_FORTH_CONTENT_TRANSFER_ENCODING_7BIT): true");

        // Content-Transfer-Encoding7bitɋ
        setting.setSendForthContentTransferEncoding7bit(true);

        System.out.println(message.getSubject() + ": " + to1.toString());

        BlancoMailSenderFactory.getInstance().send(setting, message);
    }
}
