/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.mail.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.NoSuchProviderException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Message.RecipientType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

import blanco.commons.util.BlancoStreamUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.log.BlancoLogBinaryLogger;
import blanco.mail.core.resourcebundle.BlancoMailCoreMessageResourceBundle;
import blanco.mail.core.valueobject.BlancoMailMessage;
import blanco.mail.core.valueobject.BlancoMailMessageAttachment;
import blanco.mail.core.valueobject.BlancoMailMessageHeader;
import blanco.mail.core.valueobject.BlancoMailSetting;
import blanco.mail.core.valueobject.BlancoMailStatistics;

/**
 * [MNXB
 * 
 * ȒPňSȃ[M邽߂̎QƎłB blancoMail RACûЂƂB
 * NX擾邽߂ɂ́ABlancoMailReceiverFactory#getInstance 𗘗p܂B
 * 
 * ̃NXgėpʂz肵ANXANZX public NXƐݒ肵Ă܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoMailReceiverImpl implements BlancoMailReceiver {
    /**
     * blancoMailCorebZ[WNXB
     */
    protected final BlancoMailCoreMessageResourceBundle fMsg = new BlancoMailCoreMessageResourceBundle();

    /**
     * vIuWFNgBftHgłnullZbgĂ_ɒӂĂB
     */
    protected BlancoMailStatistics fStatistics = null;

    /**
     * RXgN^͉B܂B
     * 
     * FactoryANZX\ɂȂ悤ɃpbP[WANZXeĂ܂B
     */
    BlancoMailReceiverImpl() {
    }

    /**
     * [T[oAŏ̃[bZ[WM܂B
     * 
     * M[ [T[o폜܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @return M[{̂킷o[IuWFNgB̃IuWFNgɃ[̖{∶Ȃǂ̏񂪓܂BP[MȂꍇɂ
     *         null ߂܂B
     * @throws ConnectException
     *             [T[oւ̐ڑsɊւOB
     * @throws IOException
     *             [f[^̎MsɊւOB
     */
    public BlancoMailMessage receive(final BlancoMailSetting argSetting)
            throws ConnectException, IOException {
        // p[^`FbNB
        if (argSetting == null) {
            throw new IllegalArgumentException(fMsg.getMbmcr001());
        }

        if (fStatistics == null) {
            // vIuWFNgݒ肳ĂȂꍇɂ ݒ肵܂B
            // ɂA\bhł fStatistics͏ɔnullł邱ƂۏႵ܂B
            fStatistics = new BlancoMailStatistics();
        }

        // BlancoMailSettingȇÓ̌؁B
        checkSetting(argSetting);

        final Properties props = new Properties();

        // ڑɊւvpeBZbg܂B
        prepareSessionProperties(argSetting, props);

        if (argSetting.getTestMode()) {
            // ۂ̃[M͎{܂B return܂B
            return new BlancoMailTestStub().receive(argSetting);
        }

        // ʐMJn
        final long startTimeMillis = System.currentTimeMillis();

        final Session session = BlancoMailCoreUtil.getReceiveSession(
                argSetting, props);
        final ByteArrayOutputStream outWorkByteArrayOutputStream = BlancoMailCoreUtil
                .beginSessionLogOutputStream(argSetting, session);

        // [T[õXgAIuWFNgB
        final Store store = connectStore(argSetting, session);

        // Iǂ킷tOB
        boolean isSuccessEnd = false;
        // [Mǂ\tOB
        // ̃tOɂAĨZbVOo͂邩ǂ̔fȂ܂B
        boolean isMailReceived = false;

        try {
            // [T[õtH_IuWFNgB
            Folder folder = null;
            try {
                try {
                    // INBOX tH_擾܂B
                    // INBOX͗\łB
                    folder = store.getFolder("INBOX");
                } catch (MessagingException e) {
                    fStatistics.setReceiveErrorCount(fStatistics
                            .getReceiveErrorCount() + 1);
                    throw new ConnectException(fMsg.getMbmcr302(e.toString()));
                }
                try {
                    // ǂݏ[hŃtH_I[v܂B
                    folder.open(Folder.READ_WRITE);
                } catch (MessagingException e) {
                    fStatistics.setReceiveErrorCount(fStatistics
                            .getReceiveErrorCount() + 1);
                    throw new ConnectException(fMsg.getMbmcr303(e.toString()));
                }

                // bZ[Wꗗ擾
                Message messages[] = null;
                try {
                    messages = folder.getMessages();
                } catch (MessagingException e) {
                    fStatistics.setReceiveErrorCount(fStatistics
                            .getReceiveErrorCount() + 1);
                    throw new IOException(fMsg.getMbmcr305(e.toString()));
                }

                for (int index = 0; index < messages.length; index++) {
                    final Message message = messages[index];

                    final BlancoMailMessage blancoMailMessage = parseMessage(
                            argSetting, message);
                    if (blancoMailMessage == null) {
                        // ̃[̎M̓XLbv܂B
                        // ̃[̎MւƏi߂܂B
                        continue;
                    }

                    try {
                        // [MƂtO𗧂ĂtH_N[Y܂B
                        // [M̂ XV[hŃtH_N[Y܂B
                        // ̏āA͂߂ĐIƂȂ܂B
                        folder.close(true);
                        // tH_IuWFNgnullݒ肵܂B
                        // nullݒ肷邱Ƃɂ finally߂ł̃N[YȂ悤ɂ܂B
                        folder = null;
                    } catch (MessagingException e) {
                        fStatistics.setReceiveErrorCount(fStatistics
                                .getReceiveErrorCount() + 1);
                        throw new IOException(fMsg.getMbmcr304(e.toString()));
                    }

                    // [MƂtO𗧂Ă܂B
                    isMailReceived = true;

                    // IƂtO𗧂Ă܂B
                    isSuccessEnd = true;

                    // v̍XVB
                    fStatistics
                            .setReceiveCount(fStatistics.getReceiveCount() + 1);
                    // TCYXVB
                    fStatistics.setReceiveSize(fStatistics.getReceiveSize()
                            + blancoMailMessage.getSize());

                    // ̃[bZ[W 擾ʂƂĖ߂܂B
                    return blancoMailMessage;
                }

                // ꌏ[ꍇB

                // IƂtO𗧂Ă܂B
                isSuccessEnd = true;

                fStatistics.setReceiveWithoutProcessCount(fStatistics
                        .getReceiveWithoutProcessCount() + 1);

                // Y郁[͈ꌏ܂łB
                return null;

            } finally {
                if (folder != null) {
                    try {
                        // tH_N[Y܂B
                        // ɓĂۂɂ́A[̎M͎{Ă܂B
                        // MȂ̃tH_N[YɂẮA͗OƂ͂܂B
                        // TODO MOVXeɂ́AOo͂ĂB
                        folder.close(false);
                    } catch (MessagingException e) {
                        System.out.println(fMsg.getMbmcr306(e.toString()));
                    }
                }
            }
        } finally {
            try {
                // XgAN[Y܂B
                store.close();
            } catch (MessagingException e) {
                // ڑN[YOɂẮA͗OƂ͂܂B
                // TODO MOVXeɂ́AOo͂ĂB
                System.out.println(fMsg.getMbmcr307(e.toString()));
            }

            // ʐMI
            final long endTimeMillis = System.currentTimeMillis();

            // MԂ̓vXVB
            fStatistics.setReceiveTime(fStatistics.getReceiveTime()
                    + (endTimeMillis - startTimeMillis));

            // [T[oƂ̈ÂƂZbVOt@Cɏo͂܂B

            String sessionLogDirectory = null;
            if (isSuccessEnd) {
                if (isMailReceived) {
                    // ۂɃ[M̂݃ZbVOo͂܂B
                    sessionLogDirectory = argSetting
                            .getSessionLogDirectorySuccess();
                } else if (argSetting.getSessionLogOutputWithNoReceiveProcess()) {
                    // 1[M𔺂Ȃꍇ̃Oo͂邩ǂ̃tOtruȅꍇB
                    // (ftHg)ʏfalse(cȂ)ŉ^p邱Ƃz肵Ă܂B
                    sessionLogDirectory = argSetting
                            .getSessionLogDirectorySuccess();
                }
            } else {
                sessionLogDirectory = argSetting.getSessionLogDirectoryError();
            }

            if (BlancoStringUtil.null2Blank(sessionLogDirectory).length() > 0) {
                final BlancoLogBinaryLogger logger = new BlancoLogBinaryLogger(
                        sessionLogDirectory, "mail", "r", "log");
                try {
                    logger.log(outWorkByteArrayOutputStream.toByteArray());
                } catch (IOException e) {
                    throw new IOException(fMsg.getMbmcr309(e.toString()));
                }
            }
        }
    }

    /**
     * v擾̂߂̃o[IuWFNgZbg܂B
     * 
     * @param argStatistics
     *            vB
     */
    public void setStatistics(final BlancoMailStatistics argStatistics) {
        fStatistics = argStatistics;
    }

    /**
     * v擾̂߂̃o[IuWFNgQbg܂B
     * 
     * @return vB
     */
    public BlancoMailStatistics getStatistics() {
        return fStatistics;
    }

    /**
     * JavaMail̃IuWFNgp[X blancoMail̃IuWFNg擾܂B
     * 
     * ̃\bh̃xł MessagingException ͑oȂ悤ɂ܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argJavaMailMessage
     *            JavaMail APĨbZ[WIuWFNgB
     * @return [{̂킷o[IuWFNgB̃IuWFNgɃ[̖{∶Ȃǂ̏񂪓܂B
     * @throws IOException
     *             [f[^̎MsɊւOB
     */
    private BlancoMailMessage parseMessage(final BlancoMailSetting argSetting,
            final Message argJavaMailMessage) throws IOException {
        final BlancoMailMessage blancoMailMessage = new BlancoMailMessage();

        try {
            // RETRR}hoO܂ł̏ȂAMׂ[ǂf܂B
            final boolean isReceived = parseMessageWithoutRetr(argSetting,
                    argJavaMailMessage, blancoMailMessage);
            if (isReceived == false) {
                // Mׂ[͖̂Ɣf܂B
                return null;
            }
        } catch (MessagingException e) {
            fStatistics
                    .setReceiveErrorCount(fStatistics.getReceiveErrorCount() + 1);
            throw new IOException(fMsg.getMbmcr301(e.toString()));
        }

        // System.out.println("TRACE: ܂łRETRR}h͑oȂB");

        try {
            // Mׂ[ƔfARETRR}ho𔺂[Ms܂B
            parseMessageWithRetr(argSetting, argJavaMailMessage,
                    blancoMailMessage);

            // ̌ʓꂽ[{̂킷o[IuWFNg߂܂B
            return blancoMailMessage;

        } catch (MessagingException e) {
            fStatistics
                    .setReceiveErrorCount(fStatistics.getReceiveErrorCount() + 1);
            throw new IOException(fMsg.getMbmcr308(e.toString()));
        }
    }

    /**
     * JavaMail̃IuWFNgp[X
     * blancoMail̃IuWFNg擾鏈̓BRETRR}hoO܂ł̏S܂B
     * 
     * SubjecttB^ݒ̌ʏΏۂł͂Ȃ̂TCYI[o[̂̂͏Ȃ[Ɣf܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argJavaMailMessage
     *            JavaMail APĨbZ[WIuWFNgB
     * @param blancoMailMessage
     *            M[{̂킷o[IuWFNgB̃IuWFNgɃ[̖{∶Ȃǂ̏񂪓܂B
     * @return true:ׂ[ꍇB false:ׂ[ꌏȂꍇB
     * @throws MessagingException
     *             JavaMail APIɗROB
     */
    private boolean parseMessageWithoutRetr(final BlancoMailSetting argSetting,
            final Message argJavaMailMessage,
            final BlancoMailMessage blancoMailMessage)
            throws MessagingException {
        // message.getContentĂяoO܂ł́ATOPR}h~܂ŁARETRR}h͑oȂB

        // SubjectSizêݍŏɎ擾B
        blancoMailMessage.setSubject(argJavaMailMessage.getSubject());
        blancoMailMessage.setSize(argJavaMailMessage.getSize());

        // SubjecttB^B
        if (BlancoStringUtil.null2Blank(argSetting.getReceiveFilterBySubject())
                .length() > 0) {
            // K\ɂĂ checkSetting\bhŊɑÓ`FbNς݂łB
            // ̂߁ȀꏊŐK\̃RpCsɊւO͔܂B
            final Pattern pattern = Pattern.compile(argSetting
                    .getReceiveFilterBySubject());
            final Matcher matcher = pattern.matcher(blancoMailMessage
                    .getSubject());
            if (matcher.matches() == false) {
                // SubjecttB^ݒ̌ʏΏۂł͂Ȃ[Ɣf܂B
                // ̃[͎M܂B
                return false;
            }
        }

        if (blancoMailMessage.getSize() > argSetting.getReceiveMaxMessageSize()) {
            // bZ[WIuWFNg̃TCYAő勖eTCY𒴂Ă܂B
            // ̃[͎M܂B
            return false;
        }

        // SubjectSizeȊȎɂĎ擾B
        blancoMailMessage.setSentDate(argJavaMailMessage.getSentDate());
        blancoMailMessage.setContentType(argJavaMailMessage.getContentType());
        blancoMailMessage.setDescription(argJavaMailMessage.getDescription());
        blancoMailMessage.setDisposition(argJavaMailMessage.getDisposition());
        blancoMailMessage.setLineCount(argJavaMailMessage.getLineCount());

        if (argJavaMailMessage.getFrom() != null
                && argJavaMailMessage.getFrom().length > 0) {
            // Fromݒ肳Ăꍇɂ̂ݏ܂B
            // ȂAFrom2ȏݒ肳ĂĂŏ FromAhX݂̂擾܂B
            final InternetAddress addrFrom = (InternetAddress) argJavaMailMessage
                    .getFrom()[0];
            blancoMailMessage.setFrom(BlancoMailCoreUtil
                    .toBlancoMailAddress(addrFrom));
        }

        // To:B
        final Address[] addrsTo = argJavaMailMessage
                .getRecipients(RecipientType.TO);
        if (addrsTo != null) {
            for (int loop = 0; loop < addrsTo.length; loop++) {
                final InternetAddress addrTo = (InternetAddress) addrsTo[loop];
                blancoMailMessage.getTo().add(
                        BlancoMailCoreUtil.toBlancoMailAddress(addrTo));
            }
        }

        // Cc:B
        final Address[] addrsCc = argJavaMailMessage
                .getRecipients(RecipientType.CC);
        if (addrsCc != null) {
            for (int loop = 0; loop < addrsCc.length; loop++) {
                final InternetAddress addrCc = (InternetAddress) addrsCc[loop];
                blancoMailMessage.getCc().add(
                        BlancoMailCoreUtil.toBlancoMailAddress(addrCc));
            }
        }

        // Bcc:ÔߏB
        final Address[] addrsBcc = argJavaMailMessage
                .getRecipients(RecipientType.BCC);
        if (addrsBcc != null) {
            for (int loop = 0; loop < addrsBcc.length; loop++) {
                final InternetAddress addrBcc = (InternetAddress) addrsBcc[loop];
                blancoMailMessage.getBcc().add(
                        BlancoMailCoreUtil.toBlancoMailAddress(addrBcc));
            }
        }

        if (argJavaMailMessage.getReplyTo() != null
                && argJavaMailMessage.getReplyTo().length > 0) {
            // ReplyTo̎w肪ꍇɂ̂ݐݒ肵܂B
            // ȂAReplyTo2ȏݒ肳ĂĂŏ ReplyToAhX݂̂擾܂B
            final InternetAddress addrReplyTo = (InternetAddress) argJavaMailMessage
                    .getReplyTo()[0];
            blancoMailMessage.setReplyTo(BlancoMailCoreUtil
                    .toBlancoMailAddress(addrReplyTo));
        }

        // [̃wb_[(Header)SĎoB
        final Enumeration headers = argJavaMailMessage.getAllHeaders();
        for (; headers.hasMoreElements();) {
            final Object objHeader = headers.nextElement();
            if (objHeader instanceof Header == false) {
                throw new IllegalArgumentException(
                        "肦ȂO: getAllHeadersHeaderIuWFNgȊOEnumerationɊ܂߂ĕԋp܂B");
            }
            final Header header = (Header) objHeader;

            final BlancoMailMessageHeader blancoHeader = new BlancoMailMessageHeader();
            blancoHeader.setName(header.getName());
            blancoHeader.setValue(header.getValue());
            blancoMailMessage.getHeaderList().add(blancoHeader);
        }

        // [MŝׂƔf܂B
        return true;
    }

    /**
     * JavaMail̃IuWFNgp[X blancoMail̃IuWFNg擾鏈̓BRETRR}ho𔺂S܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argJavaMailMessage
     *            JavaMail APĨbZ[WIuWFNgB
     * @param blancoMailMessage
     *            M[{̂킷o[IuWFNgB̃IuWFNgɃ[̖{∶Ȃǂ̏񂪓܂B
     * @throws MessagingException
     *             JavaMail APIɗROB
     * @throws IOException
     *             [f[^̎MsɊւOB
     */
    private void parseMessageWithRetr(final BlancoMailSetting argSetting,
            final Message argJavaMailMessage,
            final BlancoMailMessage blancoMailMessage)
            throws MessagingException, IOException {
        // message.getContentĂяo[ɑ΂ẮARETRR}ho܂B
        try {
            final Object objContent = argJavaMailMessage.getContent();
            if (objContent instanceof Multipart) {
                // }`p[g̏ꍇB

                final Multipart multiPart = (Multipart) objContent;
                for (int indexPart = 0; indexPart < multiPart.getCount(); indexPart++) {
                    final BlancoMailMessageAttachment attachment = new BlancoMailMessageAttachment();

                    final Part part = multiPart.getBodyPart(indexPart);
                    attachment.setContentType(part.getContentType());
                    attachment.setDescription(part.getDescription());
                    attachment.setDisposition(part.getDisposition());
                    attachment.setLineCount(part.getLineCount());
                    attachment.setSize(part.getSize());
                    if (Part.ATTACHMENT.equals(attachment.getDisposition())
                            || Part.INLINE.equals(attachment.getDisposition())) {
                        attachment.setFileName(MimeUtility
                                .decodeText(BlancoStringUtil.null2Blank(part
                                        .getFileName())));

                        // Xg[ǂݍݏsB
                        // |CgF莞ԁAYtt@C̃f[^L_ɒӁB
                        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                        BlancoStreamUtil.copy(part.getInputStream(), outStream);
                        outStream.flush();
                        outStream.close();
                        attachment.setData(outStream.toByteArray());

                        blancoMailMessage.getAttachmentList().add(attachment);
                    } else {
                        // }`p[gŃeLXg{񂠂邱Ƃ ܂肦ȂƍlĂ܂B
                        // Adl㑶݂邽߁AL̂悤ɊTexttB[hɑ΂Ēǉ`Ă܂B
                        blancoMailMessage.setText(BlancoStringUtil
                                .null2Blank(blancoMailMessage.getText())
                                + part.getContent().toString());
                    }
                }
            } else {
                // }`p[gł͂ȂꍇB

                // eLXg{񂠂邱Ƃ ܂肦ȂƍlĂ܂B
                // Ô߁AL̂悤ɊTexttB[hɑ΂Ēǉ`Ă܂B
                blancoMailMessage.setText(BlancoStringUtil
                        .null2Blank(blancoMailMessage.getText())
                        + objContent.toString());
            }
        } finally {
            // ӁF[̃p[XɎs悤A폜}[NĂ܂I
            // JavaMail API
            // ɂ郁[p[XɎsƂĂAG[tH_ɃOi[邩ǂ낤AƂӖłB

            // œǂݍ݂ (getContent)
            // [ɂă[T[o폜tOZbg܂B
            argJavaMailMessage.setFlag(Flags.Flag.DELETED, true);
        }
    }

    /**
     * BlancoMailSetting̓ȇÓ؂܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     */
    private void checkSetting(final BlancoMailSetting argSetting) {
        if (argSetting == null) {
            throw new IllegalArgumentException(
                    "BlancoMailReceiver#checkSetting: \bh̃p[^(argSetting) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }

        // BlancoMailSetting̓e`FbNB
        if (argSetting.getReceiveHost() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcr101());
        }
        if (argSetting.getReceiveUserName() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcr102());
        }
        if (argSetting.getReceivePassword() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcr103());
        }
        if (argSetting.getReceiveProtocol() == null) {
            throw new IllegalArgumentException(fMsg.getMbmcr104());
        }

        // Subject}b`[̓eÓ̃`FbNB
        if (BlancoStringUtil.null2Blank(argSetting.getReceiveFilterBySubject())
                .length() > 0) {
            try {
                Pattern.compile(argSetting.getReceiveFilterBySubject());
            } catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(fMsg.getMbmcr105(argSetting
                        .getReceiveFilterBySubject(), e.toString()));
            }
        }

        // [Mŋʂ BlancoMailSetting̐ݒe`FbNB
        BlancoMailCoreUtil.checkSetting(argSetting);
    }

    /**
     * JavaMail API ZbVIuWFNgɕKvƂȂvpeBIuWFNg܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argProps
     *            ڑɊւvpeBIuWFNgB̃IuWFNgJavaMail APIĂяo̐ڑ񂪃Zbg܂B
     */
    private void prepareSessionProperties(final BlancoMailSetting argSetting,
            final Properties argProps) {
        if ("pop3".equals(argSetting.getReceiveProtocol()) == false
                && "imap".equals(argSetting.getReceiveProtocol()) == false) {
            throw new IllegalArgumentException(fMsg.getMbmcr106(argSetting
                    .getReceiveProtocol()));
        }

        // {B
        argProps.setProperty("mail." + argSetting.getReceiveProtocol()
                + ".host", argSetting.getReceiveHost());

        if (argSetting.getReceivePort() >= 0) {
            // |[gԍύXB
            argProps.setProperty("mail." + argSetting.getReceiveProtocol()
                    + ".port", String.valueOf(argSetting.getReceivePort()));
        }

        // ^CAEgݒ
        if (argSetting.getMailConnectionTimeout() > 0) {
            argProps.setProperty("mail." + argSetting.getReceiveProtocol()
                    + ".connectiontimeout", String.valueOf(argSetting
                    .getMailConnectionTimeout()));
        }
        if (argSetting.getMailTimeout() > 0) {
            argProps.setProperty("mail." + argSetting.getReceiveProtocol()
                    + ".timeout", String.valueOf(argSetting.getMailTimeout()));
        }

        // POP3vgȐꍇAAPOP𗘗p邩ǂB
        if (argSetting.getReceivePop3Apop()) {
            argProps.setProperty("mail.pop3.apop.enable", "true");
        }

        if (argSetting.getReceiveUseSsl()) {
            // SSL֘Aݒ
            argProps.setProperty("mail." + argSetting.getReceiveProtocol()
                    + ".socketFactory.class", argSetting
                    .getSocketfactoryClass());
            argProps.setProperty("mail." + argSetting.getReceiveProtocol()
                    + ".socketFactory.fallback", String.valueOf(argSetting
                    .getSocketfactoryFallback()));
            if (argSetting.getReceivePort() >= 0) {
                // |[gԍύXB
                argProps.setProperty("mail." + argSetting.getReceiveProtocol()
                        + ".socketFactory.port", String.valueOf(argSetting
                        .getReceivePort()));
            }
        }
    }

    /**
     * JavaMail API oRăXgA([T[o)ɐڑ܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argSession
     *            JavaMail̃ZbVIuWFNgB
     * @return JavaMail̃XgAIuWFNgB
     * @throws ConnectException
     *             [T[oւ̐ڑsɊւOB
     */
    private Store connectStore(final BlancoMailSetting argSetting,
            final Session argSession) throws ConnectException {
        Store store = null;
        try {
            store = argSession.getStore(argSetting.getReceiveProtocol());
        } catch (NoSuchProviderException e) {
            fStatistics
                    .setReceiveErrorCount(fStatistics.getReceiveErrorCount() + 1);
            throw new ConnectException(fMsg.getMbmcr201(argSetting
                    .getReceiveProtocol(), e.toString()));
        }

        try {
            store.connect();
        } catch (AuthenticationFailedException e) {
            fStatistics
                    .setReceiveErrorCount(fStatistics.getReceiveErrorCount() + 1);
            throw new ConnectException(fMsg.getMbmcr202(argSetting
                    .getReceiveUserName(), e.toString()));
        } catch (MessagingException e) {
            fStatistics
                    .setReceiveErrorCount(fStatistics.getReceiveErrorCount() + 1);
            throw new ConnectException(fMsg.getMbmcr203(argSetting
                    .getReceiveHost(), e.toString()));
        }

        return store;
    }
}