/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoValueObject]̃NX
 */
package blanco.valueobject.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.valueobject.task.valueobject.BlancoValueObjectBatchProcessInput;

/**
 * Apache Ant^XN [BlancoValueObject]̃NXB
 *
 * o[IuWFNg`\[XR[h BlancoValueObjectAntTaskłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.valueobject.task]BlancoValueObjectBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancovalueobject&quot; classname=&quot;blanco.valueobject.task.BlancoValueObjectTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoValueObjectTask extends Task {
    /**
     * o[IuWFNg`\[XR[h BlancoValueObjectAntTaskłB
     */
    private BlancoValueObjectBatchProcessInput fInput = new BlancoValueObjectBatchProcessInput();

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final String arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public String getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[metadir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setMetadir(final String arg) {
        fInput.setMetadir(arg);
    }

    /**
     * Ant^XN[metadir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getMetadir() {
        return fInput.getMetadir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     * ftHgl[blanco]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fInput.setTmpdir(arg);
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fInput.getTmpdir();
    }

    /**
     * Ant^XN[nameAdjust]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * tB[h⃁\bh𖼑Oό`{邩ǂB<br>
     *
     * @param arg Zbgl
     */
    public void setNameAdjust(final String arg) {
        fInput.setNameAdjust(arg);
    }

    /**
     * Ant^XN[nameAdjust]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * tB[h⃁\bh𖼑Oό`{邩ǂB<br>
     * ftHgl[true]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getNameAdjust() {
        return fInput.getNameAdjust();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoValueObjectTask begin.");

        // ڔԍ[1]AAgr[g[metadir]͕K{͂łB̓`FbNs܂B
        if (getMetadir() == null) {
            throw new BuildException("Agr[g[metadir]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[targetdir]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getTargetdir() == null) {
            setTargetdir("blanco");
        }
        // ڔԍ[3]AAgr[g[tmpdir]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getTmpdir() == null) {
            setTmpdir("tmp");
        }
        // ڔԍ[4]AAgr[g[nameAdjust]ɂ̓ftHgݒ肳Ă܂B͂null̏ꍇɂ̓ftHglZbg܂B
        if (getNameAdjust() == null) {
            setNameAdjust("true");
        }

        if ("true".equals(getVerbose())) {
            System.out.println("- verbose:[true]");
            System.out.println("- metadir:[" + getMetadir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
            System.out.println("- nameAdjust:[" + getNameAdjust() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            if (new BlancoValueObjectBatchProcess().execute(fInput) != BlancoValueObjectBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if ("true".equals(getVerbose())) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
