/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoMessage]̃NX
 */
package blanco.message.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.message.task.valueobject.BlancoMessageBatchProcessInput;

/**
 * Apache Ant^XN [BlancoMessage]̃NXB
 *
 * bZ[W`烁bZ[WNX邽߂AntTaskłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.message.task]BlancoMessageBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancomessage&quot; classname=&quot;blanco.message.task.BlancoMessageTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoMessageTask extends Task {
    /**
     * bZ[W`烁bZ[WNX邽߂AntTaskłB
     */
    protected BlancoMessageBatchProcessInput fInput = new BlancoMessageBatchProcessInput();

    /**
     * bZ[W`烁bZ[WNX邽߂AntTaskłB
     */
    protected boolean fIsFieldMetadirProcessed = false;

    /**
     * bZ[W`烁bZ[WNX邽߂AntTaskłB
     */
    protected boolean fIsFieldTargetdirProcessed = false;

    /**
     * bZ[W`烁bZ[WNX邽߂AntTaskłB
     */
    protected boolean fIsFieldTmpdirProcessed = false;

    /**
     * bZ[W`烁bZ[WNX邽߂AntTaskłB
     */
    protected boolean fIsFieldTargetlangProcessed = false;

    /**
     * bZ[W`烁bZ[WNX邽߂AntTaskłB
     */
    protected boolean fIsFieldConstantsProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[metadir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setMetadir(final String arg) {
        fInput.setMetadir(arg);
        fIsFieldMetadirProcessed = true;
    }

    /**
     * Ant^XN[metadir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * ^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getMetadir() {
        return fInput.getMetadir();
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetdir(final String arg) {
        fInput.setTargetdir(arg);
        fIsFieldTargetdirProcessed = true;
    }

    /**
     * Ant^XN[targetdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B<br>
     * ftHgl[blanco]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetdir() {
        return fInput.getTargetdir();
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setTmpdir(final String arg) {
        fInput.setTmpdir(arg);
        fIsFieldTmpdirProcessed = true;
    }

    /**
     * Ant^XN[tmpdir]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B<br>
     * ftHgl[tmp]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTmpdir() {
        return fInput.getTmpdir();
    }

    /**
     * Ant^XN[targetlang]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 4<br>
     * ^[QbgƂȂvO~OꏈnBjava, cs, js, vb,php,ruby,pythonI\B<br>
     *
     * @param arg Zbgl
     */
    public void setTargetlang(final String arg) {
        fInput.setTargetlang(arg);
        fIsFieldTargetlangProcessed = true;
    }

    /**
     * Ant^XN[targetlang]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 4<br>
     * ^[QbgƂȂvO~OꏈnBjava, cs, js, vb,php,ruby,pythonI\B<br>
     * ftHgl[java]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getTargetlang() {
        return fInput.getTargetlang();
    }

    /**
     * Ant^XN[constants]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 5<br>
     * NX̒萔Ƃďo͂邩ǂB<br>
     *
     * @param arg Zbgl
     */
    public void setConstants(final boolean arg) {
        fInput.setConstants(arg);
        fIsFieldConstantsProcessed = true;
    }

    /**
     * Ant^XN[constants]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 5<br>
     * NX̒萔Ƃďo͂邩ǂB<br>
     * ftHgl[false]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public boolean getConstants() {
        return fInput.getConstants();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoMessageTask begin.");

        // ڔԍ[1]AAgr[g[metadir]͕K{͂łB̓`FbNs܂B
        if (fIsFieldMetadirProcessed == false) {
            throw new BuildException("K{Agr[g[metadir]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- metadir:[" + getMetadir() + "]");
            System.out.println("- targetdir:[" + getTargetdir() + "]");
            System.out.println("- tmpdir:[" + getTmpdir() + "]");
            System.out.println("- targetlang:[" + getTargetlang() + "]");
            System.out.println("- constants:[" + getConstants() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            if (new BlancoMessageBatchProcess().execute(fInput) != BlancoMessageBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
