/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.doclisting;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoXmlUtil;

/**
 * XMLt@CW񂵂ĂЂƂ̏Wt@Cグ܂B
 * 
 * ̃NX͓d`̐płBIɃ\[gȂ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoDocListingXml2CombinedXmlTelegramProcess {
    /**
     * e|t@C̃t@Cp^[𐳋K\ł킵́B
     */
    private static final String PATTERN = "^.*[.]xml$";

    /**
     * ۂ̃[gGg
     */
    private static final String ROOT_ELEMENT_NAME = "blancotelegramprocess-common";

    /**
     * ۂ̐Gg(description)
     */
    private static final String ROOT_ELEMENT_NAME_DESCRIPTION = "blancotelegramprocess-description";

    /**
     * L[(ID)\GgB
     * 
     * ̃GgL[Ƀ\[gȂǂs܂B
     */
    private static final String KEY_ELEMENT_NAME = "telegramProcessId";

    /*
     * ͓IȏB
     */

    /**
     * fobO[hœ삵Ă邩ǂB
     */
    private static final boolean IS_DEBUG = false;

    /**
     * ʏ̃XgB
     */
    private final ArrayList fListCommon = new ArrayList();

    /**
     * uṽ}bvB
     */
    private final HashMap fMapDescription = new HashMap();

    /**
     * ͂̒XMLt@Cꗗ̒XMLt@C쐬܂B
     * 
     * @param inputTmpDir
     *            XMLt@Ci[ĂtmptH_̃[gBtmp𐄏B
     * @param outputTmpDir
     *            o͐ƂȂtH_Btmp/doclisting/ 𐄏B
     */
    public void process(final File inputTmpDir, final File outputTmpDir) {
        if (outputTmpDir.exists() == false) {
            // o͂stH_݂Ȃ΂쐬B
            outputTmpDir.mkdirs();
        }

        parseDirectory(inputTmpDir);

        BlancoDocListingUtil.sortListByKey(KEY_ELEMENT_NAME, fListCommon);

        writeXml(outputTmpDir);
    }

    /**
     * w̃fBNgp[X܂B
     * 
     * ׂt@Ct@CŃ}b`OďĂ܂B
     * 
     * @param sourceListDirectory
     *            ̓fBNgB
     */
    private void parseDirectory(final File sourceListDirectory) {
        final File[] list = sourceListDirectory.listFiles();
        if (list == null) {
            // t@C܂B
            if (IS_DEBUG) {
                System.out.println("e|tH_["
                        + sourceListDirectory.getAbsolutePath()
                        + "]Ƀt@CЂƂ܂");
            }
            return;
        }

        for (int index = 0; index < list.length; index++) {
            Pattern patternCheck = null;
            try {
                patternCheck = Pattern.compile(PATTERN);
            } catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("[gGg["
                        + ROOT_ELEMENT_NAME + "]ɗ^ꂽp^[[" + PATTERN
                        + "]͕słBf܂");
            }

            final Matcher matcher = patternCheck.matcher(list[index].getName());
            if (matcher.matches()) {
                if (IS_DEBUG) {
                    System.out.println("t@C[" + list[index].getName()
                            + "]̓p^[[" + PATTERN + "]Ɉv܂");
                }
                parseXml(list[index], ROOT_ELEMENT_NAME);
            } else {
                if (IS_DEBUG) {
                    System.out.println("t@C[" + list[index].getName()
                            + "]̓p^[[" + PATTERN + "]Ɉv܂ł");
                }
            }
        }
    }

    /**
     * w肳ꂽt@C(XML)p[Xď擾܂B
     * 
     * p[X̌ʂƂăXgɋL܂B
     * 
     * @param fileRead
     * @param listDocument
     * @param rootElementName
     * @param elementNameList
     */
    private void parseXml(final File fileRead, final String rootElementName) {

        final Element documentElement = BlancoDocListingUtil
                .parseXmlDocument(fileRead);
        if (documentElement == null) {
            if (IS_DEBUG) {
                System.out.println("[gm[h܂");
            }
            return;
        }
        final NodeList rootNodeList = documentElement.getChildNodes();
        if (rootNodeList == null) {
            return;
        }
        final Element eleRoot = (Element) rootNodeList;

        final NodeList sheetList = eleRoot.getElementsByTagName("sheet");
        if (sheetList == null) {
            if (IS_DEBUG) {
                System.out.println("sheet^O܂B");
            }
            return;
        }

        final int sizeSheetList = sheetList.getLength();
        for (int indexSheet = 0; indexSheet < sizeSheetList; indexSheet++) {
            final Element eleSheet = (Element) sheetList.item(indexSheet);

            final NodeList listBlancoTelegramCommon = eleSheet
                    .getElementsByTagName(rootElementName);
            if (listBlancoTelegramCommon == null) {
                continue;
            }

            final int sizeListBlancoTelegramCommon = listBlancoTelegramCommon
                    .getLength();
            for (int index = 0; index < sizeListBlancoTelegramCommon; index++) {
                final Node nodeCommon = listBlancoTelegramCommon.item(index);
                if (nodeCommon instanceof Element == false) {
                    continue;
                }
                fListCommon.add(nodeCommon);

                /*
                 * m[hȉ̏ڍ׏Tum[ho͐ɃRs[܂B
                 * 
                 * Ŏ{Ă̂̓}bvւ̋L݂̂łB
                 */
                final String keyId = BlancoXmlUtil.getTextContent(
                        (Element) nodeCommon, KEY_ELEMENT_NAME);
                final NodeList listDescription = eleSheet
                        .getElementsByTagName(ROOT_ELEMENT_NAME_DESCRIPTION);
                for (int indexDescription = 0; indexDescription < listDescription
                        .getLength(); indexDescription++) {
                    final Node nodeDescription = listDescription
                            .item(indexDescription);
                    if (nodeDescription instanceof Element == false) {
                        continue;
                    }

                    fMapDescription.put(keyId, nodeDescription);
                }
            }
        }
    }

    /**
     * W܂XMLt@CւƏo͂܂B
     * 
     * @param outputTmpDir
     *            o͐fBNgB
     */
    private void writeXml(final File outputTmpDir) {
        final Document document = BlancoXmlUtil.newDocument();
        final Element elementWorkbook = document.createElement("workbook");
        document.appendChild(elementWorkbook);
        final Element elementSheet = document.createElement("sheet");
        elementWorkbook.appendChild(elementSheet);
        for (int index2 = 0; index2 < fListCommon.size(); index2++) {
            final Node node = (Node) fListCommon.get(index2);
            final Element subRootElement = document
                    .createElement(ROOT_ELEMENT_NAME);
            elementSheet.appendChild(subRootElement);

            BlancoDocListingUtil.copyNode(node, document, subRootElement);

            // Ɋւm[hꎮRs[܂B
            final Element elementDescription = document
                    .createElement(ROOT_ELEMENT_NAME_DESCRIPTION);
            subRootElement.appendChild(elementDescription);

            final String keyElementName = BlancoXmlUtil.getTextContent(
                    (Element) node, KEY_ELEMENT_NAME);
            BlancoDocListingUtil.copyNode((Element) fMapDescription
                    .get(keyElementName), document, elementDescription);
        }
        BlancoXmlUtil.transformDom2File(document, new File(outputTmpDir
                .getAbsolutePath()
                + "/" + ROOT_ELEMENT_NAME + ".combinedxml"));
    }
}
