/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.js;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * BlancoCgClass\[XR[hւƓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgClassJsSourceExpander {

    /**
     * ClassWJ܂B
     * 
     * @param cgClass
     *            ΏۂƂȂNXB
     * @param argSourceLines
     *            \[XR[hB
     */
    public void transformClass(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        // ŏɃNXLangDocɓWJB
        if (cgClass.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgClass.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgClass.getLangDoc().getTitle() == null) {
            cgClass.getLangDoc().setTitle(cgClass.getDescription());
        }

        //  LangDoc\[XR[h`ɓWJB
        // new BlancoCgLangDocJsSourceExpander().transformLangDoc(cgClass
        // .getLangDoc(), argSourceLines);

        // Ame[VWJB
        expandAnnotationList(cgClass, argSourceLines);

        // RXgN^݂邩A邢͂ЂƂ݂Ȃǂ`FbN܂B
        boolean isConstructorExist = false;
        for (int index = 0; index < cgClass.getMethodList().size(); index++) {
            final BlancoCgMethod cgMethod = (BlancoCgMethod) cgClass
                    .getMethodList().get(index);
            if (cgMethod.getConstructor()) {
                isConstructorExist = true;
                break;
            }
        }
        if (isConstructorExist == false) {
            // NX̃RXgN^ЂƂ݂Ȃꍇɂ́AblancoCg̐ӖƂăftHgRXgN^OŐKvoĂ܂B
            //  JavaScripťdlƂẴNX̍\̓FɗR̂łB
            // ẽ\bhƂăftHgRXgN^𐶐܂B
            final BlancoCgMethod cgMethod = BlancoCgObjectFactory.getInstance()
                    .createMethod(cgClass.getName(), "ftHgRXgN^");
            cgMethod.setConstructor(true);
            cgClass.getMethodList().add(cgMethod);
        }

        // NX̏́ANX̃RXgN^ւƈڑ܂B
        //  JavaScripťdlƂẴNX̍\̓FɗR̂łB
        // NX̐錾RXgN^̂̂ł̂ŁARXgN^ɃNX̏ڑKv邩łB
        for (int index = 0; index < cgClass.getMethodList().size(); index++) {
            final BlancoCgMethod cgMethod = (BlancoCgMethod) cgClass
                    .getMethodList().get(index);
            if (cgMethod.getConstructor()) {
                // NX̏RXgN^Ɉڑ܂B
                // ^Cg͈ڑ܂B
                for (int indexClassLangDoc = 0; indexClassLangDoc < cgClass
                        .getLangDoc().getDescriptionList().size(); indexClassLangDoc++) {
                    cgMethod.getLangDoc().getDescriptionList().add(
                            cgClass.getLangDoc().getDescriptionList().get(
                                    indexClassLangDoc));
                }
                for (int indexClassLangDoc = 0; indexClassLangDoc < cgClass
                        .getLangDoc().getTagList().size(); indexClassLangDoc++) {
                    cgMethod.getLangDoc().getTagList().add(
                            cgClass.getLangDoc().getTagList().get(
                                    indexClassLangDoc));
                }
            }
        }

        // Ń\bhWJB
        expandMethodList(cgClass, argSourceFile, argSourceLines);

        argSourceLines.add("/* NX[" + cgClass.getName() + "]錾̏IB */");
    }

    /**
     * Ame[VWJ܂B
     * 
     * @param cgClass
     *            NXB
     * @param argSourceLines
     *            \[XR[hB
     */
    private void expandAnnotationList(final BlancoCgClass cgClass,
            final List argSourceLines) {
        for (int index = 0; index < cgClass.getAnnotationList().size(); index++) {
            final Object objAnnotation = cgClass.getAnnotationList().get(index);
            if (objAnnotation instanceof String == false) {
                throw new IllegalArgumentException("NX[" + cgClass.getName()
                        + "]Annotationjava.lang.StringȊǑ^["
                        + objAnnotation.getClass().getName() + "]^܂B");
            }

            final String strAnnotation = (String) objAnnotation;
            throw new IllegalArgumentException(
                    "o[W blancoCg JavaScript̍ۂɂ̓Ame[VT|[g܂B"
                            + strAnnotation);
            // JavaScriptAnnotation͕słB
            // argSourceLines.add("@" + strAnnotation);
        }
    }

    /**
     * NXɊ܂܂eX̃\bhWJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    private void expandMethodList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        if (cgClass.getMethodList() == null) {
            throw new IllegalArgumentException("\bh̃Xgnull^܂B");
        }

        // ŏɃRXgN^WJB
        for (int index = 0; index < cgClass.getMethodList().size(); index++) {
            final Object objMethod = cgClass.getMethodList().get(index);
            if (objMethod instanceof BlancoCgMethod == false) {
                throw new IllegalArgumentException("\bh̃XgɃ\bhȊǑ^["
                        + objMethod.getClass().getName() + "]̒l^܂B");
            }

            final BlancoCgMethod cgMethod = (BlancoCgMethod) objMethod;
            if (cgMethod.getConstructor()) {
                // RXgN^݂̂ŏɓWJ܂B
                new BlancoCgMethodJsSourceExpander().transformMethod(cgClass,
                        cgMethod, argSourceFile, argSourceLines);
            }
        }

        // NXtB[h (staticȃtB[h)WJ܂B
        new BlancoCgMethodJsSourceExpander().transformStaticFieldList(cgClass,
                argSourceFile, argSourceLines);

        // Ɉʂ̃\bhWJB
        for (int index = 0; index < cgClass.getMethodList().size(); index++) {
            final Object objMethod = cgClass.getMethodList().get(index);
            if (objMethod instanceof BlancoCgMethod == false) {
                throw new IllegalArgumentException("\bh̃XgɃ\bhȊǑ^["
                        + objMethod.getClass().getName() + "]̒l^܂B");
            }

            final BlancoCgMethod cgMethod = (BlancoCgMethod) objMethod;
            if (cgMethod.getConstructor() == false) {
                // RXgN^ȊOWJ܂B
                new BlancoCgMethodJsSourceExpander().transformMethod(cgClass,
                        cgMethod, argSourceFile, argSourceLines);
            }
        }
    }
}
