/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.sample.batchprocess;

import java.io.IOException;

import blanco.sample.batchprocess.valueobject.SampleProcessInput;

/**
 * ob`NX [SampleBatchProcess]B
 *
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.sample.batchprocess.SampleBatchProcess -help
 * </code>
 */
public class SampleBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ob`OIBIBatchProcessExceptionꍇB
     */
    public static final int END_BATCHPROCESS_EXCEPTION = 6;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final SampleBatchProcess batchProcess = new SampleBatchProcess();

        // ob`̈B
        final SampleProcessInput input = new SampleProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldRequireProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-require=")) {
                input.setRequire(arg.substring(9));
                isFieldRequireProcessed = true;
            } else if (arg.startsWith("-dispstr=")) {
                input.setDispstr(arg.substring(9));
            } else if (arg.startsWith("-normalparam=")) {
                input.setNormalparam(arg.substring(13));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("SampleBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldRequireProcessed == false) {
            System.out.println("SampleBatchProcess: JnsB̓p[^[input]̕K{tB[hl[require]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR, END_BATCHPROCESS_EXCEPTION ̂ꂩ̒l߂܂BȈꍇ0Bs͏Ȉꍇ7BُȈꍇ9B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final SampleProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇASampleProcessC^tF[X blanco.sample.batchprocesspbP[W SampleProcessImplNX쐬邱Ƃɂłꍇ܂B
        final SampleProcess process = new SampleProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR, END_BATCHPROCESS_EXCEPTION ̂ꂩ̒l߂܂BȈꍇ0Bs͏Ȉꍇ7BُȈꍇ9B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final SampleProcessInput input) throws IllegalArgumentException {
        try {
            System.out.println("SampleBatchProcess: begin");

            // ob`̖{̂s܂B
            int retCode = process(input);

            System.out.println("SampleBatchProcess: end (" + retCode + ")");
            return retCode;
        } catch (BlancoBatchProcessException ex) {
            System.out.println("SampleBatchProcess: ob`O܂Bob`𒆒f܂B:" + ex.toString());
            // ob`OIB
            return END_BATCHPROCESS_EXCEPTION;
        } catch (IllegalArgumentException ex) {
            System.out.println("SampleBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("SampleBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("SampleBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("SampleBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("SampleBatchProcess: Usage:");
        System.out.println("  java blanco.sample.batchprocess.SampleBatchProcess -require=l1 -dispstr=l2 -normalparam=l3");
        System.out.println("    -require");
        System.out.println("      [K{̃TvB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -dispstr");
        System.out.println("      [\̃TvB]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[Ɏw肪ꍇ̕]");
        System.out.println("    -normalparam");
        System.out.println("      [K{łȂA܂ftHgȂ̗B]");
        System.out.println("      ^[]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final SampleProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getRequire() == null) {
            throw new IllegalArgumentException("SampleBatchProcess: JnsB̓p[^[input]̕K{tB[hl[require]ɒlݒ肳Ă܂B");
        }
    }
}
