/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.message.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.message.BlancoMessageConstants;
import blanco.message.BlancoMessageMeta2Xml;
import blanco.message.BlancoMessageXml2SourceFile;
import blanco.message.message.BlancoMessageMessage;
import blanco.message.resourcebundle.BlancoMessageResourceBundle;
import blanco.message.task.valueobject.BlancoMessageBatchProcessInput;

/**
 * ob`NXB
 * 
 * ob`̌ĂяoB <code>
 * java -classpath (NXpX) blanco.message.task.BlancoMessageBatchProcess -help
 * </code>
 */
public class BlancoMessageBatchProcess extends
        AbstractBlancoMessageBatchProcess {
    private final BlancoMessageMessage fMsg = new BlancoMessageMessage();

    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoMessageResourceBundle fBundle = new BlancoMessageResourceBundle();

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     * 
     * ̃\bhɎۂ̏eLq܂B
     * 
     * @param input
     *            ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION,
     *         END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int process(final BlancoMessageBatchProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("- " + BlancoMessageConstants.PRODUCT_NAME + " ("
                + BlancoMessageConstants.VERSION + ")");

        // ̓p[^`FbN܂B
        validateInput(input);

        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fMsg.getMbmsga01(input
                        .getMetadir()));
            }

            if ("true".equals(fBundle
                    .getXml2sourceFileNoGenerateConstantIfFormatElementExist())) {
                System.out
                        .println(fBundle
                                .getXml2sourceFileNoGenerateConstantIfFormatElementExistMsg());
            }

            // e|fBNg쐬B
            new File(input.getTmpdir()
                    + BlancoMessageConstants.TARGET_SUBDIRECTORY).mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoMessageMeta2Xml().processDirectory(fileMetadir, input
                    .getTmpdir()
                    + BlancoMessageConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + BlancoMessageConstants.TARGET_SUBDIRECTORY).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoMessageXml2SourceFile().process(fileMeta2[index],
                        input.getTargetlang(), input.getConstants(), new File(
                                input.getTargetdir()));
            }

            return END_SUCCESS;
        } catch (TransformerException ex) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + ex.toString());
        }
    }
}
