/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.anttask;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import blanco.anttask.message.BlancoAntTaskMessage;
import blanco.anttask.valueobject.BlancoAntTaskAttributeStructure;
import blanco.anttask.valueobject.BlancoAntTaskStructure;
import blanco.commons.util.BlancoStringUtil;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * uob``vExcell𒊏o܂B
 * 
 * ̃NX́AXMLt@C񒊏o@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoAntTaskXmlParser {
    /**
     * bZ[W`B
     */
    protected final BlancoAntTaskMessage fMsg = new BlancoAntTaskMessage();

    /**
     * XMLt@CXMLhLgp[XāA̔z擾܂B
     * 
     * @param argMetaXmlSourceFile
     *            XMLt@CB
     * @return p[X̌ʓꂽ̔zB
     */
    public BlancoAntTaskStructure[] parse(final File argMetaXmlSourceFile) {
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);
        if (documentMeta == null) {
            return null;
        }

        return parse(documentMeta);
    }

    /**
     * XMLt@C`XMLhLgp[XāAo[IuWFNg̔z擾܂B
     * 
     * @param argXmlDocument
     *            XMLt@CXMLhLgB
     * @return p[X̌ʓꂽo[IuWFNg̔zB
     */
    public BlancoAntTaskStructure[] parse(final BlancoXmlDocument argXmlDocument) {
        final ArrayList listStructure = new ArrayList();
        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(argXmlDocument);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return null;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            final BlancoAntTaskStructure structure = parseElementSheet(elementSheet);
            if (structure != null) {
                // ꂽL܂B
                listStructure.add(structure);
            }
        }

        final BlancoAntTaskStructure[] result = new BlancoAntTaskStructure[listStructure
                .size()];
        listStructure.toArray(result);
        return result;
    }

    /**
     * XMLt@C`́usheetvXMLGgp[XāAo[IuWFNg擾܂B
     * 
     * @param argElementSheet
     *            XMLt@ĆusheetvXMLGgB
     * @return p[X̌ʓꂽo[IuWFNgBunamevȂꍇɂ null߂܂B
     */
    public BlancoAntTaskStructure parseElementSheet(
            final BlancoXmlElement argElementSheet) {
        final BlancoAntTaskStructure structure = new BlancoAntTaskStructure();
        // ̓p[^擾܂B

        final List listCommon = BlancoXmlBindingUtil.getElementsByTagName(
                argElementSheet, "blancoanttask-common");
        if (listCommon.size() == 0) {
            // commonꍇɂ̓XLbv܂B
            return null;
        }

        // ŏ̃ACêݏĂ܂B
        final BlancoXmlElement elementCommon = (BlancoXmlElement) listCommon
                .get(0);

        // V[gڍׂȏ擾܂B
        structure.setName(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "taskName"));
        structure.setPackage(BlancoXmlBindingUtil.getTextContent(elementCommon,
                "packageName"));

        if (BlancoStringUtil.null2Blank(structure.getName()).length() == 0) {
            return null;
        }

        if (BlancoStringUtil.null2Blank(structure.getPackage()).trim().length() == 0) {
            throw new IllegalArgumentException("pbP[Ww肳Ă܂["
                    + structure.getName() + "]");
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "description") != null) {
            structure.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(elementCommon, "suffix") != null) {
            structure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "suffix"));
        }

        final BlancoXmlElement elementAttributes = BlancoXmlBindingUtil
                .getElement(argElementSheet, "blancoanttask-list");
        if (elementAttributes == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List listField = BlancoXmlBindingUtil.getElementsByTagName(
                elementAttributes, "attribute");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final Object nodeField = listField.get(indexField);
            if (nodeField instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementField = (BlancoXmlElement) nodeField;

            final BlancoAntTaskAttributeStructure attributeStructure = new BlancoAntTaskAttributeStructure();

            attributeStructure.setNo(BlancoXmlBindingUtil.getTextContent(
                    elementField, "no"));
            attributeStructure.setName(BlancoXmlBindingUtil.getTextContent(
                    elementField, "attribute"));
            if (BlancoStringUtil.null2Blank(attributeStructure.getName())
                    .length() == 0) {
                // attributew肳ĂȂꍇɂ͏܂B
                continue;
            }

            if (BlancoStringUtil.null2Blank(
                    BlancoXmlBindingUtil.getTextContent(elementField, "type"))
                    .length() > 0) {
                attributeStructure.setType(BlancoXmlBindingUtil.getTextContent(
                        elementField, "type"));
            }

            attributeStructure.setRequire("true".equals(BlancoXmlBindingUtil
                    .getTextContent(elementField, "require")));
            attributeStructure.setDefault(BlancoXmlBindingUtil.getTextContent(
                    elementField, "default"));
            attributeStructure.setDescription(BlancoXmlBindingUtil
                    .getTextContent(elementField, "description"));

            if (attributeStructure.getRequire()) {
                if (BlancoStringUtil
                        .null2Blank(attributeStructure.getDefault()).length() > 0) {
                    // ^XN[{0}]AAgr[g[{1}]ɂāA[K{][ftHg]Ɏw肳Ă܂B
                    // [K{][ftHg]͔rIɁAꂩ͎w肷Kv܂B
                    throw new IllegalArgumentException(fMsg.getMbati001(
                            structure.getName(), attributeStructure.getName()));
                }
            }

            structure.getAttributeList().add(attributeStructure);
        }

        return structure;
    }
}
