/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.message;

import java.util.List;

/**
 * blancoMessagẽbZ[W𕪊邽߂̃[eBeBłB
 * 
 * @author ToshikiIga
 */
class BlancoMessageSplitUtil {
    /**
     * bZ[Wuɕ܂B
     * 
     * @param listSourceString
     *            ͂ƂȂ镶B̉ߒœeς܂Bɂ͕Ă܂B
     * @return Ԃ܂Œu񂪑݂BЂƂꍇɂ -1߂܂B
     */
    public int split(final List listSourceString) {
        for (int number = 0;; number++) {
            final boolean isFound = splitByReplaceString(listSourceString,
                    number);
            if (isFound == false) {
                // ݂̏ԍ-1߂܂B
                // Pu񂪔ĂȂꍇɂ -1߂܂B
                return number - 1;
            }
        }
    }

    /**
     * wԍɂuƂɕ𕪊܂B
     * 
     * listSourceString͕̓A{0}, {1}Ƃwԍɂu
     * ʒuŕAlistSourceStringɖ߂܂B
     * uInteger^̐lƂlistSourceStringɊi[܂B
     * 
     * Ⴆ΁A͂ƂlistSourceString.index(0)Ɂuu{0}݂܂v Ƃ񂪊i[ĂꍇA<br>
     * listSourceString.index(0) = "u"<br>
     * listSourceString.index(1) = new Integer(0)<br>
     * listSourceString.index(2) = "݂܂"<br>
     * ̂悤ɕ܂B
     * 
     * @param listSourceString
     *            ͂ƂȂ镶B
     * @param replaceNumber
     *            u̔ԍB0IWŎw肵܂B
     * @return uǂ̃tOBuꂽꍇɂtrueAxuȂꍇɂ false߂܂B
     */
    private boolean splitByReplaceString(final List listSourceString,
            final int replaceNumber) {
        boolean isFound = false;
        for (int index = 0; index < listSourceString.size(); index++) {
            final Object objLook = listSourceString.get(index);
            if (objLook instanceof Integer) {
                continue;
            }

            final String input = (String) listSourceString.get(index);

            // u̍ۂɗp镶B
            final String replaceNumberString = "{" + replaceNumber + "}";

            final int search = input.indexOf(replaceNumberString);
            if (search >= 0) {
                listSourceString.remove(index);
                listSourceString.add(index, input.substring(0, search));
                listSourceString.add(index + 1, new Integer(replaceNumber));
                listSourceString.add(index + 2, input.substring(search
                        + replaceNumberString.length()));
                isFound = true;
            }
        }

        // svȒ0̕Xg珜܂B
        removeUnnecessaryString(listSourceString);

        return isFound;
    }

    /**
     * sƂɕ𕪊܂B
     * 
     * listSourceString͕̓s(\n)ʒuŕ listSourceStringɖ߂܂B
     * 
     * Ⴆ΁A͂ƂlistSourceString.index(0)Ɂus\n݂܂v Ƃ񂪊i[ĂꍇA<br>
     * listSourceString.index(0) = "s"<br>
     * listSourceString.index(1) = "\n"<br>
     * listSourceString.index(2) = "݂܂"<br>
     * ̂悤ɕ܂B
     * 
     * @param listSourceString
     *            ͂ƂȂ镶B
     */
    public void splitByNewLineChar(final List listSourceString) {
        for (int index = 0; index < listSourceString.size(); index++) {
            final Object objLook = listSourceString.get(index);
            if (objLook instanceof Integer) {
                continue;
            }

            final String input = (String) listSourceString.get(index);

            // u̍ۂɗp镶B
            final String newLine = "\n";

            if (newLine.equals(input)) {
                continue;
            }

            final int search = input.indexOf(newLine);
            if (search >= 0) {
                listSourceString.remove(index);
                listSourceString.add(index, input.substring(0, search));
                listSourceString.add(index + 1, newLine);
                listSourceString.add(index + 2, input.substring(search
                        + newLine.length()));
            }
        }

        // svȒ0̕Xg珜܂B
        removeUnnecessaryString(listSourceString);
    }

    /**
     * svȒ0̕Xg珜܂B
     * 
     * @param listSourceString
     */
    private void removeUnnecessaryString(final List listSourceString) {
        for (int index = listSourceString.size() - 1; index >= 0; index--) {
            final Object objLook = listSourceString.get(index);
            if (objLook instanceof Integer) {
                continue;
            }

            final String input = (String) listSourceString.get(index);
            if (input.length() == 0) {
                listSourceString.remove(index);
            }
        }
    }
}
