/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.sample.message;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[Sample2Message/bZ[W`[Sample2]Iɗp郊\[XohNXB]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 */
class Sample2MessageResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * Sample2MessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[Sample2Message]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public Sample2MessageResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("Sample2Message");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * Sample2MessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[Sample2Message]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public Sample2MessageResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("Sample2Message", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * Sample2MessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[Sample2Message]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public Sample2MessageResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("Sample2Message", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[Sample2Message], key[MESSAGE001]
     *
     * [bZ[W̃TvB̂PB] (ja)<br>
     *
     * @return key[MESSAGE001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage001() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[W̃TvB̂PB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE001");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[Sample2Message], key[MESSAGE002]
     *
     * [bZ[Wu[{0}]u܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage002(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[Wu[{0}]u܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE002");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample2Message], key[MESSAGE003]
     *
     * [bZ[Wu[{0}]ɉAЂƂ[{1}]u܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[Wu[{0}]ɉAЂƂ[{1}]u܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE003");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample2Message], key[MESSAGE004]
     *
     * [AbZ[Wu{0}{1}̗łB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage004(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "AbZ[Wu{0}{1}̗łB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE004");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample2Message], key[MESSAGE005]
     *
     * [{0}擪u񂪂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage005(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}擪u񂪂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE005");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample2Message], key[MESSAGE006]
     *
     * [Ōオu̗B{0}] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage006(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "Ōオu̗B{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE006");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample2Message], key[MESSAGE007]
     *
     * [xu{0}{1}{0}{1}{2}{1}{0}] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE007]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage007(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "xu{0}{1}{0}{1}{2}{1}{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE007");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample2Message], key[MESSAGE008]
     *
     * [̒uB{11}{10}{9}{8}{7}{6}{5}{4}{3}{2}{1}{0}12B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @param arg4 u{4}ulBjava.lang.String^^ĂB
     * @param arg5 u{5}ulBjava.lang.String^^ĂB
     * @param arg6 u{6}ulBjava.lang.String^^ĂB
     * @param arg7 u{7}ulBjava.lang.String^^ĂB
     * @param arg8 u{8}ulBjava.lang.String^^ĂB
     * @param arg9 u{9}ulBjava.lang.String^^ĂB
     * @param arg10 u{10}ulBjava.lang.String^^ĂB
     * @param arg11 u{11}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE008]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage008(final String arg0, final String arg1, final String arg2, final String arg3, final String arg4, final String arg5, final String arg6, final String arg7, final String arg8, final String arg9, final String arg10, final String arg11) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "̒uB{11}{10}{9}{8}{7}{6}{5}{4}{3}{2}{1}{0}12B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE008");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample2Message], key[MESSAGE009]
     *
     * [{0}ԍԂƒu͕sƂĔf܂B{1}B̒`0IWłB] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE009]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage009(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}ԍԂƒu͕sƂĔf܂B{1}B̒`0IWłB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE009");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample2Message], key[MESSAGE010]
     *
     * [GXP[v̊mFB_uNI[e[V&quot;AVONI[e[V'AG}[N\B] (ja)<br>
     *
     * @return key[MESSAGE010]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage010() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "GXP[v̊mFB_uNI[e[V\"AVONI[e[V'AG}[N\\B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE010");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[Sample2Message], key[MESSAGE011]
     *
     * [~] (ja)<br>
     *
     * @return key[MESSAGE011]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage011() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "~";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE011");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[Sample2Message], key[MESSAGE012]
     *
     * [s[\n]̎B] (ja)<br>
     *
     * @return key[MESSAGE012]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage012() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "s[\n]̎B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE012");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
