/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.sample.resourcebundle;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;

/**
 * \[Xoh`[Sample]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * <LI>en
 * </UL>
 */
public class SampleResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * SampleResourceBundleNX̃RXgN^B
     *
     * ꖼ[Sample]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public SampleResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("Sample");
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
    }

    /**
     * SampleResourceBundleNX̃RXgN^B
     *
     * ꖼ[Sample]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public SampleResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("Sample", locale);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AP[[" + locale.toString() + "]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
    }

    /**
     * SampleResourceBundleNX̃RXgN^B
     *
     * ꖼ[Sample]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public SampleResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("Sample", locale, loader);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AP[[" + locale.toString() + "]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[Sample], key[MESSAGE001]
     *
     * [bZ[W̃TvB̂PB] (ja)<br>
     * [Sample of message. No1.] (en)<br>
     *
     * @return key[MESSAGE001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage001() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[W̃TvB̂PB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[Sample], key[MESSAGE002]
     *
     * [bZ[Wu[{0}]u܂B] (ja)<br>
     * [Replace message here [{0}].] (en)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage002(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[Wu[{0}]u܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE002");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE002]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample], key[MESSAGE003]
     *
     * [bZ[Wu[{0}]ɉAЂƂ[{1}]u܂B] (ja)<br>
     * [Replace message [{0}] and next message[{1}].] (en)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[Wu[{0}]ɉAЂƂ[{1}]u܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE003");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE003]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample], key[MESSAGE004]
     *
     * [{0}擪u񂪂B] (ja)<br>
     * [{0}replace message from begin.] (en)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage004(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{0}擪u񂪂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE004");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE004]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample], key[MESSAGE005]
     *
     * [Ōオu̗B{0}] (ja)<br>
     * [Replace message from last.{0}] (en)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE005]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage005(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "Ōオu̗B{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE005");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE005]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample], key[MESSAGE006]
     *
     * [xu{0}{1}{0}{1}{2}{1}{0}] (ja)<br>
     * [Many replace messages.{0}{1}{0}{1}{2}{1}{0}] (en)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE006]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage006(final String arg0, final String arg1, final String arg2) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "xu{0}{1}{0}{1}{2}{1}{0}";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE006");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE006]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample], key[MESSAGE007]
     *
     * [̒uB{11}{10}{9}{8}{7}{6}{5}{4}{3}{2}{1}{0}12B] (ja)<br>
     * [Many replace messages.{11}{10}{9}{8}{7}{6}{5}{4}{3}{2}{1}{0} up to 12.] (en)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @param arg4 u{4}ulBjava.lang.String^^ĂB
     * @param arg5 u{5}ulBjava.lang.String^^ĂB
     * @param arg6 u{6}ulBjava.lang.String^^ĂB
     * @param arg7 u{7}ulBjava.lang.String^^ĂB
     * @param arg8 u{8}ulBjava.lang.String^^ĂB
     * @param arg9 u{9}ulBjava.lang.String^^ĂB
     * @param arg10 u{10}ulBjava.lang.String^^ĂB
     * @param arg11 u{11}ulBjava.lang.String^^ĂB
     * @return key[MESSAGE007]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage007(final String arg0, final String arg1, final String arg2, final String arg3, final String arg4, final String arg5, final String arg6, final String arg7, final String arg8, final String arg9, final String arg10, final String arg11) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "̒uB{11}{10}{9}{8}{7}{6}{5}{4}{3}{2}{1}{0}12B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE007");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE007]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample], key[MESSAGE008]
     *
     * [GXP[v̊mFB_uNI[e[V&quot;AVONI[e[V'AG}[N\B] (ja)<br>
     * [Check for escape string. Double &quot;, Single ', Yen \B] (en)<br>
     *
     * @return key[MESSAGE008]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage008() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "GXP[v̊mFB_uNI[e[V\"AVONI[e[V'AG}[N\\B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE008");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE008]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[Sample], key[MESSAGE009]
     *
     * [~] (ja)<br>
     * [X] (en)<br>
     *
     * @return key[MESSAGE009]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage009() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "~";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE009");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE009]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[Sample], key[MESSAGE010]
     *
     * [l̃bZ[Wu[{0,number}]̗B] (ja)<br>
     * [Number replace message[{0,number}] sample.] (en)<br>
     *
     * @param arg0 u{0}ulBjava.math.BigDecimal^^ĂB
     * @return key[MESSAGE010]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage010(final BigDecimal arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "l̃bZ[Wu[{0,number}]̗B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE010");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE010]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[Sample], key[MESSAGE011]
     *
     * [{̂ݒ`ꂽ\[XB] (ja)<br>
     * TODO: : P[(en)͐ݒ肳Ă܂B
     *
     * @return key[MESSAGE011]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage011() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "{̂ݒ`ꂽ\[XB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE011");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE011]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[Sample], key[MESSAGE013]
     *
     * [] (ja)<br>
     * TODO: : P[(en)͐ݒ肳Ă܂B
     *
     * @return key[MESSAGE013]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage013() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE013");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE013]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[Sample], key[MESSAGE012]
     *
     * [Resource for en locale only.] (en)<br>
     * TODO: : P[(ja)͐ݒ肳Ă܂B
     *
     * @return key[MESSAGE012]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMessage012() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "Resource for en locale only.";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("MESSAGE012");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[Sample]AL[[MESSAGE012]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            Logger.getLogger("blanco.sample.resourcebundle").fine(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
