/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.stringconverter.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.stringconverter.BlancoStringConverterConstants;
import blanco.stringconverter.BlancoStringConverterMeta2Xml;
import blanco.stringconverter.BlancoStringConverterXml2SourceFile;
import blanco.stringconverter.resourcebundle.BlancoStringConverterResourceBundle;
import blanco.stringconverter.task.valueobject.BlancoStringConverterProcessInput;

public class BlancoStringConverterProcessImpl implements
        BlancoStringConverterProcess {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoStringConverterResourceBundle bundle = new BlancoStringConverterResourceBundle();

    public int execute(final BlancoStringConverterProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("- " + BlancoStringConverterConstants.PRODUCT_NAME
                + " (" + BlancoStringConverterConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(bundle
                        .getAnttaskErr001(input.getMetadir()));
            }

            // e|fBNg쐬B
            new File(input.getTmpdir()
                    + BlancoStringConverterConstants.TARGET_SUBDIRECTORY)
                    .mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoStringConverterMeta2Xml()
                    .processDirectory(
                            fileMetadir,
                            input.getTmpdir()
                                    + BlancoStringConverterConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + BlancoStringConverterConstants.TARGET_SUBDIRECTORY)
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoStringConverterXml2SourceFile().process(
                        fileMeta2[index], input.getTargetlang(), new File(input
                                .getTargetdir()));
            }

            return BlancoStringConverterBatchProcess.END_SUCCESS;
        } catch (TransformerException ex) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + ex.toString());
        }
    }
}
