/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.text.converter;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.text.converter.valueobject.BlancoTextConverterSrcTxtStructure;

/**
 * u\[XeLXgvuHTMLt@Cvɕϊ܂B
 * 
 * ̑OɁASrcTxtւ̃C|[gWJ͏IĂKv肻łB
 */
public class BlancoTextConverterSrcTxt2Html {
    public void convert(final BufferedReader argReader,
            final BufferedWriter argWriter) throws IOException {
        final BlancoTextConverterSrcTxtStructure structure = parse(argReader);

        // ɏ݁I
        structure2File(structure, argWriter);

        System.out.println(structure.toString());
    }

    private BlancoTextConverterSrcTxtStructure parse(
            final BufferedReader argReader) throws IOException {
        final BlancoTextConverterSrcTxtStructure structure = new BlancoTextConverterSrcTxtStructure();

        boolean isBodyStarted = false;

        for (;;) {
            final String line = argReader.readLine();
            if (line == null) {
                break;
            }

            if (isBodyStarted == false) {
                // s̊Jn̏ꍇɂ̂ݔf܂B
                //  : ̐擪󔒂͖悤ɕύXB
                if (line.startsWith("Subject:")) {
                    structure.setSubject(line.substring("Subject:".length()));
                } else if (line.startsWith("Description:")) {
                    structure.setDescription(line.substring("Description:"
                            .length()));
                } else if (line.startsWith("Keywords:")) {
                    structure.setKeywords(line.substring("Keywords:".length()));
                } else if (line.startsWith("Date:")) {
                    try {
                        final SimpleDateFormat sdFormat = new SimpleDateFormat(
                                "yyyy-MM-dd");
                        structure.setDate(sdFormat.parse(line.substring("Date:"
                                .length())));
                    } catch (ParseException e) {
                        // Ƃ񂾂ƂĂ܂B
                        e.printStackTrace();
                    }
                } else if (line.trim().length() == 0) {
                    // {fB̈̊JnB
                    isBodyStarted = true;
                } else {
                    //  Ă͂Ȃ܂B
                    System.out.println("p[XɎs[" + line + "]B܂B");
                }
            } else {
                // {fB̈łB

                // TODO {Aŕ\̉͂Ȃ܂B
                // TODO ܂ [[]]̉͂Ȃ܂BdvB
                // TODO 1ڂ當΃^CgAȂǁB

                // TODO sĂA͂߂ăubN <P></P>̒PʂƔfB
                structure.getLineList().add(line);
            }
        }

        return structure;
    }

    private void structure2File(
            final BlancoTextConverterSrcTxtStructure argStructure,
            final BufferedWriter argWriter) throws IOException {
        argWriter
                .write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        argWriter.newLine();

        argWriter.write("<HTML lang=\"ja\">");
        argWriter.newLine();

        argWriter.write("<HEAD>");
        argWriter.newLine();

        argWriter.write("<TITLE>");
        // TODO HTML̃GXP[vB
        argWriter.write(argStructure.getSubject());
        argWriter.write("</TITLE>");
        argWriter.newLine();

        // TODO HTML̃GXP[vB
        argWriter.write("<META name=\"DESCRIPTION\" content=\""
                + argStructure.getDescription() + "\">");
        argWriter.newLine();

        // TODO HTML̃GXP[vB
        argWriter.write("<META name=\"KEYWORDS\" content=\""
                + argStructure.getKeywords() + "\">");
        argWriter.newLine();

        argWriter.write("</HEAD>");
        argWriter.newLine();

        argWriter.write("<BODY bgcolor=\"#eeddcc\">");
        argWriter.newLine();

        for (int index = 0; index < argStructure.getLineList().size(); index++) {
            final String line = (String) argStructure.getLineList().get(index);
            if (line.length() > 2) {
                if (line.charAt(0) != ' ') {
                    argWriter.write("<TABLE summary=\"mini title\">");
                    argWriter.newLine();
                    argWriter.write("<TBODY>");
                    argWriter.newLine();
                    argWriter.write("  <TR>");
                    argWriter.newLine();
                    argWriter
                            .write("    <TD bgcolor=\"#ff9900\" valign=\"top\"><FONT color=\"#ffffff\" size=\"+1\"><STRONG>"
                                    + BlancoJavaSourceUtil
                                            .escapeStringAsJavaDoc(line)
                                    + "</STRONG></FONT></TD>");
                    argWriter.newLine();
                    argWriter.write("  </TR>");
                    argWriter.newLine();
                    argWriter.write("</TBODY>");
                    argWriter.newLine();
                    argWriter.write("</TABLE>");
                    argWriter.newLine();
                } else {
                    // ʂ̍sB
                    argWriter.write("<P>"
                            + BlancoJavaSourceUtil.escapeStringAsJavaDoc(line)
                            + "</P>");
                    argWriter.newLine();
                    argWriter.newLine();
                    argWriter.newLine();
                }
            } else {
                // ʂ̍sB
                // TODO HTML̃GXP[vB
                argWriter.write("<P>"
                        + BlancoJavaSourceUtil.escapeStringAsJavaDoc(line)
                        + "</P>");
                argWriter.newLine();
                argWriter.newLine();
                argWriter.newLine();
            }
        }

        argWriter.write("<HR>");
        argWriter.newLine();
        argWriter.write("<ADDRESS>");
        argWriter.newLine();

        final SimpleDateFormat sdFormat = new SimpleDateFormat(
                "yyyy/MM/dd HH:mm:ss");
        argWriter
                .write("<A href=\"memo/memoigapyon.html\">҂ɂ</A><BR>  Last modified: $Date: "
                        + sdFormat.format(argStructure.getDate()) + " $");
        argWriter.write("</ADDRESS>");
        argWriter.newLine();

        argWriter.write("</BODY>");
        argWriter.newLine();

        argWriter.write("</HTML>");
        argWriter.newLine();
    }
}
