/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xml.bind;

import java.io.File;

import junit.framework.TestCase;
import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

public class BlancoXmlMarshaller3Test extends TestCase {
    /**
     * ȒPɎƂ Eclipse 3.1.1̃ftHgl 80000xEB<br>
     * 2006.05.03 XMLt@Cꂽۂ̃TCY 6,617,914 oCg (JDK 1.4.2x[X)
     */
    private static final int COUNT = 80000;

    // private static final int COUNT = 10;

    public void testParse() throws Exception {
        BlancoXmlDocument document = new BlancoXmlDocument();

        final BlancoXmlElement element = new BlancoXmlElement();
        element.setQName("RootElement");
        document.getChildNodes().add(element);

        final BlancoXmlAttribute attr = new BlancoXmlAttribute();
        element.getAtts().add(attr);
        attr.setQName("abc");
        attr.setValue("f[^̎");
        attr.setType("CDATA");

        final BlancoXmlElement element2 = new BlancoXmlElement();
        element.getChildNodes().add(element2);
        element2.setQName("ITEMS");

        final BlancoXmlCharacters characters = new BlancoXmlCharacters();
        characters.setValue("͒lłB");

        element2.getChildNodes().add(characters);

        for (int index = 0; index < COUNT; index++) {
            final BlancoXmlElement elementChild = new BlancoXmlElement();
            element2.getChildNodes().add(elementChild);
            elementChild.setQName("ITEM");

            final BlancoXmlAttribute attrChild = new BlancoXmlAttribute();
            elementChild.getAtts().add(attrChild);
            attrChild.setQName("index");
            attrChild.setValue("" + index);

            final BlancoXmlCharacters charactersChild = new BlancoXmlCharacters();
            charactersChild.setValue("ʃf[^̂" + index + "Ԗڂ̃f[^łB");
            elementChild.getChildNodes().add(charactersChild);
        }

        System.out.println("f[^\\zB");

        new File("./tmp").mkdirs();
        new BlancoXmlMarshaller().marshal(document, new File(
                "./tmp/BlancoXmlMarshaller3Test.xml"));

        System.out.println("f[^\ۑB");

        // ȑȌ͔j܂B
        document = null;

        // ǂݍ݂̍ۂɂ͏ڍׂȃf[^t^Ă̂ŁA
        // ݂łƂĂǂݍ݂łȂꍇ_ɒӁB

        final BlancoXmlDocument documentRead = new BlancoXmlUnmarshaller()
                .unmarshal(new File("./tmp/BlancoXmlMarshaller3Test.xml"));
        // System.out.println(documentRead);

        System.out.println("f[^\ǍB");
    }
}
