/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.rss.core;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

import blanco.rss.core.valueobject.BlancoRss;
import blanco.rss.core.valueobject.BlancoRssItem;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * RSS 0.9p[X o[IuWFNg܂B
 * 
 * @author IGA Tosiki
 */
class BlancoRssRss09Parser {
    private final Logger fLog = Logger.getLogger("blanco.rss.core");

    /**
     * ^ꂽGgp[X܂B
     * 
     * @param argElementRoot
     *            [gGgB
     * @return o̓o[IuWFNgB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͗OꍇB
     */
    public BlancoRss parse(final BlancoXmlElement argElementRoot)
            throws IOException, IllegalArgumentException {
        final BlancoRss outputRss = new BlancoRss();
        outputRss.setName(argElementRoot.getQName());
        outputRss.setVersion(BlancoXmlBindingUtil.getAttribute(argElementRoot,
                "version"));

        // L킳 channelIuWFNg܂B
        final List listChannel = BlancoXmlBindingUtil.getElementsByTagName(
                argElementRoot, "channel");
        if (listChannel.size() > 0) {
            final BlancoXmlElement elementChannel = (BlancoXmlElement) listChannel
                    .get(0);
            parseChannel(elementChannel, outputRss);
        } else {
            fLog.fine("channelGg[gɌ܂łB");
        }

        return outputRss;
    }

    /**
     * channelGgp[X܂B
     * 
     * @param argElement
     *            channelGgB
     * @param argOutputRss
     *            o̓o[IuWFNgB
     */
    private void parseChannel(final BlancoXmlElement argElement,
            final BlancoRss argOutputRss) {
        for (int index = 0; index < argElement.getChildNodes().size(); index++) {
            final Object objChild = argElement.getChildNodes().get(index);
            if (objChild instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementChild = (BlancoXmlElement) objChild;
            final String text = BlancoXmlBindingUtil
                    .getTextContent(elementChild);
            if (elementChild.getQName().equals("title")) {
                argOutputRss.getChannel().setTitle(text);
            } else if (elementChild.getQName().equals("link")) {
                argOutputRss.getChannel().setLink(text);
            } else if (elementChild.getQName().equals("description")) {
                argOutputRss.getChannel().setDescription(text);
            } else if (elementChild.getQName().equals("copyright")) {
                argOutputRss.getChannel().setCopyright(text);
            } else if (elementChild.getQName().equals("language")) {
                argOutputRss.getChannel().setLanguage(text);
            } else if (elementChild.getQName().equals("item")) {
                parseItem(elementChild, argOutputRss);
            } else {
                fLog.fine("Ή:channel[" + elementChild.getQName() + "]");
            }
        }
    }

    /**
     * itemGgp[X܂B
     * 
     * @param argElement
     *            itemGgB
     * @param argOutputRss
     *            o̓o[IuWFNgB
     */
    private void parseItem(final BlancoXmlElement argElement,
            final BlancoRss argOutputRss) {
        final BlancoRssItem item = new BlancoRssItem();
        argOutputRss.getItems().add(item);

        for (int indexItem = 0; indexItem < argElement.getChildNodes().size(); indexItem++) {
            final Object objLook = argElement.getChildNodes().get(indexItem);
            if (objLook instanceof BlancoXmlElement == false) {
                continue;
            }
            final BlancoXmlElement eleLook = (BlancoXmlElement) objLook;
            final String text = BlancoXmlBindingUtil.getTextContent(eleLook);
            if ("title".equals(eleLook.getQName())) {
                item.setTitle(text);
            } else if ("link".equals(eleLook.getQName())) {
                item.setLink(text);
            } else if ("description".equals(eleLook.getQName())) {
                item.setDescription(text);
            } else {
                fLog.fine("Ή:channel:item:[" + eleLook.getQName() + "]");
            }
        }
    }
}
