/*
 * blanco Framework
 * Copyright (C) 2004-2008 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.svnconf.actions;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.plugin.svnconf.BlancoSvnConfPlugin;
import blanco.plugin.svnconf.BlancoSvnConfPluginConstants;
import blanco.plugin.svnconf.editors.BlancoSvnConfEditor;
import blanco.plugin.svnconf.editors.BlancoSvnConfPluginUtil;
import blanco.svnconf.BlancoSvnConfConstants;
import blanco.svnconf.resourcebundle.BlancoSvnConfResourceBundle;
import blanco.svnconf.task.BlancoSvnConfBatchProcess;
import blanco.svnconf.task.valueobject.BlancoSvnConfProcessInput;

public class BlancoSvnConfGenerateAction {
    private static final BlancoSvnConfResourceBundle fBundle = new BlancoSvnConfResourceBundle();

    /**
     * s܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     */
    public static final void process(final IFile ifile, final Shell shell,
            final String metaDir) throws InvocationTargetException,
            InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        // vWFNg̃[gtH_擾B
        final String rootFolder = ifile.getProject().getLocation().toFile()
                .getAbsolutePath();
        // MessageDialog.openInformation(shell, "[g", rootFolder);

        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoSvnConfConstants.PRODUCT_NAME
                                                + "ݒt@C", 10);

                                BlancoSvnConfEditor.refreshAllFolder(ifile,
                                        shell, metaDir, monitor);
                                if (monitor.isCanceled()) {
                                    return;
                                }

                                // e|tH_U폜܂B
                                BlancoSvnConfPluginUtil
                                        .deleteFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoSvnConfConstants.TARGET_SUBDIRECTORY);
                                if (monitor.isCanceled()) {
                                    return;
                                }

                                // fBNg쐬 ̉ӏŎOɎ{܂B
                                BlancoSvnConfPluginUtil.createFolder(ifile,
                                        monitor, "meta");
                                BlancoSvnConfPluginUtil.createFolder(ifile,
                                        monitor, "blanco.svnconf");
                                BlancoSvnConfPluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoSvnConfConstants.TARGET_SUBDIRECTORY);

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final BlancoSvnConfProcessInput input = new BlancoSvnConfProcessInput();
                                input.setMetadir(rootFolder + "/" + metaDir);
                                input.setTargetdir(rootFolder + "/"
                                        + "blanco.svnconf");
                                input.setTmpdir(rootFolder + "/tmp");
                                new BlancoSvnConfBatchProcess().process(input);
                                // TODO R[obNɂi\̎B

                                BlancoSvnConfEditor.refreshAllFolder(ifile,
                                        shell, metaDir, monitor);
                                if (monitor.isCanceled()) {
                                    return;
                                }

                                if (BlancoSvnConfPluginConstants.IS_DEBUG) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoSvnConfPlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoSvnConfPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoSvnConfPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoSvnConfPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }
}