/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.message.resourcebundle;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoMessage]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoMessageResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoMessage]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoMessageResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoMessage");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoMessage]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoMessageResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoMessage", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoMessageResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoMessage]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoMessageResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoMessage", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoMessage], key[METAFILE_DISPLAYNAME]
     *
     * [bZ[W`] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "bZ[W`";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.FIELD_NO]
     *
     * [No.{0}: ] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.FIELD_NO]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileFieldNo(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "No.{0}: ";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.FIELD_NO");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.DESCRIPTION]
     *
     * [:L[:[{0}]A[{1}]] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2SOURCE_FILE.DESCRIPTION]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileDescription(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = ":L[:[{0}]A[{1}]";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.DESCRIPTION");
            }
        } catch (MissingResourceException ex) {
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST]
     *
     * [false] (ja)<br>
     *
     * @return key[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileNoGenerateConstantIfFormatElementExist() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "false";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoMessage], key[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST_MSG]
     *
     * [[h: bZ[Wɒu񂪂ꍇɂ͒萔tB[h͐ȂB] (ja)<br>
     *
     * @return key[XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST_MSG]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2sourceFileNoGenerateConstantIfFormatElementExistMsg() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "[h: bZ[Wɒu񂪂ꍇɂ͒萔tB[h͐ȂB";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2SOURCE_FILE.NO_GENERATE_CONSTANT_IF_FORMAT_ELEMENT_EXIST_MSG");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
