/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.soap.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import blanco.commons.io.File2StreamWrapper;
import blanco.commons.util.BlancoNameUtil;
import blanco.doclisting.BlancoDocListingXml2CombinedXmlTelegram;
import blanco.doclisting.BlancoDocListingXml2CombinedXmlTelegramProcess;
import blanco.plugin.soap.BlancoSOAPPlugin;
import blanco.plugin.soap.editors.BlancoSOAPEditor;
import blanco.plugin.soap.editors.BlancoSOAPPluginUtil;
import blanco.wsdl.BlancoWsdlMeta2Xml;
import blanco.wsdl.BlancoWsdlXml2Wsdl;
import blanco.wsdl.BlancoWsdlXml2Xsd;
import blanco.xsd.BlancoXsdXsdValidator;

/**
 * WSDL쓮ANV
 * 
 * @author IGA Tosiki
 */
public class BlancoSOAPGenerateAction implements IObjectActionDelegate {

    private ISelection selection;

    /**
     * GUIfobOp̒ᑬ[hBʏfalseŉ^p܂B
     */
    private static final boolean IS_DEBUG_SLOW = false;

    public BlancoSOAPGenerateAction() {
        super();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Shell shell = new Shell();

        if (selection instanceof StructuredSelection) {
            StructuredSelection look = (StructuredSelection) selection;
            Object objectLook = look.getFirstElement();
            if (objectLook instanceof IFile) {
                try {
                    final StringBuffer metaDir = new StringBuffer();
                    InputStream inStream = null;
                    try {
                        inStream = ((IFile) objectLook).getContents();

                        TransformerFactory tf = TransformerFactory
                                .newInstance();
                        Transformer transformer = tf.newTransformer();
                        transformer.transform(new StreamSource(inStream),
                                new SAXResult(new ContentHandler() {
                                    public void setDocumentLocator(Locator arg0) {
                                    }

                                    public void startDocument()
                                            throws SAXException {
                                    }

                                    public void endDocument()
                                            throws SAXException {
                                    }

                                    public void startPrefixMapping(String arg0,
                                            String arg1) throws SAXException {
                                    }

                                    public void endPrefixMapping(String arg0)
                                            throws SAXException {
                                    }

                                    public void startElement(String arg0,
                                            String arg1, String arg2,
                                            Attributes attributes)
                                            throws SAXException {
                                        if (arg1.equals("blancosoap")) {
                                            for (int index = 0; index < attributes
                                                    .getLength(); index++) {
                                                String localName = attributes
                                                        .getLocalName(index);
                                                String value = attributes
                                                        .getValue(index);
                                                if (localName
                                                        .equals("metawsdldir")) {
                                                    metaDir.append(value);
                                                }
                                            }
                                        }
                                    }

                                    public void endElement(String arg0,
                                            String arg1, String arg2)
                                            throws SAXException {
                                    }

                                    public void characters(char[] arg0,
                                            int arg1, int arg2)
                                            throws SAXException {
                                    }

                                    public void ignorableWhitespace(
                                            char[] arg0, int arg1, int arg2)
                                            throws SAXException {
                                    }

                                    public void processingInstruction(
                                            String arg0, String arg1)
                                            throws SAXException {
                                    }

                                    public void skippedEntity(String arg0)
                                            throws SAXException {
                                    }
                                }));
                    } catch (TransformerConfigurationException e) {
                        e.printStackTrace();
                    } catch (TransformerException e) {
                        // ̓ǂݍ݃G[͖܂B
                    } catch (CoreException e) {
                        // TODO ꂽ catch ubN
                        e.printStackTrace();
                    } finally {
                        try {
                            if (inStream != null) {
                                inStream.close();
                            }
                        } catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }

                    System.out.println("metaDir:" + metaDir.toString());
                    if (metaDir.length() > 0) {
                        processBlancoSOAP((IFile) objectLook, shell, null,
                                metaDir.toString(), false);
                    }
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    /**
     * blancoSOAP\[XR[hs܂B
     * 
     * @param input
     * @return
     * @throws InvocationTargetException
     * @throws InterruptedException
     */
    public static final void processBlancoSOAP(final IFile ifile,
            final Shell shell, final IProgressMonitor workbenchMonitor,
            final String metaDir, final boolean isGenerateXsdElementDeclaration)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask("blancoSOAP\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒");

                                // e|tH_U폜܂B
                                BlancoSOAPPluginUtil.deleteFolder(ifile,
                                        workbenchMonitor, "tmp/soap/wsdl");
                                BlancoSOAPPluginUtil.createFolder(ifile,
                                        workbenchMonitor, "tmp/soap/wsdl");
                                BlancoSOAPPluginUtil.createFolder(ifile,
                                        workbenchMonitor, "tmp/soap/wsdl/tmp");

                                final IFolder folderDirSoapWsdl = BlancoSOAPPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                "tmp/soap/wsdl");
                                folderDirSoapWsdl.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                final IFolder folderDirSoapWsdlTmp = BlancoSOAPPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                "tmp/soap/wsdl/tmp");
                                folderDirSoapWsdlTmp.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                final IFolder folderDirDoclisting = BlancoSOAPPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                "tmp/doclisting");
                                folderDirDoclisting.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor
                                        .subTask(BlancoSOAPEditor.BLANCO_META_FILE_TELEGRAM
                                                + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder folderDirMetaDir = BlancoSOAPPluginUtil
                                        .findFolder(ifile, workbenchMonitor,
                                                metaDir);
                                folderDirMetaDir.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                final IResource[] resourcesMetaFiles = folderDirMetaDir
                                        .members();
                                for (int index = 0; index < resourcesMetaFiles.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }

                                    if (resourcesMetaFiles[index] instanceof IFile) {
                                        IFile fileLookMetaFile = (IFile) resourcesMetaFiles[index];
                                        if (fileLookMetaFile.getFileExtension()
                                                .equals("xls") == false) {
                                            // xlsȊO̊gq̃t@C̓XLbv܂B");
                                            continue;
                                        }

                                        final IFile fileTargetXml = folderDirSoapWsdlTmp
                                                .getFile(fileLookMetaFile
                                                        .getName()
                                                        + ".xml");
                                        monitor.subTask("^t@C: t@C["
                                                + fileLookMetaFile.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/"
                                                + resourcesMetaFiles.length
                                                + ")");

                                        final InputStream inStream = fileLookMetaFile
                                                .getContents();
                                        try {
                                            new File2StreamWrapper(null,
                                                    fileTargetXml.getLocation()
                                                            .toFile()) {
                                                protected void process(
                                                        InputStream inStreamIgnore,
                                                        OutputStream outStream)
                                                        throws Exception {
                                                    new BlancoWsdlMeta2Xml()
                                                            .process(inStream,
                                                                    outStream);
                                                    outStream.flush();
                                                }
                                            }.run();
                                        } finally {
                                            // OōXg[͊Oŕ܂B
                                            inStream.close();
                                        }

                                        if (IS_DEBUG_SLOW) {
                                            Thread.sleep(1000);
                                        }
                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("WSDL/xsd쐬");
                                monitor.worked(1);

                                final File fileDirSoapWsdl = folderDirSoapWsdl
                                        .getLocation().toFile();

                                final BlancoWsdlXml2Wsdl xml2wsdl = new BlancoWsdlXml2Wsdl();
                                folderDirSoapWsdlTmp.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                final IResource[] resourcesXmlWsdlFiles = folderDirSoapWsdlTmp
                                        .members();
                                for (int index = 0; index < resourcesXmlWsdlFiles.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXmlWsdlFiles[index] instanceof IFile) {
                                        final IFile fileLookMetaWorkXml = (IFile) resourcesXmlWsdlFiles[index];
                                        if (fileLookMetaWorkXml
                                                .getFileExtension().equals(
                                                        "xml") == false) {
                                            // gqxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("WSDL/xsd쐬: t@C["
                                                + fileLookMetaWorkXml.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/"
                                                + resourcesXmlWsdlFiles.length
                                                + ")");

                                        try {
                                            // WSDLxsdsKv܂B
                                            final BlancoWsdlXml2Xsd xml2xsd = new BlancoWsdlXml2Xsd();
                                            if (isGenerateXsdElementDeclaration) {
                                                xml2xsd
                                                        .setGenerateXsdElementDeclaration(true);
                                            }
                                            xml2xsd.process(fileLookMetaWorkXml
                                                    .getLocation().toFile(),
                                                    fileDirSoapWsdl);

                                            // xsdŐꂽxsdt@CWSDLŗpĂ܂B
                                            xml2wsdl.parse(fileLookMetaWorkXml
                                                    .getLocation().toFile(),
                                                    fileDirSoapWsdl);
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLookMetaWorkXml
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (IS_DEBUG_SLOW) {
                                            Thread.sleep(1000);
                                        }
                                    }
                                }
                                xml2wsdl.generate(fileDirSoapWsdl);

                                folderDirSoapWsdl.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);
                                final IResource[] resourcesXmlXsdFiles = folderDirSoapWsdl
                                        .members();
                                for (int index = 0; index < resourcesXmlXsdFiles.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXmlXsdFiles[index] instanceof IFile) {
                                        final IFile fileLookMetaWorkXsd = (IFile) resourcesXmlXsdFiles[index];
                                        if (fileLookMetaWorkXsd
                                                .getFileExtension().equals(
                                                        "xsd") == false) {
                                            // gqxsdȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("xsd`FbN: t@C["
                                                + fileLookMetaWorkXsd.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/"
                                                + resourcesXmlXsdFiles.length
                                                + ")");

                                        try {
                                            // xsdt@C̑Ó؂s܂B
                                            final String fileNameFinal = BlancoNameUtil
                                                    .trimFileExtension(fileLookMetaWorkXsd
                                                            .getName());
                                            new File2StreamWrapper(
                                                    fileLookMetaWorkXsd
                                                            .getLocation()
                                                            .toFile(), null) {
                                                protected void process(
                                                        InputStream inStream,
                                                        OutputStream outStreamIgnore)
                                                        throws Exception {
                                                    new BlancoXsdXsdValidator()
                                                            .process(inStream,
                                                                    fileNameFinal);
                                                }
                                            }.run();
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLookMetaWorkXsd
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.toString());
                                        }

                                        if (IS_DEBUG_SLOW) {
                                            Thread.sleep(1000);
                                        }
                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                final File fileDoclistingInput = folderDirSoapWsdlTmp
                                        .getLocation().toFile();
                                final File fileDoclistingOutput = folderDirDoclisting
                                        .getLocation().toFile();

                                monitor
                                        .subTask("ꗗXV: d`Ed`̈ꗗ̂߂̒ԃt@CXVB");
                                new BlancoDocListingXml2CombinedXmlTelegramProcess()
                                        .process(fileDoclistingInput,
                                                fileDoclistingOutput);
                                new BlancoDocListingXml2CombinedXmlTelegram()
                                        .process(fileDoclistingInput,
                                                fileDoclistingOutput);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: soap/wsdltH_XV");
                                monitor.worked(1);
                                folderDirSoapWsdl.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (IS_DEBUG_SLOW) {
                                    Thread.sleep(1000);
                                }
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoSOAPPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        }
    }
}