/*
 * blanco Framework
 * Copyright(C) 2006-2008 NTT DATA BUSINESS BRAINS CORPORATION.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.soap.terasoluna.rich;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;

import blanco.ig.expander.ClassExpander;
import blanco.ig.generator.GeneratorSetting;
import blanco.ig.generator.ImplementGenerator;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

/**
 * Ɋւe폈[eBeBƂĂ܂Ƃ߂NXB
 * 
 * ̃NX blanco Framework̊NXQlƂč쐬܂B
 * 
 * @author IGA Tosiki
 */
public class TerasolunaBLogicUtil {
    /**
     * d`̏d`̃}bv擾B
     * 
     * @param operationName
     *            Iy[VB
     * @return d`̏B
     */
    public static final BlancoWsdlWebServiceOperation getTelegramProcessorDef(
            final String operationName, final HashMap mapTelegramProcessDef) {
        if (mapTelegramProcessDef.get(operationName) == null) {
            throw new IllegalArgumentException(
                    "dID["
                            + operationName
                            + "]̂߂̓d`ł܂łBdꗗ̍쐬OɓK؂ɎsĂ邩ǂmFĂB");
        }

        return (BlancoWsdlWebServiceOperation) mapTelegramProcessDef
                .get(operationName);
    }

    /**
     * 擾ꂽNXWJƂɁAJava\[XR[h𐶐B
     * 
     * ^ꂽClassExpanderJava\[XR[h𐶐B
     * 
     * @param classExpander
     *            NXWJB
     * @param directoryTarget
     *            Java\[XR[h̏o͐fBNgB
     * @throws IOException
     *             o͗OꍇB
     */
    public static void generateJavaSource(ClassExpander classExpander,
            File directoryTarget) throws IOException {
        GeneratorSetting setting = new GeneratorSetting();
        // o͐fBNgݒ肵܂B
        setting.setWorkDirectory(directoryTarget.getAbsolutePath());
        ImplementGenerator implementGenerator = new ImplementGenerator(setting);
        // 쐬NXo^܂B
        implementGenerator.addMain(classExpander);
        // ۂɃ\[XR[hs܂B
        implementGenerator.generate();
        // System.out.println("\[XR[h܂B");
    }
}
