/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator.dictionary;

import jp.sourceforge.mergedoc.pleiades.resource.TranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationResult;
import blanco.nlpack.generator.message.BlancoNLpackGeneratorMessage;

/**
 * Pleiades  ̎𗘗pāA^ꂽlupꁨ{vȂǂ֕ϊ邽߂̃NXB
 * 
 * @author IGA Tosiki
 */
public class BlancoNLpackGeneratorPleiadesDictionary {
    /**
     * Xe[^XB
     */
    public static final int STATUS_NONE = -1;

    /**
     * 甭łȂB
     */
    public static final int STATUS_NOT_FOUND = 0;

    /**
     * 甭łȂj[jbNϊ͎{ꂽB
     */
    public static final int STATUS_MNEMONIC_CHANGED = 2;

    /**
     * 甭łB
     */
    public static final int STATUS_FOUND = 1;

    /**
     * bZ[WIuWFNgB
     */
    private final BlancoNLpackGeneratorMessage fMsg = new BlancoNLpackGeneratorMessage();

    /**
     * Pleiades  ̃CX^XB
     */
    private TranslationDictionary fDictionary = null;

    /**
     * O lookup ̌ʂێB
     */
    private int fFoundStatus = STATUS_NONE;

    /**
     * O lookup̍ۂ 猟ł̂ǂB
     * 
     * @return 󋵃Xe[^XB
     */
    public int getFoundStatus() {
        return fFoundStatus;
    }

    /**
     * Pleiades  ̃[hB
     * 
     * @throws Throwable
     *             sOꍇB
     */
    private void load() throws Throwable {
        System.out.println("babel: Pleiades dictionary: load: begin.");

        // CX^X̎擾B
        fDictionary = new TranslationDictionary();

        System.out.println("babel: Pleiades dictionary: load: end.");

    }

    /**
     * Pleiades  ̎𗘗pāA^ꂽlupꁨ{v֕ϊ܂B
     * 
     * @param argString
     *            pꕶB
     * @return {ꕶB
     */
    public String lookup(final String argString) {
        if (argString == null) {
            // TODO ̊OI
            throw new IllegalArgumentException(
                    "IllegalArgument: BlancoNLpackGeneratorPleiadesDictionary#lookup(null)");
        }

        // Xe[^XB
        fFoundStatus = STATUS_NONE;

        if (fDictionary == null) {
            try {
                load();
            } catch (Throwable e) {
                throw new IllegalArgumentException(fMsg.getMbebp001(e
                        .toString()));
            }
        }

        final TranslationResult result = fDictionary.lookup(argString);

        // ɌǂL܂B
        if (result.isFound()) {
            fFoundStatus = STATUS_FOUND;
        } else {
            if (argString.equals(result.getValue())) {
                fFoundStatus = STATUS_NOT_FOUND;
            } else {
                fFoundStatus = STATUS_MNEMONIC_CHANGED;
            }
        }

        return result.getValue();
    }
}
