/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle;

import java.io.File;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.resourcebundle.message.BlancoResourceBundleMessage;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure;

/**
 * W̒XMLt@C̓eÓ`FbNs܂B
 * 
 * ̃\[XR[hblancoResourceBundlëꕔłB<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleXmlValidator {
    /**
     * bZ[WB
     */
    private final BlancoResourceBundleMessage fMsg = new BlancoResourceBundleMessage();

    /**
     * \[XohANZT̃CX^XB
     */
    private final BlancoResourceBundleResourceBundle fBundle = new BlancoResourceBundleResourceBundle();

    /**
     * \[XohMessageFormatɂp[XsۂɁAO珈𒆒f邩ǂ̃tOB
     * 
     * trueȂ珈fėO𔭐܂B<br>
     * falseȂ珈sAû͖Ƃ݂Ȃ܂B<br>
     * Javã\[XR[hۂȂǂɁA falseɐݒ肵ĔgʂƂł悤ɐ؂ւꍇ܂B<br>
     * ftHgl[true]ݒ肳Ă܂B
     */
    private boolean fIsFailOnMessageFormatError = true;

    /**
     * \[XohMessageFormatɂp[XsۂɁAO珈𒆒f邩ǂ̃tOݒ肵܂B
     * 
     * trueȂ珈fėO𔭐܂B<br>
     * falseȂ珈sAû͖Ƃ݂Ȃ܂B<br>
     * Javã\[XR[hۂȂǂɁA falseɐݒ肵ĔgʂƂł悤ɐ؂ւꍇ܂B<br>
     * ftHgl[true]ݒ肳Ă܂B
     * 
     * @param argIsFailOnMessageFormatError
     */
    public void setFailOnMessageFormatError(
            final boolean argIsFailOnMessageFormatError) {
        fIsFailOnMessageFormatError = argIsFailOnMessageFormatError;
    }

    /**
     * XMLt@C vpeBt@CANZXpJava\[XR[h𐶐܂B
     * 
     * @param argFileSource
     *            ͂ƂȂ钆XMLt@CB
     * @param argDirectoryTarget
     *            \[XR[ho͂ۂ̏o͐fBNgB
     */
    public void process(final File argFileSource, final File argDirectoryTarget) {
        final DOMResult result = BlancoXmlUtil.transformFile2Dom(argFileSource);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            final HashMap mapProcessedBaseName = new HashMap(64);
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                final NodeList listCommon = elementSheet
                        .getElementsByTagName(fBundle
                                .getMeta2xmlElementCommon());
                if (listCommon == null || listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);

                final BlancoResourceBundleBundleStructure structure = new BlancoResourceBundleBundleStructure();

                structure.setName(BlancoXmlUtil.getTextContent(elementCommon,
                        "baseName"));
                if (structure.getName() == null) {
                    continue;
                }

                if (BlancoXmlUtil.getTextContent(elementCommon, "packageName") == null) {
                    // TODO pbP[W̓G[ׂ
                    continue;
                }

                final ArrayList listLocale = new ArrayList();
                final NodeList nodeListCommon = elementCommon
                        .getElementsByTagName("locale");
                if (nodeListCommon == null || nodeListCommon.getLength() == 0) {
                    continue;
                }

                final int sizeNodeListCommon = nodeListCommon.getLength();
                for (int indexLocale = 0; indexLocale < sizeNodeListCommon; indexLocale++) {
                    final Node nodeLook = nodeListCommon.item(indexLocale);
                    if (nodeLook instanceof Element == false) {
                        continue;
                    }

                    final Element elementLook = (Element) nodeLook;
                    final NodeList nodeChilds = elementLook.getChildNodes();
                    if (nodeChilds == null) {
                        continue;
                    }

                    final int nodeChildsLength = nodeChilds.getLength();
                    for (int indexChild = 0; indexChild < nodeChildsLength; indexChild++) {
                        final Node nodeChild = nodeChilds.item(indexChild);
                        if (nodeChild instanceof Text) {
                            listLocale.add(((Text) nodeChild).getNodeValue());
                        }
                    }
                }
                if (listLocale.size() == 0) {
                    continue;
                }

                if (mapProcessedBaseName.get(structure.getName()) != null) {
                    throw new IllegalArgumentException(fMsg.getMbrbi005(
                            structure.getName(), (String) mapProcessedBaseName
                                    .get(structure.getName())));
                }

                expandSheet(elementSheet, elementCommon);
                mapProcessedBaseName.put(structure.getName(), "܂");
            }
        }
    }

    /**
     * W̒XMLt@C̓eÓ`FbNs܂B
     * 
     * @param argElementSheet
     *            V[g̃GgB
     * @param argElementCommon
     *            ʏ̃GgB
     */
    private void expandSheet(final Element argElementSheet,
            final Element argElementCommon) {
        final BlancoResourceBundleBundleStructure structure = new BlancoResourceBundleBundleStructure();

        structure.setName(BlancoXmlUtil.getTextContent(argElementCommon,
                "baseName"));
        structure.setDescription(BlancoXmlUtil.getTextContent(argElementCommon,
                "description"));

        final ArrayList listKnownLocale = new ArrayList();
        final HashMap mapBundle = new HashMap();
        // ^ꂽpbP[Ŵ܂ܗp܂B

        final NodeList listCommonList = argElementSheet
                .getElementsByTagName(fBundle.getMeta2xmlElementCommon());
        if (listCommonList == null || listCommonList.getLength() == 0) {
            // commonꍇɂ̓XLbv܂B
            return;
        }

        checkLocaleDup(structure.getName(), structure.getDescription(),
                listKnownLocale, listCommonList);

        final NodeList listResourceList = argElementSheet
                .getElementsByTagName(fBundle.getMeta2xmlElementList());
        if (listResourceList == null || listResourceList.getLength() == 0) {
            // {̂̕ɂĂ͏XLbv܂B
            return;
        }

        final NodeList listResource = ((Element) listResourceList.item(0))
                .getElementsByTagName("resource");
        if (listResource == null || listResource.getLength() == 0) {
            return;
        }

        final int sizeListResource = listResource.getLength();
        for (int indexResource = 0; indexResource < sizeListResource; indexResource++) {
            final Element elementResource = (Element) listResource
                    .item(indexResource);

            final String fieldResourceId = BlancoStringUtil
                    .null2Blank(BlancoXmlUtil.getTextContent(elementResource,
                            "resourceKey"));

            final NodeList nodeListResourceString = elementResource
                    .getElementsByTagName("resourceString");
            if (nodeListResourceString == null
                    || nodeListResourceString.getLength() == 0) {
                // ꌏꍇɂ̓XLbv܂B
                continue;
            }

            checkMessageFormat(structure.getName(), structure.getDescription(),
                    mapBundle, fieldResourceId, nodeListResourceString,
                    fIsFailOnMessageFormatError);
        }
    }

    /**
     * P[̏d݂Ȃǂ`FbN܂B
     * 
     * @param argBaseName
     * @param argDescription
     * @param argListKnownLocale
     * @param argListCommonList
     */
    private void checkLocaleDup(final String argBaseName,
            final String argDescription, final ArrayList argListKnownLocale,
            final NodeList argListCommonList) {
        // P[̏d`FbNs܂B
        final NodeList listLocale = ((Element) argListCommonList.item(0))
                .getElementsByTagName("locale");
        if (listLocale == null || listLocale.getLength() == 0) {
            return;
        }

        final int sizeListLocale = listLocale.getLength();
        if (sizeListLocale > 0) {
            final HashMap mapExistLocale = new HashMap();
            for (int indexLocale = 0; indexLocale < sizeListLocale; indexLocale++) {
                final Element elementLocale = (Element) listLocale
                        .item(indexLocale);
                final String locale = BlancoStringUtil.null2Blank(BlancoXmlUtil
                        .getTextContent(elementLocale));
                if (mapExistLocale.get(locale) != null) {
                    // P[̏d܂B
                    throw new IllegalArgumentException(fMsg.getMbrbi006(
                            argBaseName
                                    + (argDescription == null ? "" : "/"
                                            + argDescription), locale));
                }
                argListKnownLocale.add(locale);
                mapExistLocale.put(locale, locale);
            }
        }
    }

    /**
     * bZ[WtH[}bg̃p[XʂP[ԂɂđÓȏԂł邩ǂ`FbN܂B
     * 
     * P[ԂőႪꍇɂ͗Oŏf܂B
     * 
     * @param argBaseName
     *            B
     * @param argDescription
     *            BOɗp܂B
     * @param argMapBundle
     * @param argFieldResourceId
     *            \[XIDB
     * @param argNodeListResourceString
     * @param argIsFailOnMessageFormatError
     *            MessageFormatɂp[X̌ʂƂėOꍇɏf邩ǂB
     */
    private void checkMessageFormat(final String argBaseName,
            final String argDescription, final HashMap argMapBundle,
            final String argFieldResourceId,
            final NodeList argNodeListResourceString,
            final boolean argIsFailOnMessageFormatError) {
        final HashMap mapProcessedLocale = new HashMap();
        Format[] previousFormatList = null;

        final int nodeListResourceStringSize = argNodeListResourceString
                .getLength();
        for (int indexResourceString = 0; indexResourceString < nodeListResourceStringSize; indexResourceString++) {
            if (argNodeListResourceString.item(indexResourceString) instanceof Element == false) {
                continue;
            }

            final Element elementResourceString = (Element) argNodeListResourceString
                    .item(indexResourceString);
            final String resourceString = BlancoStringUtil
                    .null2Blank(BlancoXmlUtil
                            .getTextContent(elementResourceString));
            final String locale = BlancoStringUtil
                    .null2Blank(elementResourceString.getAttribute("locale"));
            if (mapProcessedLocale.get(locale) != null) {
                // ɏς̃P[ł΃\[XIDdĂG[łƔf܂B
                throw new IllegalArgumentException(fMsg.getMbrbi007(argBaseName
                        + (argDescription == null ? "" : "/" + argDescription),
                        locale, argFieldResourceId));
            }

            // VɏΏۂƂ郍P[ƂċL܂B
            mapProcessedLocale.put(locale, locale);
            if (argMapBundle.get(argFieldResourceId) == null) {
                // \[Xoh̃}bvɋL܂B
                argMapBundle.put(argFieldResourceId, resourceString);
            }

            Format[] formatList = null;
            try {
                formatList = BlancoResourceBundleUtil
                        .getFormatsByArgumentIndex(resourceString,
                                argIsFailOnMessageFormatError);
            } catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException(fMsg.getMbrbi008(
                        argBaseName, locale, argFieldResourceId,
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(resourceString))
                        + ex.toString());
            }

            if (indexResourceString == 0) {
                // ͔rs܂B
            } else {
                if (previousFormatList == null && formatList == null) {
                    // vĂ܂B肠܂B
                } else if (previousFormatList == null && formatList != null) {
                    throw new IllegalArgumentException(fMsg.getMbrbi009(
                            argBaseName
                                    + (argDescription == null ? "" : "/"
                                            + argDescription), locale,
                            argFieldResourceId, String
                                    .valueOf(formatList.length)));
                } else if (previousFormatList != null && formatList == null) {
                    throw new IllegalArgumentException(fMsg.getMbrbi010(
                            argBaseName
                                    + (argDescription == null ? "" : "/"
                                            + argDescription), locale,
                            argFieldResourceId, String
                                    .valueOf(previousFormatList.length)));
                } else {
                    if (previousFormatList.length != formatList.length) {
                        throw new IllegalArgumentException(fMsg.getMbrbi011(
                                argBaseName
                                        + (argDescription == null ? "" : "/"
                                                + argDescription), locale,
                                argFieldResourceId, String
                                        .valueOf(formatList.length), String
                                        .valueOf(previousFormatList.length)));
                    }
                    for (int indexFormat = 0; indexFormat < formatList.length; indexFormat++) {
                        final String previousFormatClass = (previousFormatList[indexFormat] == null ? fBundle
                                .getExpandresourceSrc051()
                                : previousFormatList[indexFormat].getClass()
                                        .getName());
                        final String formatClass = (formatList[indexFormat] == null ? fBundle
                                .getExpandresourceSrc051()
                                : formatList[indexFormat].getClass().getName());
                        if (formatClass.equals(previousFormatClass) == false) {
                            throw new IllegalArgumentException(fMsg
                                    .getMbrbi012(argBaseName
                                            + (argDescription == null ? ""
                                                    : "/" + argDescription),
                                            locale, argFieldResourceId,
                                            formatClass, previousFormatClass));
                        }
                    }
                }
            }
            // ÕXgƂċL܂B
            // null낤낤L_|CgłB
            previousFormatList = formatList;
        }
    }
}