/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.nlpack.generator.csv.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorOmitListCsvRecord;
import blanco.nlpack.generator.csv.util.BlancoCsvRuntimeUtil;

/**
 * t@C`[BlancoNLpackGeneratorOmitList/blancoNLpackGenerator uȂvΏۂ킷CSVt@CB]̃[_NX
 *
 * ̃NXblancoCsvt@C`玩ꂽ[_NXłB<br>
 * @1.񒷃`FbNɂ́AftHgGR[fBO𗘗p܂B<br>
 * @2.NX̗p͕K close()ĂяoĂB<br>
 */
public class BlancoNLpackGeneratorOmitListCsvReader {
    /**
     * [_IuWFNg
     *
     * IɎۂɓ͂s̃[_L܂B
     */
    private BufferedReader fReader;

    /**
     * ̍sJE^
     *
     * ݏsĂs̈ʒuL܂B
     */
    private long fLineCounter = 0;

    /**
     * ݏ̍sf[^
     */
    private String fLine;

    /**
     * ݏ̍ŝ߂̃[_
     */
    private StringReader fLineReader;

    /**
     * CSV[_NX̃RXgN^
     *
     * ^ꂽ[_ƘA܂B
     *
     * @param arg A郊[_
     */
    public BlancoNLpackGeneratorOmitListCsvReader(final BufferedReader arg) {
        fReader = arg;
    }

    /**
     * ̈sǂݍ݂܂
     *
     * @return sIuWFNgԂ܂B͂sꍇɂ nullԂ܂B
     * @throws BlancoCsvIOException ̓f[^sȏꍇȂǁB
     * @throws IOException A惊[_ňُ킪ꍇB
     */
    public BlancoNLpackGeneratorOmitListCsvRecord readRecord() throws BlancoCsvIOException, IOException {
        fLine = fReader.readLine();
        if (fLine == null) {
            // t@C̏I[ɓB܂B
            return null;
        }
        fLineCounter++;
        final BlancoNLpackGeneratorOmitListCsvRecord record = new BlancoNLpackGeneratorOmitListCsvRecord();
        fLineReader = new StringReader(fLine);
        String tokenString = null;

        // ڔԍ[1]ږ[BundleUri/URI]
        tokenString = readToken('\t', false);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 1ږځBڔԍ[1] ږ[BundleUri/URI]̏ɂĕsȏI[m܂B");
        }
        // K{ځB
        if (tokenString.length() == 0) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 1ږځBڔԍ[1] ږ[BundleUri/URI]̏ɂĕK{ڂɒlĂȂƂm܂B");
        }
        record.setBundleUri(tokenString);

        // ڔԍ[2]ږ[Reason/Reason]
        tokenString = readToken('\t', true);
        if (tokenString == null) {
            throw new BlancoCsvIOException("" + fLineCounter + "s 2ږځBڔԍ[2] ږ[Reason/Reason]̏ɂĕsȏI[m܂B");
        }
        // CӍځB
        if (tokenString.length() == 0) {
            // K{ڂł͂Ȃ񍀖ڂɒ0̒lǂݍ܂ꂽꍇɂ́Aǂݍ݌̒lƂĂ0̕Ƃ܂B
            record.setReason(tokenString);
        } else {
            record.setReason(tokenString);
        }
        return record;
    }

    /**
     * IɕێĂ郊[_Ԃ܂B
     *
     * @return IɕێĂ郊[_B
     */
    public BufferedReader getReader() {
        return fReader;
    }

    /**
     * ݏ̍sJE^Ԃ܂B
     *
     * @return ݏ̍sJE^B
     */
    public long getLineCounter() {
        return fLineCounter;
    }

    /**
     * ̃[_܂B
     *
     * ֘AÂĂ[_ɑ΂Ăclose()Ăяo܂B
     *
     * @throws IOException ֘AÂĂ[_close()ɎsꍇB
     */
    public void close() throws IOException {
        fReader.close();
    }

    /**
     * ^ꂽReader ^ꂽf~^găg[No܂
     *
     * @param delimiter f~^
     * @param isEndOfLine s̏I[ł̂ǂtO
     * @return oꂽg[NB͂⃊[_̏ꍇɂnullԂ܂B
     * @throws BlancoCsvIOException ڐȂȂǗ^ꂽɊւOꍇB
     * @throws IOException o͗OꍇB
     */
    protected String readToken(final char delimiter, final boolean isEndOfLine) throws BlancoCsvIOException, IOException {
        final StringBuffer buffer = new StringBuffer();
        for (;;) {
            final int iRead = fLineReader.read();
            if (iRead < 0) {
                // I[ɓBB
                if (isEndOfLine == false) {
                    throw new BlancoCsvIOException("s̏I[łȂ̂ɂւ炸f~^ꂸɍsIĂ܂܂B");
                }
                break;
            }
            if (iRead == delimiter) {
                if (isEndOfLine) {
                    throw new BlancoCsvIOException("s̏I[łׂɂւ炸f~^܂B");
                }
                break;
            } else {
                buffer.append((char) iRead);
            }
        }
        return buffer.toString();
    }

    /**
     * ^ꂽReader _uNI[gt ^ꂽf~^găg[No܂
     *
     * @param delimiter f~^
     * @param isEndOfLine s̏I[ł̂ǂtO
     * @return oꂽg[NB͂⃊[_̏ꍇɂnullԂ܂B
     * @throws BlancoCsvIOException _uNI[g̕svȂǗ^ꂽɊւOꍇB
     * @throws IOException o͗OꍇB
     */
    protected String readTokenWithQuote(final char delimiter, final boolean isEndOfLine) throws BlancoCsvIOException, IOException {
        final StringBuffer buffer = new StringBuffer();
        boolean isStringStarted = false;
        boolean isStringEnded = false;
        for (;;) {
            int iRead = fLineReader.read();
            if (iRead < 0) {
                // I[ɓBB
                if (isStringStarted && isStringEnded == false) {
                    // _uNI[gB
                    fLine = fReader.readLine();
                    if (fLine == null) {
                        // _uNI[gł̂ɂ炸t@C̏I[ɓB܂B
                        break;
                    } else {
                        fLineReader = new StringReader(fLine);
                        continue;
                    }
                } else if (isEndOfLine == false) {
                    throw new BlancoCsvIOException("s̏I[łȂ̂ɂւ炸f~^ꂸɍsIĂ܂܂B");
                }
                break;
            }
            if (isStringStarted == false) {
                if (iRead != '"') {
                    throw new BlancoCsvIOException("_uNI[gŕ񂪊Jn܂B");
                }
                // _uNI[e[V͓ǂݔ΂܂B
                isStringStarted = true;
            } else if (isStringEnded) {
                if (iRead == delimiter) {
                    // I[ɓB܂B
                    if (isEndOfLine) {
                        throw new BlancoCsvIOException("s̏I[łׂɂւ炸f~^܂B");
                    }
                    break;
                }
                throw new BlancoCsvIOException("_uNI[gɂ镶Iɕ񂪗^܂B");
            } else {
                // ʏ̕GA
                if (iRead == '"') {
                    // _uNI[gd˂ꂽ̂łȂǂ`FbN܂B
                    fLineReader.mark(1);
                    if (fLineReader.read() == '"') {
                        // GXP[vꂽ_uNI[g
                        // 2łЂƂȂ̂ŁAЂƂ͓ǂݎ̂Ă܂B
                        buffer.append((char) iRead);
                    } else {
                        // _uNI[gɂGXP[vł͂܂łB
                        // ͏I[ӖĂ܂B
                        fLineReader.reset();
                        isStringEnded = true;
                    }
                } else {
                    buffer.append((char) iRead);
                }
            }
        }
        if (isStringStarted == false) {
            throw new BlancoCsvIOException("_uNI[gKvȕł̂Ƀ_uNI[gɂJn܂łB");
        }
        if (isStringEnded == false) {
            throw new BlancoCsvIOException("_uNI[gKvȕł̂Ƀ_uNI[gɂI܂łB");
        }
        return buffer.toString();
    }
}
