/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xliff;

import java.io.File;

import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffTransUnit;
import blanco.xliff.valueobject.BlancoXliffTransUnitTarget;
import blanco.xml.bind.BlancoXmlMarshaller;
import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlDtd;
import blanco.xml.bind.valueobject.BlancoXmlElement;

public class BlancoXliffUtil {
    /**
     * pGg|CgB
     * 
     * @param args
     */
    public static final void main(final String[] args) {
        final BlancoXliff xliff = new BlancoXliff();
        for (int index = 0; index < 10; index++) {
            final BlancoXliffTransUnit unit = new BlancoXliffTransUnit();
            xliff.getTransUnitList().add(unit);
            unit.setId("a" + index);
            unit.setSource("ugeuge" + index);

            final BlancoXliffTransUnitTarget target = new BlancoXliffTransUnitTarget();
            unit.getTargetList().add(target);
            target.setTarget("" + index);
        }

        new File("./tmp").mkdirs();
        write(xliff, new File("./tmp/Test.xlf"));
    }

    /**
     * XLIFFt@Cɏo͂܂B
     * 
     * @param argXliff
     * @param argFileTarget
     */
    public static void write(final BlancoXliff argXliff,
            final File argFileTarget) {
        new BlancoXmlMarshaller().marshal(valueObject2Document(argXliff),
                argFileTarget);
    }

    /**
     * ^ꂽXLIFF񂩂 blancoXml DOMc[쐬܂B
     * 
     * @param argXliff
     * @return
     */
    public static BlancoXmlDocument valueObject2Document(
            final BlancoXliff argXliff) {
        final BlancoXmlDocument document = new BlancoXmlDocument();

        final BlancoXmlDtd dtd = new BlancoXmlDtd();
        document.getChildNodes().add(dtd);
        dtd.setName("xliff");
        dtd.setPublicId("-//XLIFF//DTD XLIFF//EN");
        dtd
                .setSystemId("http://www.oasis-open.org/committees/xliff/documents/xliff.dtd");

        final BlancoXmlElement element = new BlancoXmlElement();
        element.setQName("xliff");
        document.getChildNodes().add(element);

        final BlancoXmlAttribute attr = new BlancoXmlAttribute();
        element.getAtts().add(attr);
        attr.setQName("version");
        attr.setValue(argXliff.getVersion());

        final BlancoXmlElement file = new BlancoXmlElement();
        element.getChildNodes().add(file);
        file.setQName("file");

        final BlancoXmlAttribute original = new BlancoXmlAttribute();
        file.getAtts().add(original);
        original.setQName("original");
        original.setValue("");
        // TODO file̓eB

        final BlancoXmlAttribute sourceLanguage = new BlancoXmlAttribute();
        file.getAtts().add(sourceLanguage);
        sourceLanguage.setQName("source-language");
        sourceLanguage.setValue(argXliff.getSourceLanguage());
        // TODO file̓eB

        final BlancoXmlAttribute dataType = new BlancoXmlAttribute();
        file.getAtts().add(dataType);
        dataType.setQName("datatype");
        dataType.setValue("PROPERTIES");
        // TODO file̓eB

        final BlancoXmlElement header = new BlancoXmlElement();
        file.getChildNodes().add(header);
        header.setQName("header");

        final BlancoXmlElement body = new BlancoXmlElement();
        file.getChildNodes().add(body);
        body.setQName("body");

        for (int index = 0; index < argXliff.getTransUnitList().size(); index++) {
            final BlancoXliffTransUnit transUnit = (BlancoXliffTransUnit) argXliff
                    .getTransUnitList().get(index);

            final BlancoXmlElement translationUnit = new BlancoXmlElement();
            body.getChildNodes().add(translationUnit);
            translationUnit.setQName("trans-unit");

            final BlancoXmlAttribute tranlationUnitAttr = new BlancoXmlAttribute();
            translationUnit.getAtts().add(tranlationUnitAttr);
            tranlationUnitAttr.setQName("id");
            tranlationUnitAttr.setValue(transUnit.getId());

            final BlancoXmlElement source = new BlancoXmlElement();
            source.setQName("source");
            translationUnit.getChildNodes().add(source);

            final BlancoXmlCharacters sourceValue = new BlancoXmlCharacters();
            sourceValue.setValue(transUnit.getSource());
            source.getChildNodes().add(sourceValue);

            for (int indexTarget = 0; indexTarget < transUnit.getTargetList()
                    .size(); indexTarget++) {
                final BlancoXliffTransUnitTarget transUnitTarget = (BlancoXliffTransUnitTarget) transUnit
                        .getTargetList().get(indexTarget);
                final BlancoXmlElement target = new BlancoXmlElement();
                target.setQName("target");
                translationUnit.getChildNodes().add(target);

                final BlancoXmlAttribute xmlLang = new BlancoXmlAttribute();
                target.getAtts().add(xmlLang);
                xmlLang.setQName("xml:lang");
                xmlLang.setValue(transUnitTarget.getLang());

                final BlancoXmlCharacters targetValue = new BlancoXmlCharacters();
                targetValue.setValue(transUnitTarget.getTarget());
                target.getChildNodes().add(targetValue);
            }
        }
        return document;
    }
}
