/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xliff;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

import blanco.commons.util.BlancoFileUtil;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffTool;

public class BlancoXliffUtil {
    /**
     * XLIFF̃CX^X擾܂B
     * 
     * w肳ꂽfBNgXLIFFɂ΂𗘗p܂BXLIFF܂ꍇɂ̓CX^XVKɍ쐬܂B(t@C쐬͔܂)
     * 
     * @param argXliffdir
     * @param argBundleSymbolicName
     * @return
     */
    public static BlancoXliff getXliffInstance(final File fileXliffdir,
            final String argBundleSymbolicName) {
        BlancoXliff xliff;
        final File fileXliff = new File(fileXliffdir.getAbsolutePath() + "/"
                + argBundleSymbolicName + ".xlf");
        if (fileXliff.exists()) {
            // ݂ꍇɂ͓ǂݍ݂܂B
            xliff = new BlancoXliffParser().parse(fileXliff);
        } else {
            // ݂Ȃꍇɂ͐VK쐬܂B
            xliff = new BlancoXliff();
            xliff.setSourceLanguage("en-US");
            xliff.setTargetLanguage("ja-JP");
        }
        return xliff;
    }

    /**
     * XLIFFۑ܂B
     * 
     * @param xliff
     * @param argXliffdir
     * @param argBundleSymbolicName
     * @return
     * @throws IOException
     */
    public static int saveXliffInstance(final BlancoXliff xliff,
            final File fileXliffdir, final String argBundleSymbolicName)
            throws IOException {
        final File fileXliff = new File(fileXliffdir.getAbsolutePath() + "/"
                + argBundleSymbolicName + ".xlf");
        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();

        new BlancoXliffSerializer().serialize(xliff, outStream);

        return BlancoFileUtil.bytes2FileIfNecessary(outStream.toByteArray(),
                fileXliff);
    }

    /**
     * XLIFF tool o^Zbg܂B
     * 
     * ΒǉAɑ݂ĂΓeXV܂B
     * 
     * @param xliff
     * @param tool
     */
    public static void setTool(final BlancoXliff xliff,
            final BlancoXliffTool tool) {
        for (int index = 0; index < xliff.getToolList().size(); index++) {
            final BlancoXliffTool toolLook = (BlancoXliffTool) xliff
                    .getToolList().get(index);
            if (toolLook.getToolId().equals(tool.getToolId())) {
                // ɑ݂B㏑B
                toolLook.setToolName(tool.getToolName());

                return;
            }
        }

        // ̃c[͖o^Beǉ܂B
        xliff.getToolList().add(tool);
    }
}
