/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xsd;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

import javax.xml.transform.TransformerConfigurationException;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.valueobject.concretesax.BlancoValueObjectSerializer;
import blanco.xsd.parser.BlancoXsdParser;
import blanco.xsd.parser.ComplexTypeFieldStructure;
import blanco.xsd.parser.ComplexTypeStructure;
import blanco.xsd.parser.SimpleTypeStructure;

/**
 * XSD͂Ƃ blancoValueObjectValueObjectNX邽߂ɕKv XMLt@C쐬܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoXsdXsd2ValueObject {
    /**
     * ς̌^L邽߂̃}bvB
     */
    private HashMap processedType = new HashMap();

    /**
     * ^ꂽXSDƂɁAw̃fBNgValueObject쐬邽߂̐ݒt@C𐶐܂B
     * 
     * @param fileSource
     * @param directoryTarget
     * @throws Exception
     */
    public void process(final File fileSource, final File directoryTarget)
            throws Exception {
        // xsdp[X܂B
        BlancoXsdParser parser = new BlancoXsdParser();
        if (fileSource.getName().endsWith(".xsd") == false) {
            // ӁF.xsdŃt@C͏IƉ肵Ă܂B
            throw new IllegalArgumentException("t@C.xsdŏÎw肵ĂB:"
                    + fileSource.getName());
        }
        final ComplexTypeStructure type = parser.process(fileSource, fileSource
                .getName().substring(0, fileSource.getName().length() - 4));
        expandComplexType(type, directoryTarget);
    }

    /**
     * w̃RvbNX^`WJ܂B
     * 
     * @param type
     * @param directoryTarget
     * @throws SAXException
     * @throws IOException
     * @throws TransformerConfigurationException
     */
    private void expandComplexType(final ComplexTypeStructure type,
            final File directoryTarget) throws SAXException, IOException,
            TransformerConfigurationException {

        if (processedType.get(type.getName()) != null) {
            // łɏς݂łB
            return;
        }
        processedType.put(type.getName(), type);

        OutputStream outStream = null;
        try {
            outStream = new BufferedOutputStream(new FileOutputStream(
                    directoryTarget.getAbsolutePath() + "/"
                            + BlancoNameAdjuster.toClassName(type.getName())
                            + ".blancovalueobject"));
            BlancoValueObjectSerializer serializer = new BlancoValueObjectSerializer(
                    outStream);
            serializer.startDocument();
            serializer.startElementWorkbook();
            serializer.characters("\n");
            serializer.startElementSheet("ValueObject");
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementBlancovalueobjectCommon();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementName();
            // O
            serializer.characters(BlancoNameAdjuster
                    .toClassName(type.getName()));
            serializer.endElementName();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementPackage();
            serializer.characters(type.getPackageOfJava());
            serializer.endElementPackage();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementDescription();
            serializer.characters("̃NXxsdJavaNXłB");
            serializer.endElementDescription();
            serializer.characters("\n");
            serializer.characters("    ");
            serializer.startElementFileDescription();
            serializer.characters("̃t@CxsdꂽNXłB");
            serializer.endElementFileDescription();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.endElementBlancovalueobjectCommon();
            serializer.characters("\n");
            serializer.characters("  ");
            serializer.startElementBlancovalueobjectList();
            serializer.characters("\n");

            for (int index = 0; index < type.getListField().size(); index++) {
                ComplexTypeFieldStructure field = (ComplexTypeFieldStructure) type
                        .getListField().get(index);

                if (field.getTypeStructure() instanceof ComplexTypeStructure) {
                    expandComplexType((ComplexTypeStructure) field
                            .getTypeStructure(), directoryTarget);
                }

                serializer.characters("      ");
                // z^ǂɂāAgetTypeOfJavaɊ܂܂ēnĂ܂B
                // ̂܂XMLɏ݂܂B
                serializer.characters("    ");
                serializer.startElementField();
                serializer.characters("\n");
                serializer.characters("      ");
                serializer.characters("\n");
                serializer.characters("      ");
                serializer.startElementName();
                serializer.characters(BlancoNameAdjuster.toClassName(field
                        .getFieldName()));
                serializer.endElementName();
                serializer.characters("\n");
                serializer.characters("      ");
                serializer.startElementType();
                serializer.characters(field.getTypeStructure().getTypeOfJava());
                serializer.endElementType();
                serializer.characters("\n");

                serializer.characters("      ");
                serializer.startElementDescription();
                serializer.characters("tB[h[" + field.getFieldName() + "]łB");
                serializer.endElementDescription();
                serializer.characters("\n");

                if (field.getTypeStructure() instanceof SimpleTypeStructure) {
                    SimpleTypeStructure simpleType = (SimpleTypeStructure) field
                            .getTypeStructure();
                    if (simpleType.getMinLength() != null) {
                        serializer.startElementMinLength();
                        serializer.characters(simpleType.getMinLength());
                        serializer.endElementMinLength();
                    }

                    if (simpleType.getMaxLength() != null) {
                        serializer.startElementMaxLength();
                        serializer.characters(simpleType.getMaxLength());
                        serializer.endElementMaxLength();
                    }

                    if (simpleType.getMinInclusive() != null) {
                        serializer.startElementMinInclusive();
                        serializer.characters(simpleType.getMinInclusive());
                        serializer.endElementMinInclusive();
                    }

                    if (simpleType.getMaxInclusive() != null) {
                        serializer.startElementMaxInclusive();
                        serializer.characters(simpleType.getMaxInclusive());
                        serializer.endElementMaxInclusive();
                    }

                    if (simpleType.getPattern() != null) {
                        serializer.startElementPattern();
                        serializer.characters(simpleType.getPattern());
                        serializer.endElementPattern();
                    }
                }

                serializer.characters("    ");
                serializer.endElementField();
                serializer.characters("\n");
            }
            serializer.characters("  ");
            serializer.endElementBlancovalueobjectList();
            serializer.characters("\n");
            serializer.endElementSheet();
            serializer.characters("\n");
            serializer.endElementWorkbook();
            serializer.endDocument();

            outStream.flush();
            outStream.close();
            outStream = null;
        } finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }
}