/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xsd.parser;

import blanco.xsd.BlancoXsdTypeMapping;
import blanco.xsd.BlancoXsdUtil;

/**
 * RvbNX^̂Ȃ̈̃tB[hێ邽߂̃NXłB
 * 
 * @author IGA Tosiki
 */
public class ComplexTypeFieldStructure {
    /**
     * fobO[hœ삷邩ǂB
     */
    private static final boolean IS_DEBUG = false;

    /**
     * ̃tB[hێ^B
     */
    private AbstractTypeStructure typeStructure;

    /**
     * tB[hB
     */
    private String fieldName;

    /**
     * minOccursB
     */
    private String minOccurs;

    /**
     * maxOccursB
     */
    private String maxOccurs;

    /**
     * RvbNX^̂Ȃ̈̃tB[hێ邽߂̃NXłB
     * 
     * @param type
     *            ^
     * @param fieldName
     *            tB[h
     * @param minOccur
     *            minOccursw
     * @param maxOccur
     *            maxOccursw
     */
    public ComplexTypeFieldStructure(final AbstractTypeStructure type,
            String fieldName, String minOccur, String maxOccur) {
        // IuWFNgRs[ėpĂ܂B
        this.typeStructure = (AbstractTypeStructure) type.clone();
        this.fieldName = fieldName;
        this.minOccurs = minOccur;
        this.maxOccurs = maxOccur;

        if (minOccurs != null && minOccurs.equals("0")
                && typeStructure.getTargetNamespace() != null) {
            if (IS_DEBUG) {
                System.out.println("minOccurs0`FbN["
                        + typeStructure.getTypeOfNamespace() + "]");
            }
            final String foundType = BlancoXsdTypeMapping.xsdType2JavaType(type
                    .getTypeOfNamespace(), minOccurs);
            if (foundType != null) {
                // v~eBu^ɑ΂郉bp[֌^܂B
                // minOccurs0ł̂ŁAbp[֌^̗p܂B
                if (IS_DEBUG) {
                    System.out.println("bp[^ɕύX[" + foundType + "]");
                }
                this.typeStructure.setTypeOfJava(foundType);
            }
        }

        // z̏ꍇɂ ̏ꏊJavǎ^ƂĂ̔z񉻂Zbg܂B
        if (BlancoXsdUtil.isMaxOccursArray(maxOccurs)) {
            this.typeStructure.setTypeOfJava(this.typeStructure.getTypeOfJava()
                    + "[]");
        }
    }

    public String getFieldName() {
        return fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getMaxOccurs() {
        return maxOccurs;
    }

    public void setMaxOccurs(String maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public AbstractTypeStructure getTypeStructure() {
        return typeStructure;
    }

    public void setTypeStructure(AbstractTypeStructure typeStructure) {
        this.typeStructure = typeStructure;
    }

    public String getMinOccurs() {
        return minOccurs;
    }

    public void setMinOccurs(String minOccurs) {
        this.minOccurs = minOccurs;
    }
}
