/*
 * blanco Framework
 * Copyright(C) 2006-2008 NTT DATA BUSINESS BRAINS CORPORATION.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.soap.terasoluna.rich;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.xml.transform.TransformerException;

import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.MethodExpander;
import blanco.wsdl.parser.BlancoWsdlParser;
import blanco.wsdl.valueobject.BlancoWsdlWebService;
import blanco.wsdl.valueobject.BlancoWsdlWebServiceOperation;

/**
 * WSDLControllerNXB
 * 
 * ̃NX́AblancoSOAPTERASOLUNA RichΉg̈ꕔƂȂ܂B
 * ȂAControllerNX́ÃNXƈقȂAOό`Ȃ_ɒӂ邱ƁB
 * 
 * @author IGA Tosiki
 * @version 1.0
 */
public class TerasolunaBLogicWsdl2Controller {
    /**
     * WSDLt@C̉͌
     */
    private BlancoWsdlWebService fWsdl = null;

    /**
     * d`ւ̃}bvB
     */
    private HashMap fMapTelegramProcessDef = null;

    /**
     * ̂̂WSDLt@CB
     * 
     * WSDLt@C͂Ƃ Controller̂߂Java\[XR[h𐶐B
     * 
     * @param fileSource
     *            WSDLt@CB
     * @param mapTelegramProcessDef
     *            d`MAP
     * @param directoryTarget
     *            Java\[XR[h̏o͐fBNgB
     * @throws IOException
     *             o͗OꍇB
     * @throws TransformerException
     *             XMLϊOꍇB
     */
    public void process(final File fileSource,
            final HashMap mapTelegramProcessDef, final File directoryTarget)
            throws IOException, TransformerException {
        fWsdl = new BlancoWsdlParser().parse(fileSource);
        fMapTelegramProcessDef = mapTelegramProcessDef;

        // WSDL̂̂̂operationWJB
        final ArrayList listOperation = fWsdl.getOperationList();
        for (int indexOperation = 0; indexOperation < listOperation.size(); indexOperation++) {
            final BlancoWsdlWebServiceOperation operation = (BlancoWsdlWebServiceOperation) listOperation
                    .get(indexOperation);

            expandOperation(operation, directoryTarget);
        }
    }

    /**
     * WSDLoperation̋Lqɏ] ControllerWJB
     * 
     * @param operation
     *            WSDL̃Iy[V
     * @param directoryTarget
     *            Java\[XR[ho͐fBNgB
     * @throws IOException
     *             o͗OꍇB
     */
    private void expandOperation(final BlancoWsdlWebServiceOperation operation,
            final File directoryTarget) throws IOException {
        // d`̃}bvAd`̏o[IuWFNĝƏƂĎoB
        final BlancoWsdlWebServiceOperation telegramProcessDefInfo = TerasolunaBLogicUtil
                .getTelegramProcessorDef(operation.getName(),
                        fMapTelegramProcessDef);

        final String targetBLogicPackage = fWsdl.getPackage();
        // Rg[͌Oό`Ȃ̂łAނ𓾂擪͑啶܂B
        final String targetControllerName = BlancoNameAdjuster
                .toUpperCaseTitle(operation.getName());

        // Controller̖Ô̂́AOό`Ȃ_ɒ!
        final ClassExpander classExpander = new ClassExpander(new Type(
                targetBLogicPackage, targetControllerName + "Controller")) {
            protected void expandClassStruct() {
                final Type typeController = new Type(
                        "jp.terasoluna.fw.web.rich.springmvc.controller.TerasolunaController");
                typeController.setGenerics(BlancoNameAdjuster
                        .toClassName(operation.getInput().getName())
                        + ", "
                        + BlancoNameAdjuster.toClassName(operation.getOutput()
                                .getName()));
                setSuperClass(typeController);

                addFileComment("Richł̃Rg[SNXłB <br>");
                addFileComment("̃NX blancoɂ莩Ă܂B");

                getJavaDoc().addLine(
                        "dID[" + operation.getName()
                                + "]̃Rg[NX(Controller)łB");
                getJavaDoc().addLine("");
                if (BlancoStringUtil.null2Blank(
                        telegramProcessDefInfo.getDescription()).length() > 0) {
                    // uv݂ꍇɂ̂ݏo͂܂B
                    getJavaDoc()
                            .addLine(
                                    ": "
                                            + BlancoJavaSourceUtil
                                                    .escapeStringAsJavaDoc(telegramProcessDefInfo
                                                            .getDescription())
                                            + "<br>");
                }
                getJavaDoc().addLine(
                        "̃NX̓t[[N(TERASOLUNA)̂݌Ăяo܂B<br>");
                getJavaDoc().addLine("Ɩ͂̃NX͒ڌĂяoȂłB<br>");

                getJavaDoc().addLine("<br>");
                getJavaDoc().addLine("Controller`̗̋LɎ܂B<br>");
                getJavaDoc().addLine("<pre>");

                // bean`̋̓IȋLqe JavaDocɓWJB
                // Rg[͖Oό`Ȃ_ɒӁB
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc("<bean name=\"/"
                                        + operation.getName() + "Controller\"")
                                + "<br>");
                getJavaDoc()
                        .addLine(
                                BlancoJavaSourceUtil
                                        .escapeStringAsJavaDoc("    class=\""
                                                + targetBLogicPackage + "."
                                                + targetControllerName
                                                + "Controller\"")
                                        + "<br>");
                getJavaDoc()
                        .addLine(
                                BlancoJavaSourceUtil
                                        .escapeStringAsJavaDoc("    parent=\"pojoXmlRequestCastorViewController\" singleton=\"false\">")
                                        + "<br>");
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil
                                .escapeStringAsJavaDoc("    <property name=\""
                                        + BlancoNameAdjuster
                                                .toParameterName(operation
                                                        .getName())
                                        + "BLogic\" ref=\""
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName())
                                        + "BLogic\" />")
                                + "<br>");
                getJavaDoc().addLine(
                        BlancoJavaSourceUtil.escapeStringAsJavaDoc("</bean>"));
                getJavaDoc().addLine("</pre>");

                // rWlXWbÑCX^XLtB[hB
                final FieldExpander blogic = new FieldExpander(new Type(
                        targetBLogicPackage, BlancoNameAdjuster
                                .toClassName(operation.getName())
                                + "BLogic"), "f"
                        + BlancoNameAdjuster.toClassName(operation.getName())
                        + "BLogic");
                blogic.getJavaDoc().addLine("rWlXWbÑCX^XLtB[hϐB");
                addField(blogic);

                addMethod(new MethodExpander("set"
                        + BlancoNameAdjuster.toClassName(operation.getName())
                        + "BLogic") {
                    protected Scope getScope() {
                        return Scope.PUBLIC;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "dID[" + operation.getName()
                                        + "]̃rWlXWbNZbg܂B");
                        getJavaDoc().addLine("");
                        getJavaDoc().addLine(
                                "rWlXWbN["
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName())
                                        + "BLogicImpl]Zbg܂B<BR>");
                        getJavaDoc().addLine("̃\bhTERASOLUNAĂяo܂B<BR>");
                        getJavaDoc().addParameter(
                                "arg"
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName()) + "BLogic",
                                "BLogicIuWFNg");
                        addArgument(new Value(new Type(targetBLogicPackage,
                                BlancoNameAdjuster.toClassName(operation
                                        .getName())
                                        + "BLogic"), "arg"
                                + BlancoNameAdjuster.toClassName(operation
                                        .getName()) + "BLogic"));
                    }

                    public void implement() {
                        getData().addLine(
                                "f"
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName())
                                        + "BLogic"
                                        + " = arg"
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName()) + "BLogic"
                                        + ";");
                    }
                });

                addMethod(new MethodExpander("executeService") {
                    protected Scope getScope() {
                        return Scope.PUBLIC;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "dID[" + operation.getName()
                                        + "]̃rWlXWbNւ̃Rg[łB");
                        getJavaDoc().addLine("");
                        getJavaDoc().addLine(
                                "̃\bhۂ̃rWlXWbNLqꂽ["
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName())
                                        + "BLogicImpl]Ăяo܂B<BR>");
                        getJavaDoc().addLine("̃\bhTERASOLUNAĂяo܂B<BR>");
                        getJavaDoc().addParameter(
                                "input",
                                "vd[" + operation.getInput().getName()
                                        + "]IuWFNgB");
                        addArgument(new Value(new Type(operation.getInput()
                                .getTypeOfJava()), "input"));
                        getJavaDoc().addReturn(
                                "d[" + operation.getOutput().getName()
                                        + "]IuWFNgB");
                        setReturnType(new Type(operation.getOutput()
                                .getTypeOfJava()));
                    }

                    public void implement() {

                        getData().addLine(
                                "// dID["
                                        + operation.getName()
                                        + "]̃rWlXWbN["
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName())
                                        + "BLogicImpl]sB");

                        getData().addLine(
                                "return f"
                                        + BlancoNameAdjuster
                                                .toClassName(operation
                                                        .getName())
                                        + "BLogic.execute(input);");
                    }
                });
            }
        };

        TerasolunaBLogicUtil.generateJavaSource(classExpander, directoryTarget);
    }
}
