package blanco.xliff.util.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import blanco.commons.util.BlancoStringUtil;
import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.stringgroup.BlancoXliffStateStringGroup;
import blanco.xliff.util.BlancoXliffUtilConstants;
import blanco.xliff.util.task.valueobject.BlancoXliffUtilMergeProcessInput;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffAltTrans;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffNote;
import blanco.xliff.valueobject.BlancoXliffTarget;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoXliffUtilMergeProcessImpl implements
        BlancoXliffUtilMergeProcess {
    private BlancoXliffUtilMergeProcessInput fInput = null;

    public int execute(final BlancoXliffUtilMergeProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File sourceDir = new File(fInput.getSourcedir());
        if (sourceDir.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ sourcedir["
                    + sourceDir.getAbsolutePath() + "]݂͑܂B");
        }
        if (sourceDir.isDirectory() == false) {
            throw new IllegalArgumentException("w肳ꂽ sourcedir["
                    + sourceDir.getAbsolutePath() + "]̓fBNgł͂܂B");
        }

        final File targetDir = new File(fInput.getTargetdir());
        if (targetDir.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ targetdir["
                    + targetDir.getAbsolutePath() + "]݂͑܂B");
        }
        if (targetDir.isDirectory() == false) {
            throw new IllegalArgumentException("w肳ꂽ targetdir["
                    + targetDir.getAbsolutePath() + "]̓fBNgł͂܂B");
        }

        if (sourceDir.getCanonicalPath().equals(targetDir.getCanonicalPath())) {
            throw new IllegalArgumentException("sourcedir["
                    + sourceDir.getAbsolutePath() + "]  targetdir["
                    + targetDir.getAbsolutePath() + "] Ƃ͓fBNgłB");
        }

        final File[] targetFiles = targetDir.listFiles();
        if (targetFiles == null) {
            return 0;
        }
        for (int index = 0; index < targetFiles.length; index++) {
            if (targetFiles[index].isFile() == false) {
                continue;
            }
            if (targetFiles[index].getName().endsWith(".xlf")) {
                processXliff(targetFiles[index], sourceDir);
            }
        }

        return 0;
    }

    private void processXliff(final File fileTarget, final File sourceDir)
            throws IOException {
        final File fileSource = new File(sourceDir.getAbsoluteFile() + "/"
                + fileTarget.getName());
        if (fileSource.exists() == false) {
            //  XLIFF ݂͑܂B
            return;
        }

        final String bundleSymbolicName = fileTarget.getName().substring(0,
                fileTarget.getName().length() - ".xlf".length());
        final BlancoXliff xliffTarget = BlancoXliffUtil.getXliffInstance(
                fileTarget.getParentFile(), bundleSymbolicName);
        final BlancoXliff xliffSource = BlancoXliffUtil.getXliffInstance(
                fileSource.getParentFile(), bundleSymbolicName);
        final Map<String, BlancoXliffTransUnit> mapSource = new HashMap<String, BlancoXliffTransUnit>();
        buildMap(xliffSource, mapSource);

        for (int indexFile = 0; indexFile < xliffTarget.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) xliffTarget
                    .getFileList().get(indexFile);
            for (int indexTransUnit = 0; indexTransUnit < file.getBody()
                    .getTransUnitList().size(); indexTransUnit++) {
                final BlancoXliffTransUnit targetUnit = (BlancoXliffTransUnit) file
                        .getBody().getTransUnitList().get(indexTransUnit);
                final BlancoXliffTransUnit sourceUnit = mapSource
                        .get(targetUnit.getId());
                if (sourceUnit == null) {
                    // ł
                    continue;
                }

                //  trans-unit }[W܂B
                mergeTransUnit(targetUnit, sourceUnit);
            }
        }

        // }[Wʂۑ܂B
        switch (BlancoXliffUtil.saveXliffInstance(xliffTarget, fileTarget
                .getParentFile(), bundleSymbolicName)) {
        case 1:
            // {IɁAɂ͓Ȃ݁B
            if (fInput.getVerbose()) {
                System.out.println("xliff: merge: create: "
                        + bundleSymbolicName);
            }
            break;
        case 2:
            if (fInput.getVerbose()) {
                System.out.println("xliff: merge: update: "
                        + bundleSymbolicName);
            }
            break;
        case 0:
            if (fInput.getVerbose()) {
                System.out.println("xliff: merge: skip  : "
                        + bundleSymbolicName);
            }
            break;
        }
    }

    private void mergeTransUnit(final BlancoXliffTransUnit targetUnit,
            final BlancoXliffTransUnit sourceUnit) {
        // note΁A]: Jn
        for (int indexNote = 0; indexNote < sourceUnit.getNoteList().size(); indexNote++) {
            final BlancoXliffNote note = (BlancoXliffNote) sourceUnit
                    .getNoteList().get(indexNote);
            if (BlancoStringUtil.null2Blank(note.getFrom()).equals(
                    "blanconlpackgenerator.version")
                    || BlancoStringUtil.null2Blank(note.getFrom()).equals(
                            "blanconlpackgenerator.action")) {
                continue;
            }

            // e note  targetɑ݂邩ǂ`FbNB
            boolean isEqualExist = false;
            for (int indexTargetNote = 0; indexTargetNote < targetUnit
                    .getNoteList().size(); indexTargetNote++) {
                final BlancoXliffNote targetNote = (BlancoXliffNote) targetUnit
                        .getNoteList().get(indexTargetNote);
                if (BlancoStringUtil.null2Blank(note.getFrom()).equals(
                        BlancoStringUtil.null2Blank(targetNote.getFrom())) == false) {
                    // from قȂ̂́AႤ̂ƔfB
                    continue;
                }
                if (BlancoStringUtil.null2Blank(note.getText()).equals(
                        BlancoStringUtil.null2Blank(targetNote.getText())) == false) {
                    // eLXgeقȂ΁AႤ̂ƔfB
                    continue;
                }
                // ɓo^܂B
                isEqualExist = true;
            }

            if (isEqualExist == false) {
                targetUnit.getNoteList().add(note);
            }
        }
        // note΁A]: I

        if (targetUnit.getTranslate() == false) {
            // |svB
            return;
        }

        if (sourceUnit.getTranslate() == false) {
            // KvɉāAsource  translate="no" ]܂B
            if (BlancoStringUtil.null2Blank(sourceUnit.getSource()).equals(
                    BlancoStringUtil.null2Blank(targetUnit.getSource()))) {
                // translate="no"  source \[XE^[Qbgňvꍇɂ͖|ΏۊOB
                targetUnit.setTranslate(false);
                return;
            } else {
                System.out.println("trace: ςĂ܂[" + sourceUnit.getId()
                        + "]");
            }
        }

        // ȊO͖|ɂĂ̍lKv trans-unit

        if (BlancoStringUtil.null2Blank(sourceUnit.getSource()).length() == 0
                || sourceUnit.getTarget() == null
                || BlancoStringUtil.null2Blank(
                        sourceUnit.getTarget().getTarget()).length() == 0) {
            // source ̏ꍇȂǂɂ͏łȂ̂ŁAXLbv܂B
            return;
        }

        // alt-transZbg܂B
        setAltTransTarget(fInput.getToolid(), targetUnit, sourceUnit
                .getSource(), sourceUnit.getTarget().getTarget());

        // {ƂȂ|{܂B
        translate(targetUnit, sourceUnit);
    }

    /**
     * |{܂B
     * 
     * @param targetUnit
     * @param sourceUnit
     */
    private void translate(final BlancoXliffTransUnit targetUnit,
            final BlancoXliffTransUnit sourceUnit) {
        final String sourceSourceText = BlancoStringUtil.null2Blank(sourceUnit
                .getSource());
        String sourceTargetText = "";
        if (sourceUnit.getTarget() != null) {
            sourceTargetText = BlancoStringUtil.null2Blank(sourceUnit
                    .getTarget().getTarget());
        }
        final String targetSourceText = BlancoStringUtil.null2Blank(targetUnit
                .getSource());
        String targetTargetText = "";
        if (targetUnit.getTarget() != null) {
            targetTargetText = BlancoStringUtil.null2Blank(targetUnit
                    .getTarget().getTarget());
        }

        // Ώtrans-unit source, target ǂ̂炢قȂ̂`FbNB
        final boolean isSourceEqual = sourceSourceText.equals(targetSourceText);
        final boolean isTargetEqual = sourceTargetText.equals(targetTargetText);
        if (isSourceEqual && isTargetEqual) {
            // equal
            // |󌳁A|̗vԁB
        } else if (isSourceEqual && !isTargetEqual) {
            // change.o
            // |݈̂قȂԁB

            if (targetUnit.getTarget() == null) {
                // o͂ςĂāAtargetw̏ꍇɂ͖|ƂăZbgׂΏۂłB

                if (fInput.getSettargetifnotexist()) {
                    // ZbgtOON̏ꍇɂ̂ݖ|Zbg{B

                    final BlancoXliffTarget target = new BlancoXliffTarget();
                    targetUnit.setTarget(target);
                    target.setTarget(sourceUnit.getTarget().getTarget());
                    target
                            .setState(new BlancoXliffStateStringGroup()
                                    .convertToString(BlancoXliffStateStringGroup.NEEDS_REVIEW_TRANSLATION));
                }
            }
        } else if (!isSourceEqual && isTargetEqual) {
            // change.i
            // |󌳂݈̂قȂԁB
        } else {
            // change.io
            // |󌳁A|̗قȂԁB
        }
    }

    private void buildMap(final BlancoXliff xliffInput,
            final Map<String, BlancoXliffTransUnit> mapOutput) {
        for (int indexFile = 0; indexFile < xliffInput.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) xliffInput
                    .getFileList().get(indexFile);
            for (int indexTransUnit = 0; indexTransUnit < file.getBody()
                    .getTransUnitList().size(); indexTransUnit++) {
                final BlancoXliffTransUnit unit = (BlancoXliffTransUnit) file
                        .getBody().getTransUnitList().get(indexTransUnit);
                mapOutput.put(unit.getId(), unit);
            }
        }
    }

    /**
     * targetZbg܂B
     * 
     * @param transUnit
     * @param targetString
     * @return
     */
    private boolean setAltTransTarget(final String tool_id,
            final BlancoXliffTransUnit transUnit, final String sourceString,
            final String targetString) {
        boolean isModified = false;

        if (BlancoXliffUtil.getAltTrans(transUnit, tool_id, BlancoStringUtil
                .null2Blank(sourceString), BlancoStringUtil
                .null2Blank(targetString)) == null) {
            isModified = true;
            final BlancoXliffAltTrans altTransNew = new BlancoXliffAltTrans();
            transUnit.getAltTransList().add(altTransNew);
            altTransNew.setToolId(tool_id);
            altTransNew.setSource(sourceString);
            final BlancoXliffTarget target = new BlancoXliffTarget();
            altTransNew.setTarget(target);
            target.setTarget(targetString);

            final BlancoXliffNote note = new BlancoXliffNote();
            note.setFrom(BlancoXliffUtilConstants.PRODUCT_NAME_LOWER
                    + ".version");
            note.setText(BlancoXliffUtilConstants.VERSION);
            altTransNew.getNoteList().add(note);
        }

        return isModified;
    }
}
