package blanco.pleiades.util.task;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Map.Entry;

import blanco.pleiades.util.task.valueobject.BlancoPleiadesUtilPleiades2TmxProcessInput;
import blanco.tmx.BlancoTmxSerializer;
import blanco.tmx.valueobject.BlancoTmx;
import blanco.tmx.valueobject.BlancoTmxTu;
import blanco.tmx.valueobject.BlancoTmxTuv;

public class BlancoPleiadesUtilPleiades2TmxProcessImpl implements
        BlancoPleiadesUtilPleiades2TmxProcess {
    private BlancoPleiadesUtilPleiades2TmxProcessInput fInput = null;

    public int execute(final BlancoPleiadesUtilPleiades2TmxProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File sourceFile = new File(fInput.getSourcefile());
        if (sourceFile.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ sourcefile["
                    + sourceFile.getAbsolutePath() + "]݂͑܂B");
        }
        if (sourceFile.isFile() == false) {
            throw new IllegalArgumentException("w肳ꂽ sourcefile["
                    + sourceFile.getAbsolutePath() + "]̓t@Cł͂܂B");
        }

        final File targetFile = new File(fInput.getTargetfile());
        if (targetFile.exists()) {
            if (targetFile.delete() == false)
                throw new IllegalArgumentException("w肳ꂽ targetfile["
                        + targetFile.getAbsolutePath()
                        + "]݂̂ō폜݂܂s܂B");
        }

        if (sourceFile.getCanonicalPath().equals(targetFile.getCanonicalPath())) {
            throw new IllegalArgumentException("sourcefile["
                    + sourceFile.getAbsolutePath() + "]  targetfile["
                    + targetFile.getAbsolutePath() + "] Ƃ͓t@CłB");
        }

        if (targetFile.getParentFile().exists() == false) {
            if (targetFile.getParentFile().mkdirs() == false) {
                throw new IllegalArgumentException("w肳ꂽ targetfile["
                        + targetFile.getAbsolutePath()
                        + "]i[邽߂̃fBNg쐬݂܂s܂B");
            }
        }

        process(sourceFile, targetFile);

        return 0;
    }

    private void process(final File fileSource, final File fileTarget)
            throws IOException {
        final BlancoTmx tmx = new BlancoTmx();

        final Iterator ite = readProperties(fileSource).entrySet().iterator();
        for (; ite.hasNext();) {
            final BlancoTmxTu tu = new BlancoTmxTu();
            tmx.getBody().getTuList().add(tu);
            final Entry entry = (Entry) ite.next();

            {
                final BlancoTmxTuv tuv = new BlancoTmxTuv();
                tu.getTuvList().add(tuv);
                tuv.setLang("EN-US");
                tuv.setSeg(entry.getKey().toString());
            }
            {
                final BlancoTmxTuv tuv = new BlancoTmxTuv();
                tu.getTuvList().add(tuv);
                tuv.setLang("JA");
                tuv.setSeg(entry.getValue().toString());
            }
        }

        final BlancoTmxSerializer serializer = new BlancoTmxSerializer();
        if (fInput.getIsindentxml() == false) {
            serializer.setIndent(false);
        }
        serializer.serialize(tmx, fileTarget);
    }

    private Properties readProperties(final File fileSource) throws IOException {
        final Properties props = new Properties();
        props.load(new BufferedInputStream(new FileInputStream(fileSource)));
        return props;
    }
}
