/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.LinkedList;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import jp.sourceforge.mergedoc.pleiades.aspect.AbstractTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationLoggingTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.TranslationTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.util.Files;

public class LauncherTransformer
extends AbstractTransformer {
    private static final Logger log = Logger.getLogger(LauncherTransformer.class);

    public LauncherTransformer() {
        this.load();
    }

    protected void load() {
        AspectMapping.getInstance();
        Pleiades.getExecutorService().execute(new Runnable(){

            public void run() {
                TranslationExcludeProperties.getInstance();
                RegexDictionary.getInstance();
            }
        });
    }

    protected byte[] transform(ClassLoader loader, String className, ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        if (className.endsWith(".launcher.Main")) {
            if (!log.isDebugEnabled()) {
                Pleiades.getInstrumentation().removeTransformer(this);
            }
            return this.transformMainClass(protectionDomain, bytecode);
        }
        if (className.equals("org.eclipse.ui.internal.Workbench")) {
            Pleiades.getInstrumentation().removeTransformer(this);
            return this.transformWorkbenchClass(protectionDomain, bytecode);
        }
        return null;
    }

    protected byte[] transformMainClass(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        String splashLocation;
        CtClass clazz = this.createCtClass(bytecode, protectionDomain);
        CtMethod method = clazz.getMethod("basicRun", "([Ljava/lang/String;)V");
        String className = this.getClass().getName();
        method.insertBefore("$1 = " + className + ".startTranslationTransformer($$);");
        method.insertAfter(String.valueOf(className) + ".destroy();", true);
        PleiadesOption agentOption = Pleiades.getPleiadesOption();
        if (!agentOption.isDefaultSplash() && (splashLocation = LauncherTransformer.getSplashLocation()) != null) {
            System.setProperty("osgi.splashLocation", splashLocation);
        }
        return clazz.toBytecode();
    }

    protected byte[] transformWorkbenchClass(ProtectionDomain protectionDomain, byte[] bytecode) throws CannotCompileException, NotFoundException, IOException {
        return null;
    }

    public static String[] startTranslationTransformer(String ... args) {
        try {
            LinkedList argList = new LinkedList(Arrays.asList(args));
            PleiadesOption option = Pleiades.getPleiadesOption();
            option.setClean(argList.contains("-clean"));
            log.info("Eclipse \u306e\u8d77\u52d5\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002-clean:" + option.isClean());
            Instrumentation inst = Pleiades.getInstrumentation();
            if (log.isDebugEnabled()) {
                inst.addTransformer(new TranslationLoggingTransformer());
            } else {
                inst.addTransformer(new TranslationTransformer());
            }
            return argList.toArray(new String[0]);
        }
        catch (Throwable e) {
            String msg = "\u7ffb\u8a33\u30c8\u30e9\u30f3\u30b9\u30d5\u30a9\u30fc\u30de\u30fc\u306e\u958b\u59cb\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            IllegalStateException ise = new IllegalStateException(msg, e);
            Pleiades.abort(ise);
            return null;
        }
    }

    public static void destroy() {
        TranslationTransformer.destroy();
    }

    public static String getSplashLocation() {
        String version = "";
        File home = Pleiades.getEclipseHomePath();
        if (home == null) {
            return null;
        }
        File pluginsFolder = new File(home, "plugins");
        File[] fileArray = pluginsFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File folder = fileArray[n2];
            String folderName = folder.getName();
            if (folderName.startsWith("org.eclipse.osgi_")) {
                version = folderName.replaceFirst(".*?_(\\d+\\.\\d+).*", "$1");
                break;
            }
            ++n2;
        }
        String fileName = "splash" + version + ".bmp";
        File file = Files.getResourceFile(fileName);
        if (!file.exists()) {
            fileName = "splash.bmp";
        }
        File splashFile = Files.getResourceFile(fileName);
        return splashFile.getAbsolutePath().replace('\\', '/');
    }
}

