/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect;

import java.awt.Toolkit;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import jp.sourceforge.mergedoc.pleiades.aspect.ITimingLogger;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherLoggingTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.LauncherTransformer;
import jp.sourceforge.mergedoc.pleiades.aspect.PleiadesOption;
import jp.sourceforge.mergedoc.pleiades.aspect.SafetyExecutorService;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.log.PopupFileLogger;
import jp.sourceforge.mergedoc.pleiades.util.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pleiades {
    private static Logger log;
    private static PleiadesOption pleiadesOption;
    private static File configurationPath;
    private static File eclipseHomePath;
    private static Instrumentation instrumentation;
    private static ExecutorService executorService;
    private static List<ITimingLogger> timeingLoggers;

    public static void premain(String option, Instrumentation inst) throws Throwable {
        try {
            pleiadesOption = new PleiadesOption(option);
            instrumentation = inst;
            Pleiades.init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        try {
            executorService = new SafetyExecutorService();
            executorService.execute(new Runnable(){

                public void run() {
                    try {
                        Pleiades.initSwingFont();
                    }
                    catch (Throwable e) {
                        log.debug("Swing \u306e LookAndFeel \u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + e);
                    }
                    if (log.isDebugEnabled()) {
                        File file = new File(Pleiades.getConfigurationPath(), "system.properties");
                        Files.storeProperties(System.getProperties(), file, "\u5b9f\u884c\u6642\u30b7\u30b9\u30c6\u30e0\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
                    }
                }
            });
            if (log.isDebugEnabled()) {
                inst.addTransformer(new LauncherLoggingTransformer());
            } else {
                inst.addTransformer(new LauncherTransformer());
            }
            File dir = Files.resourceRoot.getParentFile().getParentFile();
            while (dir != null) {
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName;
                    File file = fileArray[n2];
                    if (file.isFile() && ((fileName = file.getName()).equals("eclipse") || fileName.equals("eclipse.exe"))) {
                        eclipseHomePath = dir;
                        break;
                    }
                    ++n2;
                }
                dir = dir.getParentFile();
            }
            log.info("Pleiades AOP \u7ffb\u8a33\u30b3\u30f3\u30c6\u30ca\u30fc\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002Pleiades \u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3:" + option + " Eclipse \u30db\u30fc\u30e0\u30fb\u30d1\u30b9:" + eclipseHomePath);
        }
        catch (Throwable e) {
            Pleiades.abort(e);
        }
    }

    private static void init() {
        File baseDir;
        String base;
        Matcher mat;
        File pleiadesHome = Files.resourceRoot.getParentFile().getParentFile().getParentFile();
        File configPath = new File(pleiadesHome, "configuration");
        Properties configIni = Files.loadProperties(new File(configPath, "config.ini"));
        String CONFIG_AREA_KEY = "osgi.configuration.area";
        String configArea = configIni.getProperty("osgi.configuration.area");
        if (configArea == null) {
            configArea = System.getProperty("osgi.configuration.area");
        }
        File userConfigPath = null;
        if (configArea != null && (mat = Pattern.compile("^@([\\w\\.]+)(.+)$").matcher(configArea)).find() && (base = System.getProperty(mat.group(1))) != null && (baseDir = new File(base)).exists()) {
            String childPath = mat.group(2);
            userConfigPath = new File(baseDir, childPath);
        }
        if (userConfigPath == null) {
            userConfigPath = configPath;
        }
        configurationPath = new File(userConfigPath, "jp.sourceforge.mergedoc.pleiades/");
        configurationPath.mkdirs();
        File logFile = new File(Pleiades.getConfigurationPath(), "pleiades.log");
        System.setProperty("pleiades.log.file.name", logFile.getAbsolutePath());
        System.setProperty("pleiades.logger.class.name", PopupFileLogger.class.getName());
        System.setProperty("pleiades.log.level", pleiadesOption.getLogLevel());
        log = Logger.getLogger(Pleiades.class);
    }

    private static void initSwingFont() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.contains("mac")) {
            return;
        }
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        FontUIResource propoFont = new FontUIResource("MS UI Gothic", 0, 12);
        FontUIResource fixedFont = new FontUIResource("MS Gothic", 0, 12);
        if (!osName.contains("windows")) {
            propoFont = new FontUIResource("sansserif", 0, 12);
            fixedFont = new FontUIResource("sansserif", 0, 12);
        }
        for (Object keyObj : UIManager.getLookAndFeelDefaults().keySet()) {
            String key = keyObj.toString();
            if (!key.endsWith("font") && !key.endsWith("Font")) continue;
            UIManager.put(key, propoFont);
        }
        UIManager.put("TextPane.font", fixedFont);
        UIManager.put("TextArea.font", fixedFont);
    }

    public static void abort(Throwable e) {
        try {
            log.fatal("Pleiades AOP \u7ffb\u8a33\u30b3\u30f3\u30c6\u30ca\u30fc\u306e\u8d77\u52d5\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\n\u8d77\u52d5\u30aa\u30d7\u30b7\u30e7\u30f3\u306b -clean \u3092\u6307\u5b9a\u3057\u3066\u8d77\u52d5\u3057\u3066\u304f\u3060\u3055\u3044\u3002", e);
            executorService.shutdownNow();
        }
        finally {
            System.exit(-1);
        }
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static PleiadesOption getPleiadesOption() {
        return pleiadesOption;
    }

    public static File getConfigurationPath() {
        return configurationPath;
    }

    public static File getEclipseHomePath() {
        return eclipseHomePath;
    }

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public static void registTimingLogger(ITimingLogger timeingLogger) {
        Pleiades.getTimeingLoggers().add(timeingLogger);
    }

    public static List<ITimingLogger> getTimeingLoggers() {
        if (timeingLoggers == null) {
            timeingLoggers = new LinkedList<ITimingLogger>();
        }
        return timeingLoggers;
    }
}

