/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.aspect.resource;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.AspectMapping;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.JointPoint;
import jp.sourceforge.mergedoc.pleiades.aspect.advice.PointCut;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.DynamicTranslationLoggingDictionary;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.TranslationExcludeProperties;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.AbstractTranslationDictionary;
import jp.sourceforge.mergedoc.pleiades.util.Files;
import jp.sourceforge.mergedoc.pleiades.util.UnMnemonicProperties;

public class DynamicTranslationDictionary
extends AbstractTranslationDictionary {
    private static final Logger log = Logger.getLogger(DynamicTranslationDictionary.class);
    private static final File cacheFile = new File(Pleiades.getConfigurationPath(), "translation-cached.properties");
    private static final DynamicTranslationDictionary singleton = log.isDebugEnabled() ? new DynamicTranslationLoggingDictionary() : new DynamicTranslationDictionary();
    private int loadedSize;

    public static DynamicTranslationDictionary getInstance() {
        return singleton;
    }

    protected String getValue(String enNoMnemonic) {
        String result = super.getValue(enNoMnemonic);
        if (enNoMnemonic.equals("\n\nSelect File > Refresh to refresh the file.")) {
            String s = String.valueOf(System.currentTimeMillis()) + " [" + enNoMnemonic + "] \u2192 [" + result + "]";
            log.debug("\u30c7\u30d0\u30c3\u30b0\u7ffb\u8a33\u8ffd\u8de1\u30b9\u30bf\u30c3\u30af\u30c8\u30ec\u30fc\u30b9", new Exception(s));
            return s;
        }
        this.getMap().put(enNoMnemonic, result);
        return result;
    }

    protected String editMnemonicEnToJa(String en, String enNoMnemonic, String jaNoMnemonic) {
        if (Pleiades.getPleiadesOption().isNoMnemonic()) {
            return jaNoMnemonic;
        }
        return super.editMnemonicEnToJa(en, enNoMnemonic, jaNoMnemonic);
    }

    protected void load() {
        if (Pleiades.getPleiadesOption().isClean() || !cacheFile.exists()) {
            super.load();
        } else {
            Map<String, String> map = this.getMap();
            map.putAll(this.loadProperties(cacheFile));
            log.info("\u7ffb\u8a33\u8f9e\u66f8\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + map.size());
        }
        this.loadedSize = this.getMap().size();
    }

    public void store() {
        Map<String, String> map = this.getMap();
        if (map.size() > this.loadedSize) {
            Properties prop = new Properties();
            prop.putAll(map);
            Files.storeProperties(prop, cacheFile, "\u7ffb\u8a33\u8f9e\u66f8\u30ad\u30e3\u30c3\u30b7\u30e5\u30fb\u30d7\u30ed\u30d1\u30c6\u30a3\u30fc");
            log.info("\u7ffb\u8a33\u8f9e\u66f8\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u4fdd\u7ba1\u3057\u307e\u3057\u305f\u3002" + this.loadedSize + " -> " + prop.size());
        }
    }

    public String lookup(String en, JointPoint jointPoint) {
        if (UnMnemonicProperties.hasJaMnemonic(en)) {
            return en;
        }
        String enNoMnemonic = UnMnemonicProperties.removeEnMnemonic(en);
        if (this.isNoTranslation(enNoMnemonic, jointPoint)) {
            String enMnemonicJa = this.editMnemonicEnToJa(en, enNoMnemonic, enNoMnemonic);
            return enMnemonicJa;
        }
        String jaNoMnemonic = this.getValue(enNoMnemonic);
        String ja = this.editMnemonicEnToJa(en, enNoMnemonic, jaNoMnemonic);
        return ja;
    }

    public String lookupIgnoreMnemonic(String en, JointPoint jointPoint) {
        if (UnMnemonicProperties.hasJaMnemonic(en)) {
            return en;
        }
        if (this.isNoTranslation(en, jointPoint)) {
            return en;
        }
        String ja = this.getValue(en);
        return ja;
    }

    protected boolean isNoTranslation(String enNoMnemonic, JointPoint jointPoint) {
        Set<String> noTransPathEntries;
        List<JointPoint> excludeTrace;
        PointCut pointCut;
        int TRACE_MAX = 30;
        StackTraceElement[] stes = null;
        if (jointPoint != null && (pointCut = AspectMapping.getInstance().getPointCut(jointPoint)) != null && (excludeTrace = pointCut.getExcludeTrace()).size() > 0) {
            stes = Thread.currentThread().getStackTrace();
            for (JointPoint jp : excludeTrace) {
                int i = 0;
                while (i < 30 && i < stes.length) {
                    String methodName;
                    StackTraceElement ste = stes[i];
                    String className = jp.getClassName();
                    if (className.equals(ste.getClassName()) && ((methodName = jp.getMethodName()) == null || methodName.equals(ste.getMethodName()))) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        if ((noTransPathEntries = TranslationExcludeProperties.getInstance().getPathEntries(enNoMnemonic)) != null) {
            if (stes == null) {
                stes = Thread.currentThread().getStackTrace();
            }
            int i = 0;
            while (i < 30 && i < stes.length) {
                StackTraceElement ste = stes[i];
                String className = ste.getClassName();
                for (String noTransPath : noTransPathEntries) {
                    if (!className.startsWith(noTransPath)) continue;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

