/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jp.sourceforge.mergedoc.pleiades.aspect.Pleiades;
import jp.sourceforge.mergedoc.pleiades.aspect.resource.RegexDictionary;
import jp.sourceforge.mergedoc.pleiades.log.Logger;
import jp.sourceforge.mergedoc.pleiades.resource.TranslationNotFoundProperties;
import jp.sourceforge.mergedoc.pleiades.util.Files;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTranslationDictionary {
    private static final Logger log = Logger.getLogger(AbstractTranslationDictionary.class);
    public static final String PROP_FILE_NAME = "translation.properties";
    private static final String ADDITIONS_DIRECTORY = "additions";
    public static final String CONVERTER_PROPERTIES_FILE_NAME = "translation-converter.properties";
    private final Map<String, String> map = new HashMap<String, String>();

    protected AbstractTranslationDictionary() {
        this.load();
    }

    protected void load() {
        File propFile = Files.getResourceFile(PROP_FILE_NAME);
        if (!propFile.exists()) {
            FileNotFoundException e = new FileNotFoundException(propFile.getPath());
            IllegalStateException ise = new IllegalStateException("\u7ffb\u8a33\u8f9e\u66f8\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002", e);
            Pleiades.abort(ise);
        }
        this.map.putAll(this.loadProperties(propFile));
        File additions = Files.getResourceFile(ADDITIONS_DIRECTORY);
        if (additions.exists()) {
            Object[] files = additions.listFiles();
            Arrays.sort(files);
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object file = objectArray[n2];
                if (((File)file).isFile() && ((File)file).getName().endsWith(".properties")) {
                    this.map.putAll(this.loadProperties((File)file));
                }
                ++n2;
            }
        }
        log.info("\u7ffb\u8a33\u8f9e\u66f8\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f\u3002" + this.map.size());
        this.applyConverter();
    }

    protected void applyConverter() {
        File convFile = Files.getResourceFile(CONVERTER_PROPERTIES_FILE_NAME);
        if (convFile.exists()) {
            HashMap<? extends String, ? extends String> convMap = new HashMap<String, String>();
            convMap.putAll(this.loadProperties(convFile));
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String value;
                String key = entry.getKey();
                String resultValue = value = entry.getValue();
                for (Map.Entry e : convMap.entrySet()) {
                    String convKey = (String)e.getKey();
                    String convValue = (String)e.getValue();
                    resultValue = resultValue.replaceAll(convKey, convValue);
                }
                if (value.equals(resultValue)) continue;
                this.map.put(key, resultValue);
            }
        }
    }

    protected Map<String, String> getMap() {
        return this.map;
    }

    protected Map<? extends String, ? extends String> loadProperties(File file) {
        Properties prop = Files.loadProperties(file);
        return prop;
    }

    protected String getValue(String enNoMnemonic) {
        String result = this.map.get(enNoMnemonic);
        if (result == null) {
            result = this.getValueToTrim(enNoMnemonic);
        }
        if (result == null) {
            result = enNoMnemonic;
        }
        return result;
    }

    protected String getValueToTrim(String enNoMnemonic) {
        String enTrimmed;
        String result;
        StringBuilder leading = new StringBuilder();
        char[] cArray = enNoMnemonic.toCharArray();
        int i = 0;
        while (i < cArray.length) {
            char c = cArray[i];
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') break;
            leading.append(c);
            ++i;
        }
        if (leading.length() == enNoMnemonic.length()) {
            return null;
        }
        StringBuilder trailing = new StringBuilder();
        int i2 = cArray.length - 1;
        while (i2 > 0) {
            char c = cArray[i2];
            if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == ':') {
                trailing.insert(0, c);
            } else {
                if (c != '.' || i2 <= 2 || cArray[i2 - 1] != '.' || cArray[i2 - 2] != '.') break;
                trailing.insert(0, "...");
                i2 -= 2;
            }
            --i2;
        }
        if ((result = this.map.get(enTrimmed = enNoMnemonic.substring(leading.length(), enNoMnemonic.length() - trailing.length()))) == null && (result = this.getValueByRegex(enTrimmed)) == null) {
            TranslationNotFoundProperties.getInstance().println(enNoMnemonic);
        }
        if (result != null) {
            result = leading + result + trailing;
        }
        return result;
    }

    protected String getValueByRegex(String enTrimmed) {
        return RegexDictionary.getInstance().lookup(enTrimmed);
    }

    protected String editMnemonicEnToJa(String en, String enNoMnemonic, String jaNoMnemonic) {
        if (en.equals(enNoMnemonic)) {
            return jaNoMnemonic;
        }
        String mnemonicChar = en.replaceFirst("(?s)^.*?\\&([\\w\\.@]).*$", "$1");
        if (mnemonicChar.length() != 1) {
            log.error("Mnemonic invalid length: " + mnemonicChar.length());
            log.error(" enValue:            " + en);
            log.error(" enValueNonMnemonic: " + enNoMnemonic);
            log.error(" mnemonicChar:       " + mnemonicChar);
            return en;
        }
        String mnemonicJa = "(&" + mnemonicChar.toUpperCase() + ")";
        String ja = jaNoMnemonic.replaceFirst("(?s)^(.+?)((\\s*\\.{3,4}|)@\\p{ASCII}+|\\.{3,4}(</a>|)\\s*|\\s*|:\\s*|:\\s+\\{[0-9]\\}\\s*|(:|)\\s+\\(.+\\)\\s*|\\s+(-*|)>+\\s*)$", "$1" + mnemonicJa + "$2");
        return ja;
    }
}

