/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.mergedoc.pleiades.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class Files {
    public static final File resourceRoot;

    static {
        String markResource = "/.marker";
        URL url = Files.class.getResource(markResource);
        if (url == null) {
            String msg = "\u30af\u30e9\u30b9\u30d1\u30b9\u4e0a\u306b\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002" + markResource;
            FileNotFoundException e = new FileNotFoundException(msg);
            System.err.println(String.valueOf(msg) + " " + e);
            throw new IllegalStateException(msg, e);
        }
        String path = new File(url.getPath()).getParent();
        String unicodePath = Files.decodePath(path);
        resourceRoot = new File(unicodePath);
    }

    private Files() {
    }

    public static String decodePath(String path) {
        try {
            return URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static File getResourceFile(String resourcePath) {
        return new File(resourceRoot, resourcePath);
    }

    public static String relativePath(File folder, File file) {
        try {
            String folderPath = folder.getCanonicalPath();
            String filePath = file.getCanonicalPath();
            return filePath.replace(folderPath, "");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(folder + ", " + file, e);
        }
    }

    public static Properties loadProperties(File file) {
        Properties prop = new Properties();
        if (!file.exists()) {
            return prop;
        }
        BufferedInputStream is = null;
        try {
            try {
                is = new BufferedInputStream(new FileInputStream(file));
                prop.load(is);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(file.toString(), e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return prop;
    }

    public static Properties loadProperties(String resourcePath) {
        return Files.loadProperties(Files.getResourceFile(resourcePath));
    }

    public static void storeProperties(Properties prop, File file, String title) {
        Properties propOld = Files.loadProperties(file);
        if (propOld.equals(prop)) {
            System.out.println("\u65e2\u5b58\u30d5\u30a1\u30a4\u30eb\u3068\u5185\u5bb9\u304c\u540c\u3058\u3067\u3042\u308b\u305f\u3081\u4fdd\u5b58\u3057\u307e\u305b\u3093\u3002" + file);
            return;
        }
        BufferedOutputStream os = null;
        try {
            try {
                os = new BufferedOutputStream(new FileOutputStream(file));
                LinkedList<String> headerList = new LinkedList<String>();
                headerList.add("\u3053\u306e\u30d5\u30a1\u30a4\u30eb\u306f Pleiades \u306b\u3088\u308a\u751f\u6210\u3055\u308c\u307e\u3057\u305f\u3002" + prop.size() + " \u30a8\u30f3\u30c8\u30ea\u30fc\u3002");
                headerList.add("###############################################################################");
                headerList.add("# ");
                String[] stringArray = title.split("\\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    headerList.add("# " + s);
                    ++n2;
                }
                headerList.add("# ");
                headerList.add("###############################################################################");
                String header = StringUtils.join(headerList, (String)"\n");
                prop.store(os, header);
                List list = FileUtils.readLines((File)file, (String)"ISO-8859-1");
                LinkedList<String> resultList = new LinkedList<String>();
                int i = 0;
                while (i < headerList.size() + 1) {
                    resultList.add((String)list.remove(0));
                    ++i;
                }
                Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
                resultList.addAll(list);
                FileUtils.writeLines((File)file, (String)"ISO-8859-1", resultList);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(file.toString(), e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public static void storeProperties(Properties prop, String resourcePath, String title) {
        File resourceFile = Files.getResourceFile(resourcePath);
        Files.storeProperties(prop, resourceFile, title);
    }
}

