package blanco.xliff.util.task;

import java.io.File;
import java.io.IOException;

import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.stringgroup.BlancoXliffStateStringGroup;
import blanco.xliff.util.task.valueobject.BlancoXliffUtilExtractNeedsTranslationProcessInput;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoXliffUtilExtractNeedsTranslationProcessImpl implements
        BlancoXliffUtilExtractNeedsTranslationProcess {
    private BlancoXliffUtilExtractNeedsTranslationProcessInput fInput = null;

    private BlancoXliff fXliffTarget = new BlancoXliff();

    public int execute(
            final BlancoXliffUtilExtractNeedsTranslationProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File fileXliffdir = new File(input.getXliffdir());
        final File[] files = fileXliffdir.listFiles();
        if (files == null) {
            return 0;
        }
        for (int index = 0; index < files.length; index++) {
            if (files[index].isFile() == false) {
                continue;
            }
            if (files[index].getName().endsWith(".xlf")) {
                process(fileXliffdir, files[index]);
            }
        }

        final File fileTargetfile = new File(fInput.getTargetfile());
        if (fileTargetfile.getParentFile().exists() == false) {
            fileTargetfile.getParentFile().mkdirs();
        }
        BlancoXliffUtil.saveXliffInstance(fXliffTarget, new File(fileTargetfile
                .getParentFile().getAbsolutePath()), fileTargetfile.getName()
                .substring(0,
                        fileTargetfile.getName().length() - ".xlf".length()));

        return 0;
    }

    private void process(final File fileXliffdir, final File fileTarget)
            throws IOException {

        final String bundleSymbolicName = fileTarget.getName().substring(0,
                fileTarget.getName().length() - ".xlf".length());

        final BlancoXliff fXliff = BlancoXliffUtil.getXliffInstance(
                fileXliffdir, bundleSymbolicName);

        for (int indexFile = 0; indexFile < fXliff.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) fXliff.getFileList()
                    .get(indexFile);
            processFile(file);
        }
    }

    private void processFile(final BlancoXliffFile file) {
        for (int index = 0; index < file.getBody().getTransUnitList().size(); index++) {
            final BlancoXliffTransUnit transUnit = (BlancoXliffTransUnit) file
                    .getBody().getTransUnitList().get(index);

            if (transUnit.getTranslate() == false) {
                // OځB
                continue;
            }

            if (transUnit.getTarget() == null) {
                // Ώ
                processTransUnit(transUnit);
            } else {
                switch (new BlancoXliffStateStringGroup()
                        .convertToInt(transUnit.getTarget().getTarget())) {
                case BlancoXliffStateStringGroup.NEEDS_TRANSLATION:
                case BlancoXliffStateStringGroup.NEW:
                    // Ώ
                    processTransUnit(transUnit);
                    break;
                default:
                    // ΏۊO
                    break;
                }
            }
        }
    }

    private void processTransUnit(final BlancoXliffTransUnit transUnit) {
        if (fXliffTarget.getFileList().size() == 0) {
            final BlancoXliffFile xliffFile = new BlancoXliffFile();
            fXliffTarget.getFileList().add(xliffFile);
        }

        final BlancoXliffFile xliffFile = (BlancoXliffFile) fXliffTarget
                .getFileList().get(0);

        //  source ̑̓o^Ȃǂ`FbN܂B
        for (int indexExist = 0; indexExist < xliffFile.getBody()
                .getTransUnitList().size(); indexExist++) {
            final BlancoXliffTransUnit registered = (BlancoXliffTransUnit) xliffFile
                    .getBody().getTransUnitList().get(indexExist);
            if (registered.getSource().equals(transUnit.getSource())) {
                // ɓo^B
                // ɏXLbv܂B
                // Note]̂悤ȏ ̃P[Xł͕svłB
                return;
            }
        }

        xliffFile.getBody().getTransUnitList().add(transUnit);
    }
}
