/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.nlpack.generator.csv.io;

import java.io.BufferedWriter;
import java.io.IOException;

import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorResultCsvRecord;
import blanco.nlpack.generator.csv.util.BlancoCsvRuntimeUtil;

/**
 * t@C`[BlancoNLpackGeneratorResult/blancoNLpackGenerator IɗpCSVt@CB]̃C^NX
 *
 * ̃NXblancoCsvt@C`玩ꂽC^NXłB<br>
 * @1.񒷃`FbNɂ́AftHgGR[fBO𗘗p܂B<br>
 * @2.NX̗p͕K close()ĂяoĂB<br>
 */
public class BlancoNLpackGeneratorResultCsvWriter {
    /**
     * C^IuWFNg
     *
     * IɎۂɏo͂s̃C^L܂B
     */
    private BufferedWriter fWriter;

    /**
     * ̍sJE^
     *
     * ݏsĂs̈ʒuL܂B
     */
    private long fLineCounter = 0;

    /**
     * CSVC^NX̃RXgN^
     *
     * ^ꂽC^ƘA܂B
     *
     * @param arg A郉C^
     */
    public BlancoNLpackGeneratorResultCsvWriter(final BufferedWriter arg) {
        fWriter = arg;
    }

    /**
     * CSVt@C̃^Cgso܂
     *
     * ^Cg̓f~^ŋ؂Ȃ烉C^ɏo͂AŌɉsR[ht^܂B<br>
     * ^Cg̓_uNI[e[Vň͂܂܂B
     *
     * @throws IOException AꂽC^[o͂̍ۂɗOꍇB
     */
    public void writeTitle() throws IOException {
        fWriter.write("\"SymbolicName\"");
        fWriter.write(",\"URI\"");
        fWriter.write(",\"Action\"");
        fWriter.write(",\"Hit\"");
        fWriter.write(",\"Mnemon\"");
        fWriter.write(",\"Omit\"");
        fWriter.write(",\"Miss\"");
        fWriter.newLine();
    }

    /**
     * ^ꂽso܂
     *
     * f[^̓f~^ŋ؂Ȃ烉C^ɏo͂AŌɉsR[ht^܂B
     *
     * @param record R[hIuWFNg
     * @throws BlancoCsvIOException ^ꂽR[h̍ڒlsȏꍇȂǁB
     * @throws IOException AꂽC^[o͂̍ۂɗOꍇB
     */
    public void writeRecord(final BlancoNLpackGeneratorResultCsvRecord record) throws BlancoCsvIOException, IOException {
        String writeToken = null;

        // ڔԍ[1] ږ[BundleSymbolicName/SymbolicName]
        if (record.getBundleSymbolicName() == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 1ږځBڔԍ[1] ږ[BundleSymbolicName/SymbolicName]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        if (record.getBundleSymbolicName().length() == 0) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 1ږځBڔԍ[1] ږ[BundleSymbolicName/SymbolicName]̏ɂĕK{ڂɒ0̕񂪗^Ă邱Ƃm܂B");
        }
        writeToken = record.getBundleSymbolicName();
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 1ږځBڔԍ[1] ږ[BundleSymbolicName/SymbolicName]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[2] ږ[BundleUri/URI]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getBundleUri() == null ? "" : record.getBundleUri();
        if (writeToken.length() > 0) {
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[3] ږ[Action/Action]
        // CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B
        // ̏ꍇɂ͒`FbN͍s܂B
        writeToken = record.getAction() == null ? "" : record.getAction();
        if (writeToken.length() > 0) {
            if (writeToken.getBytes().length < 4) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 3ږځBڔԍ[3] ږ[Action/Action]̏ɂMIN(4)Zl[" + writeToken + "]m܂B");
            }
            if (writeToken.getBytes().length > 6) {
                throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 3ږځBڔԍ[3] ږ[Action/Action]̏ɂMAX(6)l[" + writeToken + "]m܂B");
            }
        }
        // _uNI[gtŏos܂B
        fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));
        fWriter.write(',');

        // ڔԍ[4] ږ[ReplaceHitCount/Hit]
        writeToken = String.valueOf(record.getReplaceHitCount());
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 4ږځBڔԍ[4] ږ[ReplaceHitCount/Hit]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        fWriter.write(writeToken);
        fWriter.write(',');

        // ڔԍ[5] ږ[ReplaceMnemonicCount/Mnemon]
        writeToken = String.valueOf(record.getReplaceMnemonicCount());
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 5ږځBڔԍ[5] ږ[ReplaceMnemonicCount/Mnemon]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        fWriter.write(writeToken);
        fWriter.write(',');

        // ڔԍ[6] ږ[ReplaceOmitCount/Omit]
        writeToken = String.valueOf(record.getReplaceOmitCount());
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 6ږځBڔԍ[6] ږ[ReplaceOmitCount/Omit]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        fWriter.write(writeToken);
        fWriter.write(',');

        // ڔԍ[7] ږ[ReplaceMissCount/Miss]
        writeToken = String.valueOf(record.getReplaceMissCount());
        if (writeToken == null) {
            throw new BlancoCsvIOException("o" + (fLineCounter + 1) + "s 7ږځBڔԍ[7] ږ[ReplaceMissCount/Miss]̏ɂĕK{ڂnull^Ă邱Ƃm܂B");
        }
        fWriter.write(writeToken);

        // ŌɉsR[ht^܂B
        fWriter.newLine();
        fLineCounter++;
    }

    /**
     * IɕێĂ郉C^Ԃ܂B
     *
     * @return IɕێĂ郉C^B
     */
    public BufferedWriter getWriter() {
        return fWriter;
    }

    /**
     * ݏ̍sJE^Ԃ܂B
     *
     * @return ݏ̍sJE^B
     */
    public long getLineCounter() {
        return fLineCounter;
    }

    /**
     * ̃C^tbV܂B
     *
     * ֘AÂĂC^ɑ΂Ăflush()Ăяo܂B
     *
     * @throws IOException ֘AÂĂC^flush()ɎsꍇB
     */
    public void flush() throws IOException {
        fWriter.flush();
    }

    /**
     * ̃C^܂B
     *
     * ֘AÂĂC^ɑ΂Ăclose()Ăяo܂B
     *
     * @throws IOException ֘AÂĂC^close()ɎsꍇB
     */
    public void close() throws IOException {
        fWriter.close();
    }
}
