package blanco.nlpack.generator.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

/**
 * NI[gĂCSVt@C̃NI[g񕜂邽߂̃[eBeB
 * 
 * ܂Ă܂B
 */
public class NormalizeResultDetailCsvFile {

    public static void main(final String[] args) throws IOException {
        new File("./tmp/quote").mkdirs();
        final File[] files = new File("./tmp").listFiles();
        for (int index = 0; index < files.length; index++) {
            if (files[index].isFile() == false) {
                continue;
            }
            if (files[index].getName().endsWith(".csv") == false) {
                continue;
            }
            new NormalizeResultDetailCsvFile().process(files[index], new File(
                    "./tmp/quote/" + files[index].getName()));
        }
    }

    private void process(final File input, final File output)
            throws IOException {
        System.out.println("NormalizeResultDetailCsvFile: " + input.getName());

        final BufferedReader reader = new BufferedReader(new FileReader(input));
        final BufferedWriter writer = new BufferedWriter(new FileWriter(output));

        boolean isProcessQuote = false;
        for (;;) {
            reader.mark(1);
            final int read = reader.read();
            if (read < 0) {
                break;
            }

            final char readChar = (char) read;

            if (readChar == '"') {
                // NI[gJnB
                writer.write(readChar);
                processQuote(reader, writer);
                isProcessQuote = true;
            } else if (readChar == ',') {
                // ̍ڂƔf܂B
                if (isProcessQuote == false) {
                    writer.write('"');
                    writer.write('"');
                }
                writer.write(readChar);
                isProcessQuote = false;
            } else if (readChar == '\n') {
                // ̍ڂƔf܂B
                if (isProcessQuote == false) {
                    writer.write('"');
                    writer.write('"');
                }
                writer.write(readChar);
                isProcessQuote = false;
            } else {
                reader.reset();
                processNonQuote(reader, writer);
                isProcessQuote = false;
            }
        }

        writer.close();
        reader.close();
    }

    private void processQuote(final BufferedReader reader,
            final BufferedWriter writer) throws IOException {
        // ݃NI[głB
        for (;;) {
            reader.mark(1);
            final int read = reader.read();
            if (read < 0) {
                reader.reset();
                break;
            }

            final char readChar = (char) read;

            if (readChar == '"') {
                // ꂪ NI[g̏I[A邢̓NI[g̃GXP[vɂĔf̕Kv܂B
                reader.mark(1);
                final int read2 = reader.read();
                if (read2 < 0) {
                    throw new IllegalArgumentException("肦Ȃ");
                }

                writer.write(readChar);

                final char readChar2 = (char) read2;
                if (readChar2 == '"') {
                    // ͏I[ł͂ȂAPȂGXP[vłB
                    // ǂݍ񂾂P͔j܂B
                } else {
                    // I[Ɣf܂B
                    reader.reset();
                    break;
                }
            } else {
                writer.write(readChar);
            }
        }
    }

    private void processNonQuote(final BufferedReader reader,
            final BufferedWriter writer) throws IOException {
        // ݍڒłB
        writer.write('"');
        for (;;) {
            reader.mark(1);
            final int read = reader.read();
            if (read < 0) {
                reader.reset();
                writer.write('"');
                break;
            }

            final char readChar = (char) read;

            if (readChar == '\n') {
                // I
                writer.write('"');
                writer.write(readChar);
                break;
            }
            if (readChar == ',') {
                writer.write('"');
                writer.write(readChar);
                break;
            }

            if (readChar == '\r') {
                // 
                continue;
            }

            writer.write(readChar);
        }
    }
}
