/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator.util;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import blanco.commons.util.BlancoStringUtil;
import blanco.nlpack.generator.BlancoNLpackGeneratorResultDetailUtil;
import blanco.nlpack.generator.csv.io.BlancoCsvIOException;
import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorResultDetailCsvRecord;

/**
 * ResultDetail\[g܂B
 * 
 * @author IGA Tosiki
 */
public class SortResultDetail {
    public static void main(final String[] args) throws IOException,
            BlancoCsvIOException {
        new SortResultDetail()
                .process(
                        new File(
                                "tmp/NLpackja-eclipse-SDK-3.3.2-win32-blancofw20080323-ResultDetail.csv"),
                        new File("tmp/sorted.csv"));
    }

    public void process(final File fileInput, final File fileOutput)
            throws IOException, BlancoCsvIOException {
        final List<BlancoNLpackGeneratorResultDetailCsvRecord> list = new ArrayList<BlancoNLpackGeneratorResultDetailCsvRecord>();
        BlancoNLpackGeneratorResultDetailUtil.loadResultDetail(fileInput, list);

        Collections.sort(list,
                new Comparator<BlancoNLpackGeneratorResultDetailCsvRecord>() {
                    public int compare(
                            final BlancoNLpackGeneratorResultDetailCsvRecord o1,
                            final BlancoNLpackGeneratorResultDetailCsvRecord o2) {
                        final int compareResult1 = BlancoStringUtil
                                .trim(
                                        stripIgnorableChar(BlancoStringUtil
                                                .null2Blank(o1.getInput())))
                                .compareTo(
                                        BlancoStringUtil
                                                .trim(stripIgnorableChar(BlancoStringUtil
                                                        .null2Blank(o2
                                                                .getInput()))));
                        if (compareResult1 != 0) {
                            return compareResult1;
                        }
                        final int compareResult2 = BlancoStringUtil.null2Blank(
                                o1.getInput()).compareTo(
                                BlancoStringUtil.null2Blank(o2.getInput()));
                        if (compareResult2 != 0) {
                            return compareResult2;
                        }
                        return o1.getBundleUri().compareTo(o2.getBundleUri());
                    }
                });

        BlancoNLpackGeneratorResultDetailUtil
                .saveResultDetail(fileOutput, list);
    }

    private static String stripIgnorableChar(final String arg) {
        try {
            final StringReader reader = new StringReader(arg);
            final StringWriter writer = new StringWriter();
            for (;;) {
                int iRead = reader.read();
                if (iRead < 0) {
                    break;
                }
                final char readChar = (char) iRead;
                switch (readChar) {
                case '"':
                case '&':
                case '\'':
                case ':':
                case '?':
                case '(':
                case ')':
                case '{':
                case '}':
                case '<':
                case '>':
                case '0':
                case '1':
                case '2':
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case '\n':
                    break;
                default:
                    writer.write(readChar);
                    break;
                }
            }
            reader.close();
            writer.close();
            return writer.toString().toUpperCase();
        } catch (IOException e) {
            throw new IllegalArgumentException("肦ȂO", e);
        }
    }
}
