/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator.task;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import blanco.commons.util.BlancoStringUtil;
import blanco.nlpack.generator.BlancoNLpackGeneratorConstants;
import blanco.nlpack.generator.csv.io.BlancoCsvIOException;
import blanco.nlpack.generator.csv.io.BlancoNLpackGeneratorResultDetailCsvWriter;
import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorResultDetailCsvRecord;
import blanco.nlpack.generator.dictionary.BlancoNLpackGeneratorPleiadesDictionary;
import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorDiffXliffPleiadesToTranslationFragmentProcessInput;
import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffNote;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoNLpackGeneratorDiffXliffPleiadesToTranslationFragmentProcessImpl
        implements
        BlancoNLpackGeneratorDiffXliffPleiadesToTranslationFragmentProcess {
    private BlancoNLpackGeneratorDiffXliffPleiadesToTranslationFragmentProcessInput fInput = null;

    /**
     * Pleiades̃CX^XB
     */
    private BlancoNLpackGeneratorPleiadesDictionary fPleiadesDictionary = new BlancoNLpackGeneratorPleiadesDictionary();

    private BlancoNLpackGeneratorResultDetailCsvWriter fWriter = null;

    private final List<BlancoNLpackGeneratorResultDetailCsvRecord> listNew = new ArrayList<BlancoNLpackGeneratorResultDetailCsvRecord>();

    private final List<BlancoNLpackGeneratorResultDetailCsvRecord> listChange = new ArrayList<BlancoNLpackGeneratorResultDetailCsvRecord>();

    /**
     * XLIFF܂ē񂪔ꂽꍇ̂߂ɁA̓tB[hϐłKv܂B
     */
    private final Map<String, BlancoXliffTransUnit> fMapProcessed = new HashMap<String, BlancoXliffTransUnit>();

    public int execute(
            final BlancoNLpackGeneratorDiffXliffPleiadesToTranslationFragmentProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File xliffDir = new File(fInput.getXliffdir());
        if (xliffDir.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ xliffdir["
                    + xliffDir.getAbsolutePath() + "]݂͑܂B");
        }
        if (xliffDir.isDirectory() == false) {
            throw new IllegalArgumentException("w肳ꂽ xliffdir["
                    + xliffDir.getAbsolutePath() + "]̓fBNgł͂܂B");
        }

        final File targetFile = new File(fInput.getTargetfile());
        if (targetFile.getParentFile().exists() == false) {
            if (targetFile.getParentFile().mkdirs() == false) {
                throw new IllegalArgumentException("w肳ꂽ targetfile["
                        + xliffDir.getAbsolutePath()
                        + "]̊i[fBNĝō쐬݂܂s܂B");
            }
        }

        fWriter = new BlancoNLpackGeneratorResultDetailCsvWriter(
                new BufferedWriter(new OutputStreamWriter(new FileOutputStream(
                        fInput.getTargetfile()), "Windows-31J")));
        try {
            fWriter.writeTitle();

            final File[] xliffFiles = xliffDir.listFiles();
            if (xliffFiles == null) {
                return 0;
            }
            for (int index = 0; index < xliffFiles.length; index++) {
                if (xliffFiles[index].isFile() == false) {
                    continue;
                }
                if (xliffFiles[index].getName().endsWith(".xlf")) {
                    processXliff(xliffFiles[index], xliffDir);
                }
            }

            // oB
            for (BlancoNLpackGeneratorResultDetailCsvRecord record : listNew) {
                try {
                    fWriter.writeRecord(record);
                } catch (BlancoCsvIOException e) {
                    throw new IOException("CSVo͗O: " + e.toString());
                }
            }

            for (BlancoNLpackGeneratorResultDetailCsvRecord record : listChange) {
                try {
                    fWriter.writeRecord(record);
                } catch (BlancoCsvIOException e) {
                    throw new IOException("CSVo͗O: " + e.toString());
                }
            }

        } finally {
            fWriter.close();
        }

        System.out.println("diff: xliff-pleiades: add:" + listNew.size()
                + ", change:" + listChange.size());

        return 0;
    }

    private void processXliff(final File fileSource, final File sourceDir)
            throws IOException {

        final String bundleSymbolicName = fileSource.getName().substring(0,
                fileSource.getName().length() - ".xlf".length());
        final BlancoXliff xliffSource = BlancoXliffUtil.getXliffInstance(
                fileSource.getParentFile(), bundleSymbolicName);

        for (int indexFile = 0; indexFile < xliffSource.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) xliffSource
                    .getFileList().get(indexFile);
            for (int indexTransUnit = 0; indexTransUnit < file.getBody()
                    .getTransUnitList().size(); indexTransUnit++) {
                final BlancoXliffTransUnit transUnit = (BlancoXliffTransUnit) file
                        .getBody().getTransUnitList().get(indexTransUnit);
                if (transUnit.getTarget() == null) {
                    continue;
                }
                if (BlancoStringUtil.null2Blank(
                        transUnit.getTarget().getTarget()).length() == 0) {
                    continue;
                }

                final String pleiadesTrans = fPleiadesDictionary
                        .lookup(transUnit.getSource());
                if (transUnit.getTarget().getTarget().equals(pleiadesTrans) == true) {
                    continue;
                }

                if (getNoteOmitTm(transUnit) != null) {
                    // |󃁃ΏۊOłB
                    // System.out.println("TRACE: |󃁃ΏۊO: "
                    // + sourceUnit.getId());
                    continue;
                }

                if (fMapProcessed.get(transUnit.getSource()) != null) {
                    // ɓœo^ς݂łB

                    final BlancoXliffTransUnit registered = (BlancoXliffTransUnit) fMapProcessed
                            .get(transUnit.getSource());

                    // note ]{I
                    for (int index = 0; index < transUnit.getNoteList().size(); index++) {
                        final BlancoXliffNote note = (BlancoXliffNote) transUnit
                                .getNoteList().get(index);
                        registered.getNoteList().add(note);
                    }

                    continue;
                }
                fMapProcessed.put(transUnit.getSource(), transUnit);

                final BlancoNLpackGeneratorResultDetailCsvRecord record = new BlancoNLpackGeneratorResultDetailCsvRecord();

                record.setBundleUri(transUnit.getId());
                if (fPleiadesDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_NOT_FOUND) {
                    if (fInput.getIsoutputadd()) {
                        // tOĂ鎞ǉ܂B
                        listNew.add(record);
                    }
                    record.setAction("add");
                    record.setNote("");
                } else {
                    if (fInput.getIsoutputchange()) {
                        // tOĂ鎞ǉ܂B
                        listChange.add(record);
                    }
                    record.setAction("change");
                    record.setNote("[" + pleiadesTrans + "]");
                }

                record.setInput(transUnit.getSource());
                record.setOutput(transUnit.getTarget().getTarget());

                for (int index = 0; index < transUnit.getNoteList().size(); index++) {
                    final BlancoXliffNote note = (BlancoXliffNote) transUnit
                            .getNoteList().get(index);

                    String from = BlancoStringUtil.null2Blank(note.getFrom());
                    if (from.length() > 0) {
                        from += ":";
                    }
                    record.setNote(record.getNote() + " [" + from
                            + note.getText() + "]");
                }
            }
        }

        // xliff͏݂͂܂B
    }

    /**
     * noteĎ擾܂B
     * 
     * @param transUnit
     * @param from
     * @param textString
     * @return
     */
    private BlancoXliffNote getNoteOmitTm(final BlancoXliffTransUnit transUnit) {
        for (int index = 0; index < transUnit.getNoteList().size(); index++) {
            final BlancoXliffNote note = (BlancoXliffNote) transUnit
                    .getNoteList().get(index);
            if (BlancoStringUtil.null2Blank(note.getFrom()).equals(
                    BlancoNLpackGeneratorConstants.PRODUCT_NAME_LOWER
                            + ".omit.tm") == false) {
                // from̂̂̓XLbv܂B
                continue;
            }

            // from v܂B
            return note;
        }

        return null;
    }
}
