/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator.task;

import java.io.File;
import java.io.IOException;

import blanco.commons.util.BlancoStringUtil;
import blanco.nlpack.generator.dictionary.BlancoNLpackGeneratorPleiadesDictionary;
import blanco.nlpack.generator.message.BlancoNLpackGeneratorMessage;
import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorTranslateXliffByPleiadesProcessInput;
import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffTarget;
import blanco.xliff.valueobject.BlancoXliffTool;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoNLpackGeneratorTranslateXliffByPleiadesProcessImpl implements
        BlancoNLpackGeneratorTranslateXliffByPleiadesProcess {
    private BlancoNLpackGeneratorTranslateXliffByPleiadesProcessInput fInput = null;

    /**
     * bZ[WIuWFNgB
     */
    private final BlancoNLpackGeneratorMessage fMsg = new BlancoNLpackGeneratorMessage();

    /**
     * Pleiades̃CX^XB
     */
    private BlancoNLpackGeneratorPleiadesDictionary fPleiadesDictionary = new BlancoNLpackGeneratorPleiadesDictionary();

    private int fTransCount = 0;

    private int fAltTransCount = 0;

    private String fPrevBundleSymbolicName = null;

    private BlancoXliff fXliff = null;

    /**
     * NXCX^Xďsۂ̃Gg|CgłB
     * 
     * @param input
     *            ̓̓p[^B
     * @return ̎sʁB
     * @throws IOException
     *             o͗OꍇB
     * @throws IllegalArgumentException
     *             ͒lɕsꍇB
     */
    public int execute(
            final BlancoNLpackGeneratorTranslateXliffByPleiadesProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        if (fInput.getSettarget() == false && fInput.getSettargetoverwrite()) {
            throw new IllegalArgumentException(
                    "settargetoverwrite 𗘗pꍇɂ settarget  true ɐݒ肵ĂB");
        }

        if (fInput.getSettarget() == false && fInput.getSetalttrans() == false) {
            throw new IllegalArgumentException(
                    "settarget ܂ setalttrans ̂ꂩ true ɐݒ肵ĂB");
        }

        // LbṼNAB
        fPrevBundleSymbolicName = null;

        final File fileXliffdir = new File(input.getXliffdir());

        if (fileXliffdir.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ xliffdir["
                    + fileXliffdir.getAbsolutePath() + "]܂B");
        }
        if (fileXliffdir.isDirectory() == false) {
            throw new IllegalArgumentException("w肳ꂽ xliffdir["
                    + fileXliffdir.getAbsolutePath() + "]̓fBNgł͂܂B");
        }

        final File[] files = fileXliffdir.listFiles();
        if (files == null) {
            return 0;
        }
        for (int index = 0; index < files.length; index++) {
            if (files[index].isFile() == false) {
                continue;
            }
            if (files[index].getName().endsWith(".xlf")) {
                process(fileXliffdir, files[index]);
            }
        }

        return 0;
    }

    private void process(final File fileXliffdir, final File fileTarget)
            throws IOException {
        fTransCount = 0;
        fAltTransCount = 0;

        final String bundleSymbolicName = fileTarget.getName().substring(0,
                fileTarget.getName().length() - ".xlf".length());

        if (bundleSymbolicName.equals(fPrevBundleSymbolicName)) {
            // LbVqbg܂B[h܂B
        } else {
            fXliff = BlancoXliffUtil.getXliffInstance(fileXliffdir,
                    bundleSymbolicName);
            fPrevBundleSymbolicName = bundleSymbolicName;
        }

        for (int indexFile = 0; indexFile < fXliff.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) fXliff.getFileList()
                    .get(indexFile);
            processFile(file);
        }

        switch (BlancoXliffUtil.saveXliffInstance(fXliff, fileXliffdir,
                bundleSymbolicName)) {
        case 1:
            // {IɁAɂ͓Ȃ݁B
            if (fInput.getVerbose()) {
                System.out.println("xliff: trans: pleiades: create: "
                        + bundleSymbolicName);
            }
            break;
        case 2:
            if (fInput.getVerbose()) {
                System.out.println("xliff: trans: pleiades: "
                        + bundleSymbolicName + ": t=" + fTransCount + ", a="
                        + fAltTransCount);
            }
            break;
        }
    }

    private void processFile(final BlancoXliffFile file) {
        boolean isToolModified = false;
        for (int index = 0; index < file.getBody().getTransUnitList().size(); index++) {
            final BlancoXliffTransUnit transUnit = (BlancoXliffTransUnit) file
                    .getBody().getTransUnitList().get(index);

            if (transUnit.getTranslate() == false) {
                // OځB
                continue;
            }

            final String outputValue = fPleiadesDictionary
                    .lookup(BlancoStringUtil.null2Blank(transUnit.getSource()));
            if (outputValue == null) {
                throw new IllegalArgumentException(fMsg.getMbebc003(transUnit
                        .getId(), "L[(?)"));
            }

            if (fPleiadesDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_NOT_FOUND) {
                // ɌȂꍇB

                // ܂B
                continue;
            }

            if (fPleiadesDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_MNEMONIC_CHANGED) {
                // j[jbNϊ̂ݎ{ꂽꍇB

                // o͒lZbgI
                if (transUnit.getTarget() == null) {
                    // targetݒ̏ꍇɂ̂݁A̓eZbg܂B
                    fTransCount++;
                    setTarget(transUnit, outputValue);
                }
                if (BlancoNLpackGeneratorTranslateXliffByNLpackProcessImpl
                        .setAltTransTarget("pleiades", transUnit, transUnit
                                .getSource(), outputValue)) {
                    fAltTransCount++;
                    isToolModified = true;
                }
                continue;
            }

            if (fPleiadesDictionary.getFoundStatus() == BlancoNLpackGeneratorPleiadesDictionary.STATUS_FOUND) {
                // ̈ĂɐꍇB

                if (fInput.getSettarget()) {
                    // o͒lZbgI
                    if (fInput.getSettargetoverwrite()
                            || transUnit.getTarget() == null) {
                        // ㏑ ܂ targetݒ̏ꍇɂ̂݁A̓eZbg܂B
                        fTransCount++;
                        setTarget(transUnit, outputValue);
                    }
                }

                if (fInput.getSetalttrans()) {
                    if (BlancoNLpackGeneratorTranslateXliffByNLpackProcessImpl
                            .setAltTransTarget("pleiades", transUnit, transUnit
                                    .getSource(), outputValue)) {
                        fAltTransCount++;
                        isToolModified = true;
                    }
                }

                continue;
            }

            throw new IllegalArgumentException("z肳ȂӏɓĂ܂B");
        }

        if (isToolModified) {
            final BlancoXliffTool tool = new BlancoXliffTool();
            tool.setToolId("pleiades");
            tool.setToolName("Pleiades");
            BlancoXliffUtil.setTool(file.getHeader(), tool);

        }
    }

    private void setTarget(final BlancoXliffTransUnit transUnit,
            final String outputValue) {
        if (transUnit.getTarget() == null) {
            transUnit.setTarget(new BlancoXliffTarget());
        }

        if (BlancoStringUtil.null2Blank(outputValue).equals(
                transUnit.getTarget().getTarget()) == false) {
            // lႤ̂ŃZbg܂B
            transUnit.getTarget().setTarget(outputValue);
            // @BIɃZbgꂽ̂ŁAr[KvtOZbg܂B
            transUnit.getTarget().setState("needs-review-translation");
        }
    }
}
