/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoSort]̃NX
 */
package blanco.sort.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.sort.task.valueobject.BlancoSortProcessInput;

/**
 * Apache Ant^XN [BlancoSort]̃NXB
 *
 * sorts邽߂AntTaskłB<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.sort.task]BlancoSortBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancosort&quot; classname=&quot;blanco.sort.task.BlancoSortTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoSortTask extends Task {
    /**
     * sorts邽߂AntTaskłB
     */
    protected BlancoSortProcessInput fInput = new BlancoSortProcessInput();

    /**
     * sorts邽߂AntTaskłB
     */
    protected boolean fIsFieldInputProcessed = false;

    /**
     * sorts邽߂AntTaskłB
     */
    protected boolean fIsFieldOutputProcessed = false;

    /**
     * sorts邽߂AntTaskłB
     */
    protected boolean fIsFieldEncodingProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[input]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * ̓t@Cw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setInput(final String arg) {
        fInput.setInput(arg);
        fIsFieldInputProcessed = true;
    }

    /**
     * Ant^XN[input]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * ̓t@Cw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getInput() {
        return fInput.getInput();
    }

    /**
     * Ant^XN[output]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 2<br>
     * o̓t@Cw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setOutput(final String arg) {
        fInput.setOutput(arg);
        fIsFieldOutputProcessed = true;
    }

    /**
     * Ant^XN[output]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 2<br>
     * o̓t@Cw肵܂B<br>
     * K{Agr[głBApache Ant^XNŕKlw肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getOutput() {
        return fInput.getOutput();
    }

    /**
     * Ant^XN[encoding]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 3<br>
     * t@C̃GR[hw肵܂B<br>
     *
     * @param arg Zbgl
     */
    public void setEncoding(final String arg) {
        fInput.setEncoding(arg);
        fIsFieldEncodingProcessed = true;
    }

    /**
     * Ant^XN[encoding]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 3<br>
     * t@C̃GR[hw肵܂B<br>
     * ftHgl[Windows-31J]ݒ肳Ă܂BApache Ant^XNŃAgr[g̎w肪ꍇɂ́AftHglݒ肳܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getEncoding() {
        return fInput.getEncoding();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    public final void execute() throws BuildException {
        System.out.println("BlancoSortTask begin.");

        // ڔԍ[1]AAgr[g[input]͕K{͂łB̓`FbNs܂B
        if (fIsFieldInputProcessed == false) {
            throw new BuildException("K{Agr[g[input]ݒ肳Ă܂B𒆒f܂B");
        }
        // ڔԍ[2]AAgr[g[output]͕K{͂łB̓`FbNs܂B
        if (fIsFieldOutputProcessed == false) {
            throw new BuildException("K{Agr[g[output]ݒ肳Ă܂B𒆒f܂B");
        }

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- input:[" + getInput() + "]");
            System.out.println("- output:[" + getOutput() + "]");
            System.out.println("- encoding:[" + getEncoding() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoSortProcessC^tF[X blanco.sort.taskpbP[W BlancoSortProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoSortProcess proc = new BlancoSortProcessImpl();
            if (proc.execute(fInput) != BlancoSortBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
