/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.dictionary;

import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.zip.ZipFile;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.dictionary.SpellDictionaryException;
import org.dts.spell.dictionary.myspell.MySpell;
import org.dts.spell.dictionary.myspell.Utils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenOfficeSpellDictionary
implements SpellDictionary {
    private File personalDict;
    private MySpell mySpell;
    private boolean isLoaded = false;
    private Future loader = null;

    public OpenOfficeSpellDictionary(InputStream affIS, InputStream dicIS) throws IOException {
        this(affIS, dicIS, true);
    }

    public OpenOfficeSpellDictionary(InputStream affIS, InputStream dicIS, boolean inBackground) throws IOException {
        this(affIS, dicIS, new File(new StringBuffer(String.valueOf(System.getProperty("user.home"))).append(File.separatorChar).append("dictionary.per").toString()), true);
    }

    public OpenOfficeSpellDictionary(final InputStream affIS, final InputStream dicIS, final File personalDict, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable(){

                public Object call() throws Exception {
                    OpenOfficeSpellDictionary.this.initFromStreams(affIS, dicIS, personalDict);
                    dicIS.close();
                    affIS.close();
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromStreams(affIS, dicIS, personalDict);
        }
    }

    public OpenOfficeSpellDictionary(ZipFile zipFile) throws IOException {
        this(zipFile, true);
    }

    public OpenOfficeSpellDictionary(final ZipFile zipFile, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable(){

                public Object call() throws Exception {
                    OpenOfficeSpellDictionary.this.initFromZipFile(zipFile);
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromZipFile(zipFile);
        }
    }

    public OpenOfficeSpellDictionary(InputStream zipStream, File personalDict) throws IOException {
        this(zipStream, personalDict, true);
    }

    public OpenOfficeSpellDictionary(final InputStream zipStream, final File personalDict, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable(){

                public Object call() throws Exception {
                    OpenOfficeSpellDictionary.this.initFromStream(zipStream, personalDict);
                    zipStream.close();
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromStream(zipStream, personalDict);
        }
    }

    public OpenOfficeSpellDictionary(File file) throws IOException {
        this(file, true);
    }

    public OpenOfficeSpellDictionary(File file, boolean inBackground) throws IOException {
        this(new File(new StringBuffer().append(OpenOfficeSpellDictionary.extractRootFile(file)).append(".dic").toString()), new File(new StringBuffer().append(OpenOfficeSpellDictionary.extractRootFile(file)).append(".aff").toString()), inBackground);
    }

    public OpenOfficeSpellDictionary(File dictFile, File affFile) throws IOException {
        this(dictFile, affFile, true);
    }

    public OpenOfficeSpellDictionary(File dictFile, File affFile, boolean inBackground) throws IOException {
        this.initFromFiles(dictFile, affFile, inBackground);
    }

    private static File extractRootFile(File file) {
        String name = file.getName();
        int index = name.lastIndexOf(46);
        String rootName = index != -1 ? name.substring(0, index) : name;
        return new File(file.getParent(), rootName);
    }

    private void initFromFiles(final File dictFile, final File affFile, boolean inBackground) throws IOException {
        if (inBackground) {
            final ExecutorService executor = Executors.newSingleThreadExecutor();
            this.loader = executor.submit(new Callable(){

                public Object call() throws Exception {
                    OpenOfficeSpellDictionary.this.initFromFiles(dictFile, affFile);
                    executor.shutdown();
                    return null;
                }
            });
        } else {
            this.initFromFiles(dictFile, affFile);
        }
    }

    private void initFromFiles(File dictFile, File affFile) throws IOException {
        this.personalDict = this.getPersonalWordsFile(OpenOfficeSpellDictionary.extractRootFile(dictFile));
        this.mySpell = new MySpell(affFile.getPath(), dictFile.getPath());
        this.readPersonalWords(this.personalDict);
    }

    private void initFromZipFile(ZipFile zipFile) throws IOException {
        this.personalDict = this.getPersonalWordsFile(OpenOfficeSpellDictionary.extractRootFile(new File(zipFile.getName())));
        this.mySpell = new MySpell(zipFile);
        this.readPersonalWords(this.personalDict);
    }

    private void initFromStream(InputStream zipStream, File personalDict) throws IOException {
        this.personalDict = personalDict;
        this.mySpell = new MySpell(zipStream);
        this.readPersonalWords(personalDict);
    }

    private void initFromStreams(InputStream dicIS, InputStream affIS, File personalDict) throws IOException {
        this.personalDict = personalDict;
        this.mySpell = new MySpell(dicIS, affIS);
        this.readPersonalWords(personalDict);
    }

    @Override
    public void addWord(String word) throws SpellDictionaryException {
        this.waitToLoad();
        PrintWriter pw = null;
        word = word.trim();
        try {
            try {
                pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.personalDict, true), this.mySpell.get_dic_encoding()));
                this.mySpell.addCustomWord(word);
                pw.println(word);
            }
            catch (Exception ex) {
                throw new SpellDictionaryException(ex);
            }
        }
        catch (Throwable throwable) {
            try {
                Utils.close(pw);
            }
            catch (IOException e) {
                throw new SpellDictionaryException(e);
            }
            throw throwable;
        }
        try {
            Utils.close(pw);
        }
        catch (IOException e) {
            throw new SpellDictionaryException(e);
        }
    }

    @Override
    public boolean isCorrect(String word) {
        this.waitToLoad();
        return this.mySpell.spell(word);
    }

    @Override
    public List<String> getSuggestions(String word) {
        this.waitToLoad();
        return this.mySpell.suggest(word);
    }

    @Override
    public List<String> getSuggestions(String word, int nMax) {
        this.waitToLoad();
        return this.mySpell.suggest(word, nMax);
    }

    private void waitToLoad() {
        try {
            if (this.loader != null && !this.loader.isDone()) {
                this.loader.get();
                this.loader = null;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private File getPersonalWordsFile(File rootFile) {
        return new File(rootFile.getParent(), new StringBuffer(String.valueOf(rootFile.getName())).append(".per").toString());
    }

    private void readPersonalWords(File personalFile) throws IOException {
        BufferedReader rd = null;
        try {
            if (personalFile != null && personalFile.exists() && !personalFile.isDirectory()) {
                rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(personalFile), this.mySpell.get_dic_encoding()));
                String line = rd.readLine();
                while (line != null) {
                    this.mySpell.addCustomWord(line.trim());
                    line = rd.readLine();
                }
            }
        }
        finally {
            Utils.close(rd);
        }
    }
}

