/*
 * Decompiled with CFR 0.152.
 */
package org.dts.spell.tokenizer;

import java.text.CharacterIterator;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;

public class CharIteratorAdapter
implements CharacterIterator {
    private CharSequence sequence;
    int index = 0;

    public CharIteratorAdapter() {
        this("");
    }

    public CharIteratorAdapter(CharSequence sequence) {
        this.sequence = sequence;
    }

    public char first() {
        this.index = this.getBeginIndex();
        return this.current();
    }

    public char last() {
        this.index = this.sequence.length() == 0 ? this.getEndIndex() : this.getEndIndex() - 1;
        return this.current();
    }

    public char current() {
        if (this.sequence.length() > this.index) {
            return this.sequence.charAt(this.index);
        }
        return '\uffff';
    }

    public char next() {
        char result;
        int endIndex = this.getEndIndex();
        ++this.index;
        if (this.index >= endIndex) {
            this.index = endIndex;
            result = '\uffff';
        } else {
            result = this.sequence.charAt(this.index);
        }
        return result;
    }

    public char previous() {
        char result;
        int beginIndex = this.getBeginIndex();
        --this.index;
        if (this.index <= beginIndex) {
            this.index = beginIndex;
            result = '\uffff';
        } else {
            result = this.sequence.charAt(this.index);
        }
        return result;
    }

    public char setIndex(int position) {
        if (position < this.getBeginIndex() || position > this.getEndIndex()) {
            throw new IllegalArgumentException(MessageFormat.format(ResourceBundle.getBundle("org/dts/spell/messages").getString("INVALID_POSITION"), Integer_.valueOf((int)position), Integer_.valueOf((int)this.getBeginIndex()), Integer_.valueOf((int)this.getEndIndex())));
        }
        this.index = position;
        return this.current();
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.sequence.length();
    }

    public int getIndex() {
        return this.index;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CharSequence getCharSequence() {
        return this.sequence;
    }

    public void setCharSequence(CharSequence sequence) {
        this.setCharSequence(sequence, true);
    }

    public void setCharSequence(CharSequence sequence, boolean resetIndex) {
        this.sequence = sequence;
        if (resetIndex) {
            this.index = 0;
        }
    }
}

